/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsArrayLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.declaration.DeclarationBodyVisitor;
import org.jetbrains.k2js.translate.declaration.PropertyTranslator;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.initializer.InitializerUtils;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PsiUtils;
import org.jetbrains.k2js.translate.utils.TranslationUtils;

public final class ClassTranslator
extends AbstractTranslator {
    @NotNull
    private final DeclarationBodyVisitor declarationBodyVisitor = new DeclarationBodyVisitor();
    @NotNull
    private final JetClassOrObject classDeclaration;
    @Nullable
    private TemporaryVariable aliasForContainingClassThis = null;
    @NotNull
    private final ClassDescriptor descriptor;
    @NotNull
    private final Map<JsName, JsName> aliasingMap;

    @NotNull
    public static JsPropertyInitializer translateAsProperty(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        JsExpression classCreationExpression = ClassTranslator.generateClassCreationExpression(classDeclaration, context);
        JsName className = context.getNameForElement(classDeclaration);
        return new JsPropertyInitializer(className.makeRef(), classCreationExpression);
    }

    @NotNull
    public static JsExpression generateClassCreationExpression(@NotNull JetClassOrObject classDeclaration, @NotNull Map<JsName, JsName> aliasingMap, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, aliasingMap, context).translateClassOrObjectCreation();
    }

    @NotNull
    public static JsExpression generateClassCreationExpression(@NotNull JetClassOrObject classDeclaration, @NotNull TranslationContext context) {
        return new ClassTranslator(classDeclaration, Collections.<JsName, JsName>emptyMap(), context).translateClassOrObjectCreation();
    }

    @NotNull
    public static JsExpression generateObjectLiteralExpression(@NotNull JetObjectLiteralExpression objectLiteralExpression, @NotNull TranslationContext context) {
        return new ClassTranslator(objectLiteralExpression.getObjectDeclaration(), Collections.<JsName, JsName>emptyMap(), context).translateObjectLiteralExpression();
    }

    private ClassTranslator(@NotNull JetClassOrObject classDeclaration, @NotNull Map<JsName, JsName> aliasingMap, @NotNull TranslationContext context) {
        super(context.newDeclaration(classDeclaration));
        this.aliasingMap = aliasingMap;
        this.descriptor = BindingUtils.getClassDescriptor(context.bindingContext(), classDeclaration);
        this.classDeclaration = classDeclaration;
    }

    @NotNull
    private JsExpression translateObjectLiteralExpression() {
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        if (containingClass == null) {
            return this.translateClassOrObjectCreation();
        }
        return this.translateAsObjectCreationExpressionWithEnclosingThisSaved(containingClass);
    }

    @NotNull
    private JsExpression translateAsObjectCreationExpressionWithEnclosingThisSaved(@NotNull ClassDescriptor containingClass) {
        this.aliasForContainingClassThis = this.context().declareTemporary(TranslationUtils.getThisObject(this.context(), containingClass));
        return AstUtil.newSequence(this.aliasForContainingClassThis.assignmentExpression(), this.translateClassOrObjectCreation());
    }

    @NotNull
    private JsExpression translateClassOrObjectCreation() {
        JsInvocation jsClassDeclaration = this.classCreateMethodInvocation();
        if (!this.isObject()) {
            this.addSuperclassReferences(jsClassDeclaration);
        }
        this.addClassOwnDeclarations(jsClassDeclaration);
        return jsClassDeclaration;
    }

    @NotNull
    private JsInvocation classCreateMethodInvocation() {
        if (this.isObject()) {
            return AstUtil.newInvocation(this.context().namer().objectCreationMethodReference(), new JsExpression[0]);
        }
        if (this.isTrait() && !this.context().isEcma5()) {
            return AstUtil.newInvocation(this.context().namer().traitCreationMethodReference(), new JsExpression[0]);
        }
        return AstUtil.newInvocation(this.context().namer().classCreationMethodReference(), new JsExpression[0]);
    }

    private boolean isObject() {
        return this.descriptor.getKind().equals((Object)ClassKind.OBJECT);
    }

    private boolean isTrait() {
        return this.descriptor.getKind().equals((Object)ClassKind.TRAIT);
    }

    private void addClassOwnDeclarations(@NotNull JsInvocation jsClassDeclaration) {
        TranslationContext classDeclarationContext = this.getClassDeclarationContext();
        JsObjectLiteral properties = new JsObjectLiteral();
        List<JsPropertyInitializer> propertyList = properties.getPropertyInitializers();
        if (!this.isTrait()) {
            JsFunction initializer = Translation.generateClassInitializerMethod(this.classDeclaration, classDeclarationContext);
            if (this.context().isEcma5()) {
                jsClassDeclaration.getArguments().add(this.isObject() ? initializer : JsAstUtils.encloseFunction(initializer));
            } else {
                propertyList.add(InitializerUtils.generateInitializeMethod(initializer));
            }
        } else if (this.context().isEcma5()) {
            jsClassDeclaration.getArguments().add(this.context().program().getNullLiteral());
        }
        propertyList.addAll(this.translatePropertiesAsConstructorParameters(classDeclarationContext));
        propertyList.addAll(this.declarationBodyVisitor.traverseClass(this.classDeclaration, classDeclarationContext));
        if (!propertyList.isEmpty() || !this.context().isEcma5()) {
            jsClassDeclaration.getArguments().add(properties);
        }
    }

    private void addSuperclassReferences(@NotNull JsInvocation jsClassDeclaration) {
        List<JsExpression> superClassReferences = this.getSuperclassNameReferences();
        List<JsExpression> expressions = jsClassDeclaration.getArguments();
        if (this.context().isEcma5()) {
            if (superClassReferences.isEmpty()) {
                jsClassDeclaration.getArguments().add(this.context().program().getNullLiteral());
                return;
            }
            if (superClassReferences.size() > 1) {
                JsArrayLiteral arrayLiteral = new JsArrayLiteral();
                jsClassDeclaration.getArguments().add(arrayLiteral);
                expressions = arrayLiteral.getExpressions();
            }
        }
        for (JsExpression superClassReference : superClassReferences) {
            expressions.add(superClassReference);
        }
    }

    @NotNull
    private List<JsExpression> getSuperclassNameReferences() {
        ArrayList<JsExpression> superclassReferences = new ArrayList<JsExpression>();
        List<ClassDescriptor> superclassDescriptors = JsDescriptorUtils.getSuperclassDescriptors(this.descriptor);
        this.addAncestorClass(superclassReferences, superclassDescriptors);
        this.addTraits(superclassReferences, superclassDescriptors);
        return superclassReferences;
    }

    private void addTraits(@NotNull List<JsExpression> superclassReferences, @NotNull List<ClassDescriptor> superclassDescriptors) {
        for (ClassDescriptor superClassDescriptor : superclassDescriptors) {
            assert (superClassDescriptor.getKind() == ClassKind.TRAIT) : "Only traits are expected here";
            superclassReferences.add(this.getClassReference(superClassDescriptor));
        }
    }

    private void addAncestorClass(@NotNull List<JsExpression> superclassReferences, @NotNull List<ClassDescriptor> superclassDescriptors) {
        ClassDescriptor ancestorClass = ClassTranslator.findAndRemoveAncestorClass(superclassDescriptors);
        if (ancestorClass != null) {
            superclassReferences.add(this.getClassReference(ancestorClass));
        }
    }

    @NotNull
    private JsExpression getClassReference(@NotNull ClassDescriptor superClassDescriptor) {
        JsName name = this.context().getNameForDescriptor(superClassDescriptor);
        JsName alias = this.aliasingMap.get(name);
        if (alias != null) {
            return alias.makeRef();
        }
        return TranslationUtils.getQualifiedReference(this.context(), superClassDescriptor);
    }

    @Nullable
    private static ClassDescriptor findAndRemoveAncestorClass(@NotNull List<ClassDescriptor> superclassDescriptors) {
        ClassDescriptor ancestorClass = JsDescriptorUtils.findAncestorClass(superclassDescriptors);
        superclassDescriptors.remove(ancestorClass);
        return ancestorClass;
    }

    @NotNull
    private List<JsPropertyInitializer> translatePropertiesAsConstructorParameters(@NotNull TranslationContext classDeclarationContext) {
        ArrayList<JsPropertyInitializer> result = new ArrayList<JsPropertyInitializer>();
        for (JetParameter parameter : PsiUtils.getPrimaryConstructorParameters(this.classDeclaration)) {
            PropertyDescriptor descriptor = BindingUtils.getPropertyDescriptorForConstructorParameter(this.bindingContext(), parameter);
            if (descriptor == null) continue;
            result.addAll(PropertyTranslator.translateAccessors(descriptor, classDeclarationContext));
        }
        return result;
    }

    @NotNull
    private TranslationContext getClassDeclarationContext() {
        if (this.aliasForContainingClassThis == null) {
            return this.context();
        }
        ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(this.descriptor);
        assert (containingClass != null);
        return this.context().innerContextWithThisAliased(containingClass, this.aliasForContainingClassThis.name());
    }
}

