/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.declaration;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.BiMap;
import org.jetbrains.jet.internal.com.google.common.collect.HashBiMap;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsObjectLiteral;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsReturn;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.TranslationContext;
import org.jetbrains.k2js.translate.general.AbstractTranslator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.translate.utils.BindingUtils;
import org.jetbrains.k2js.translate.utils.ClassSortingUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;

public final class ClassDeclarationTranslator
extends AbstractTranslator {
    @NotNull
    private final List<ClassDescriptor> descriptors;
    @NotNull
    private final BiMap<JsName, JsName> localToGlobalClassName;
    @NotNull
    private final JsFunction dummyFunction;
    @Nullable
    private JsName declarationsObject = null;
    @Nullable
    private JsStatement declarationsStatement = null;

    public ClassDeclarationTranslator(@NotNull List<ClassDescriptor> descriptors, @NotNull TranslationContext context) {
        super(context);
        this.descriptors = descriptors;
        this.localToGlobalClassName = HashBiMap.create();
        this.dummyFunction = new JsFunction(context.jsScope());
    }

    public void generateDeclarations() {
        this.declarationsObject = this.context().jsScope().declareName(Namer.nameForClassesVariable());
        assert (this.declarationsObject != null);
        this.declarationsStatement = JsAstUtils.newVar(this.declarationsObject, this.generateDummyFunctionInvocation());
    }

    @NotNull
    public JsName getDeclarationsObjectName() {
        assert (this.declarationsObject != null) : "Should run generateDeclarations first";
        return this.declarationsObject;
    }

    @NotNull
    public JsStatement getDeclarationsStatement() {
        assert (this.declarationsStatement != null) : "Should run generateDeclarations first";
        return this.declarationsStatement;
    }

    @NotNull
    private JsInvocation generateDummyFunctionInvocation() {
        List<JsStatement> classDeclarations = this.generateClassDeclarationStatements();
        classDeclarations.add(new JsReturn(this.generateReturnedObjectLiteral()));
        this.dummyFunction.setBody(JsAstUtils.newBlock(classDeclarations));
        return AstUtil.newInvocation(this.dummyFunction, new JsExpression[0]);
    }

    @NotNull
    private JsObjectLiteral generateReturnedObjectLiteral() {
        JsObjectLiteral returnedValueLiteral = new JsObjectLiteral();
        for (JsName localName : this.localToGlobalClassName.keySet()) {
            returnedValueLiteral.getPropertyInitializers().add(this.classEntry(localName));
        }
        return returnedValueLiteral;
    }

    @NotNull
    private JsPropertyInitializer classEntry(@NotNull JsName localName) {
        return new JsPropertyInitializer(((JsName)this.localToGlobalClassName.get(localName)).makeRef(), localName.makeRef());
    }

    @NotNull
    private List<JsStatement> generateClassDeclarationStatements() {
        ArrayList<JsStatement> classDeclarations = new ArrayList<JsStatement>();
        for (JetClass jetClass : this.getClassDeclarations()) {
            classDeclarations.add(this.generateDeclaration(jetClass));
        }
        return classDeclarations;
    }

    @NotNull
    private List<JetClass> getClassDeclarations() {
        ArrayList<JetClass> classes = new ArrayList<JetClass>();
        for (ClassDescriptor classDescriptor : this.descriptors) {
            classes.add(BindingUtils.getClassForDescriptor(this.bindingContext(), classDescriptor));
        }
        return ClassSortingUtils.sortUsingInheritanceOrder(classes, this.bindingContext());
    }

    @NotNull
    private JsStatement generateDeclaration(@NotNull JetClass declaration) {
        JsName localClassName = this.generateLocalAlias(declaration);
        JsExpression classDeclarationExpression = Translation.translateClassDeclaration(declaration, this.localToGlobalClassName.inverse(), this.context());
        return JsAstUtils.newVar(localClassName, classDeclarationExpression);
    }

    @NotNull
    private JsName generateLocalAlias(@NotNull JetClass declaration) {
        JsName globalClassName = this.context().getNameForElement(declaration);
        JsName localAlias = this.dummyFunction.getScope().declareTemporary();
        this.localToGlobalClassName.put(localAlias, globalClassName);
        return localAlias;
    }

    @NotNull
    public List<JsPropertyInitializer> classDeclarationsForNamespace(@NotNull NamespaceDescriptor namespaceDescriptor) {
        ArrayList<JsPropertyInitializer> result = Lists.newArrayList();
        for (ClassDescriptor classDescriptor : JsDescriptorUtils.getAllClassesDefinedInNamespace(namespaceDescriptor)) {
            result.add(this.getClassNameToClassObject(classDescriptor));
        }
        return result;
    }

    @NotNull
    private JsPropertyInitializer getClassNameToClassObject(@NotNull ClassDescriptor classDescriptor) {
        JsName className = this.context().getNameForDescriptor(classDescriptor);
        JsNameRef alreadyDefinedClassReference = JsAstUtils.qualified(className, this.getDeclarationsObjectName().makeRef());
        return new JsPropertyInitializer(className.makeRef(), alreadyDefinedClassReference);
    }
}

