/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsStatement;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.k2js.translate.context.AliasingContext;
import org.jetbrains.k2js.translate.context.DynamicContext;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.NamingScope;
import org.jetbrains.k2js.translate.context.StaticContext;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.intrinsic.Intrinsics;
import org.jetbrains.k2js.translate.utils.BindingUtils;

public final class TranslationContext {
    @NotNull
    private final DynamicContext dynamicContext;
    @NotNull
    private final StaticContext staticContext;
    @NotNull
    private final AliasingContext aliasingContext;

    @NotNull
    public static TranslationContext rootContext(@NotNull StaticContext staticContext) {
        JsProgram program = staticContext.getProgram();
        JsBlock globalBlock = program.getGlobalBlock();
        DynamicContext rootDynamicContext = DynamicContext.rootContext(staticContext.getRootScope(), globalBlock);
        AliasingContext rootAliasingContext = AliasingContext.getCleanContext();
        return new TranslationContext(staticContext, rootDynamicContext, rootAliasingContext);
    }

    public boolean isEcma5() {
        return this.staticContext.isEcma5();
    }

    private TranslationContext(@NotNull StaticContext staticContext, @NotNull DynamicContext dynamicContext, @NotNull AliasingContext context) {
        this.dynamicContext = dynamicContext;
        this.staticContext = staticContext;
        this.aliasingContext = context;
    }

    @NotNull
    public TranslationContext contextWithScope(@NotNull NamingScope newScope, @NotNull JsBlock block) {
        return new TranslationContext(this.staticContext, DynamicContext.newContext(newScope, block), this.aliasingContext);
    }

    @NotNull
    public TranslationContext innerBlock(@NotNull JsBlock block) {
        return new TranslationContext(this.staticContext, this.dynamicContext.innerBlock(block), this.aliasingContext);
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull DeclarationDescriptor descriptor) {
        return this.contextWithScope(this.getScopeForDescriptor(descriptor), this.getBlockForDescriptor(descriptor));
    }

    @NotNull
    public TranslationContext innerContextWithGivenScopeAndBlock(@NotNull JsScope scope, @NotNull JsBlock block) {
        return this.contextWithScope(this.dynamicContext.getScope().innerScope(scope), block);
    }

    @NotNull
    public TranslationContext innerContextWithThisAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsName alias) {
        return new TranslationContext(this.staticContext, this.dynamicContext, this.aliasingContext.withThisAliased(correspondingDescriptor, alias));
    }

    @NotNull
    public TranslationContext innerContextWithAliasesForExpressions(@NotNull Map<JetExpression, JsName> aliases) {
        return new TranslationContext(this.staticContext, this.dynamicContext, this.aliasingContext.withAliasesForExpressions(aliases));
    }

    @NotNull
    public TranslationContext innerContextWithDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsName> aliases) {
        return new TranslationContext(this.staticContext, this.dynamicContext, this.aliasingContext.withDescriptorsAliased(aliases));
    }

    @NotNull
    public JsBlock getBlockForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (descriptor instanceof CallableDescriptor) {
            return this.getFunctionObject((CallableDescriptor)descriptor).getBody();
        }
        return new JsBlock();
    }

    @NotNull
    public TranslationContext newDeclaration(@NotNull PsiElement element) {
        return this.newDeclaration(BindingUtils.getDescriptorForElement(this.bindingContext(), element));
    }

    @NotNull
    public BindingContext bindingContext() {
        return this.staticContext.getBindingContext();
    }

    @NotNull
    public NamingScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        return this.staticContext.getScopeForDescriptor(descriptor);
    }

    @NotNull
    public JsName getNameForElement(@NotNull PsiElement element) {
        DeclarationDescriptor descriptor = BindingUtils.getDescriptorForElement(this.bindingContext(), element);
        return this.getNameForDescriptor(descriptor);
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        JsName alias = this.aliasingContext.getAliasForDescriptor(descriptor);
        if (alias != null) {
            return alias;
        }
        return this.staticContext.getNameForDescriptor(descriptor);
    }

    @Nullable
    public JsNameRef getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        return this.staticContext.getQualifierForDescriptor(descriptor);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@NotNull JsExpression initExpression) {
        return this.dynamicContext.declareTemporary(initExpression);
    }

    @NotNull
    public Namer namer() {
        return this.staticContext.getNamer();
    }

    @NotNull
    public Intrinsics intrinsics() {
        return this.staticContext.getIntrinsics();
    }

    @NotNull
    public JsProgram program() {
        return this.staticContext.getProgram();
    }

    @NotNull
    public JsScope jsScope() {
        return this.dynamicContext.jsScope();
    }

    @NotNull
    public AliasingContext aliasingContext() {
        return this.aliasingContext;
    }

    @NotNull
    public JsFunction getFunctionObject(@NotNull CallableDescriptor descriptor) {
        return this.staticContext.getFunctionWithScope(descriptor);
    }

    public void addStatementToCurrentBlock(@NotNull JsStatement statement) {
        this.dynamicContext.jsBlock().getStatements().add(statement);
    }
}

