/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsFunction;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsRootScope;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.translate.context.Namer;
import org.jetbrains.k2js.translate.context.NamingScope;
import org.jetbrains.k2js.translate.context.StandardClasses;
import org.jetbrains.k2js.translate.context.generator.Generator;
import org.jetbrains.k2js.translate.context.generator.Rule;
import org.jetbrains.k2js.translate.intrinsic.Intrinsics;
import org.jetbrains.k2js.translate.utils.AnnotationsUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;
import org.jetbrains.k2js.translate.utils.JsDescriptorUtils;
import org.jetbrains.k2js.translate.utils.PredefinedAnnotation;

public final class StaticContext {
    @NotNull
    private final JsProgram program;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final Namer namer;
    @NotNull
    private final Intrinsics intrinsics;
    @NotNull
    private final StandardClasses standardClasses;
    @NotNull
    private final NamingScope rootScope;
    @NotNull
    private final Generator<JsName> names = new NameGenerator();
    @NotNull
    private final Generator<NamingScope> scopes = new ScopeGenerator();
    @NotNull
    private final Generator<JsNameRef> qualifiers = new QualifierGenerator();
    @NotNull
    private final Generator<Boolean> qualifierIsNull = new QualifierIsNullGenerator();
    @NotNull
    private final Map<NamingScope, JsFunction> scopeToFunction = Maps.newHashMap();
    @NotNull
    private final EcmaVersion ecmaVersion;

    public static StaticContext generateStaticContext(@NotNull JetStandardLibrary library, @NotNull BindingContext bindingContext, @NotNull EcmaVersion ecmaVersion) {
        JsProgram program = new JsProgram("main");
        JsRootScope jsRootScope = program.getRootScope();
        Namer namer = Namer.newInstance(jsRootScope);
        NamingScope scope = NamingScope.rootScope(jsRootScope);
        Intrinsics intrinsics = Intrinsics.standardLibraryIntrinsics(library);
        StandardClasses standardClasses = StandardClasses.bindImplementations(namer.getKotlinScope());
        return new StaticContext(program, bindingContext, namer, intrinsics, standardClasses, scope, ecmaVersion);
    }

    private StaticContext(@NotNull JsProgram program, @NotNull BindingContext bindingContext, @NotNull Namer namer, @NotNull Intrinsics intrinsics, @NotNull StandardClasses standardClasses, @NotNull NamingScope rootScope, @NotNull EcmaVersion ecmaVersion) {
        this.program = program;
        this.bindingContext = bindingContext;
        this.namer = namer;
        this.intrinsics = intrinsics;
        this.rootScope = rootScope;
        this.standardClasses = standardClasses;
        this.ecmaVersion = ecmaVersion;
    }

    public boolean isEcma5() {
        return this.ecmaVersion == EcmaVersion.v5;
    }

    @NotNull
    public JsProgram getProgram() {
        return this.program;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public Intrinsics getIntrinsics() {
        return this.intrinsics;
    }

    @NotNull
    public Namer getNamer() {
        return this.namer;
    }

    @NotNull
    public NamingScope getRootScope() {
        return this.rootScope;
    }

    @NotNull
    public NamingScope getScopeForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        NamingScope namingScope = this.scopes.get(descriptor.getOriginal());
        assert (namingScope != null) : "Must have a scope for descriptor";
        return namingScope;
    }

    @NotNull
    public JsFunction getFunctionWithScope(@NotNull CallableDescriptor descriptor) {
        NamingScope scope = this.getScopeForDescriptor(descriptor);
        JsFunction function = this.scopeToFunction.get(scope);
        assert (scope.jsScope().equals(function.getScope())) : "Inconsistency.";
        return function;
    }

    @NotNull
    public JsName getNameForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        JsName name = this.names.get(descriptor.getOriginal());
        assert (name != null) : "Must have name for descriptor";
        return name;
    }

    @NotNull
    private NamingScope getEnclosingScope(@NotNull DeclarationDescriptor descriptor) {
        DeclarationDescriptor containingDeclaration = JsDescriptorUtils.getContainingDeclaration(descriptor);
        return this.getScopeForDescriptor(containingDeclaration.getOriginal());
    }

    @Nullable
    public JsNameRef getQualifierForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        if (this.qualifierIsNull.get(descriptor.getOriginal()) != null) {
            return null;
        }
        return this.qualifiers.get(descriptor.getOriginal());
    }

    private static class QualifierIsNullGenerator
    extends Generator<Boolean> {
        private QualifierIsNullGenerator() {
            Rule<Boolean> propertiesHaveNoQualifiers = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof PropertyDescriptor)) {
                        return null;
                    }
                    return true;
                }
            };
            Rule<Boolean> nativeObjectsHaveNoQualifiers = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!AnnotationsUtils.isNativeObject(descriptor)) {
                        return null;
                    }
                    return true;
                }
            };
            Rule<Boolean> topLevelNamespaceHaveNoQualifier = new Rule<Boolean>(){

                @Override
                public Boolean apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    if (DescriptorUtils.isTopLevelNamespace((NamespaceDescriptor)descriptor)) {
                        return true;
                    }
                    return null;
                }
            };
            this.addRule(topLevelNamespaceHaveNoQualifier);
            this.addRule(propertiesHaveNoQualifiers);
            this.addRule(nativeObjectsHaveNoQualifiers);
        }
    }

    private final class QualifierGenerator
    extends Generator<JsNameRef> {
        public QualifierGenerator() {
            Rule<JsNameRef> standardObjectsHaveKotlinQualifier = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!StaticContext.this.standardClasses.isStandardObject(descriptor)) {
                        return null;
                    }
                    return StaticContext.this.namer.kotlinObject();
                }
            };
            Rule<JsNameRef> namespaceLevelDeclarationsHaveEnclosingNamespacesNamesAsQualifier = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    DeclarationDescriptor containingDeclaration = JsDescriptorUtils.getContainingDeclaration(descriptor);
                    if (!(containingDeclaration instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    JsName containingDeclarationName = StaticContext.this.getNameForDescriptor(containingDeclaration);
                    JsNameRef qualifier = containingDeclarationName.makeRef();
                    qualifier.setQualifier(StaticContext.this.getQualifierForDescriptor(containingDeclaration));
                    return qualifier;
                }
            };
            Rule<JsNameRef> constructorHaveTheSameQualifierAsTheClass = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ConstructorDescriptor)) {
                        return null;
                    }
                    ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
                    assert (containingClass != null) : "Can't have constructor without a class";
                    return StaticContext.this.getQualifierForDescriptor(containingClass);
                }
            };
            Rule<JsNameRef> libraryObjectsHaveKotlinQualifier = new Rule<JsNameRef>(){

                @Override
                public JsNameRef apply(@NotNull DeclarationDescriptor descriptor) {
                    if (AnnotationsUtils.isLibraryObject(descriptor)) {
                        return StaticContext.this.namer.kotlinObject();
                    }
                    return null;
                }
            };
            this.addRule(libraryObjectsHaveKotlinQualifier);
            this.addRule(constructorHaveTheSameQualifierAsTheClass);
            this.addRule(standardObjectsHaveKotlinQualifier);
            this.addRule(namespaceLevelDeclarationsHaveEnclosingNamespacesNamesAsQualifier);
        }
    }

    private final class ScopeGenerator
    extends Generator<NamingScope> {
        public ScopeGenerator() {
            Rule<NamingScope> generateNewScopesForClassesWithNoAncestors = new Rule<NamingScope>(){

                @Override
                public NamingScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    if (JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor) == null) {
                        return StaticContext.this.getRootScope().innerScope("Scope for class " + descriptor.getName());
                    }
                    return null;
                }
            };
            Rule<NamingScope> generateInnerScopesForDerivedClasses = new Rule<NamingScope>(){

                @Override
                public NamingScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ClassDescriptor)) {
                        return null;
                    }
                    ClassDescriptor superclass = JsDescriptorUtils.getSuperclass((ClassDescriptor)descriptor);
                    if (superclass == null) {
                        return null;
                    }
                    return StaticContext.this.getScopeForDescriptor(superclass).innerScope("Scope for class " + descriptor.getName());
                }
            };
            Rule<NamingScope> generateNewScopesForNamespaceDescriptors = new Rule<NamingScope>(){

                @Override
                public NamingScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    return StaticContext.this.getRootScope().innerScope("Namespace " + descriptor.getName());
                }
            };
            Rule<NamingScope> generateInnerScopesForMembers = new Rule<NamingScope>(){

                @Override
                public NamingScope apply(@NotNull DeclarationDescriptor descriptor) {
                    NamingScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    return enclosingScope.innerScope("Scope for member " + descriptor.getName());
                }
            };
            Rule<NamingScope> createFunctionObjectsForCallableDescriptors = new Rule<NamingScope>(){

                @Override
                public NamingScope apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof CallableDescriptor)) {
                        return null;
                    }
                    NamingScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    JsFunction correspondingFunction = JsAstUtils.createFunctionWithEmptyBody(enclosingScope.jsScope());
                    NamingScope newScope = enclosingScope.innerScope(correspondingFunction.getScope());
                    assert (!StaticContext.this.scopeToFunction.containsKey(newScope)) : "Scope to function value overridden for " + descriptor;
                    StaticContext.this.scopeToFunction.put(newScope, correspondingFunction);
                    return newScope;
                }
            };
            this.addRule(createFunctionObjectsForCallableDescriptors);
            this.addRule(generateNewScopesForClassesWithNoAncestors);
            this.addRule(generateInnerScopesForDerivedClasses);
            this.addRule(generateNewScopesForNamespaceDescriptors);
            this.addRule(generateInnerScopesForMembers);
        }
    }

    private final class NameGenerator
    extends Generator<JsName> {
        public NameGenerator() {
            Rule<JsName> namesForStandardClasses = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor data) {
                    if (!StaticContext.this.standardClasses.isStandardObject(data)) {
                        return null;
                    }
                    return StaticContext.this.standardClasses.getStandardObjectName(data);
                }
            };
            Rule<JsName> namespacesShouldBeDefinedInRootScope = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof NamespaceDescriptor)) {
                        return null;
                    }
                    String nameForNamespace = JsDescriptorUtils.getNameForNamespace((NamespaceDescriptor)descriptor);
                    return StaticContext.this.getRootScope().declareUnobfuscatableName(nameForNamespace);
                }
            };
            Rule<JsName> memberDeclarationsInsideParentsScope = new Rule<JsName>(){

                @Override
                @Nullable
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    NamingScope namingScope = StaticContext.this.getEnclosingScope(descriptor);
                    return namingScope.declareObfuscatableName(descriptor.getName().getName());
                }
            };
            Rule<JsName> constructorHasTheSameNameAsTheClass = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof ConstructorDescriptor)) {
                        return null;
                    }
                    ClassDescriptor containingClass = JsDescriptorUtils.getContainingClass(descriptor);
                    assert (containingClass != null) : "Can't have constructor without a class";
                    return StaticContext.this.getNameForDescriptor(containingClass);
                }
            };
            Rule<JsName> accessorsHasNamesWithSpecialPrefixes = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof PropertyAccessorDescriptor)) {
                        return null;
                    }
                    boolean isGetter = descriptor instanceof PropertyGetterDescriptor;
                    PropertyAccessorDescriptor accessorDescriptor = (PropertyAccessorDescriptor)descriptor;
                    String propertyName = accessorDescriptor.getCorrespondingProperty().getName().getName();
                    String accessorName = Namer.getNameForAccessor(propertyName, isGetter, !accessorDescriptor.getReceiverParameter().exists() && StaticContext.this.isEcma5());
                    NamingScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    return StaticContext.this.isEcma5() ? enclosingScope.declareUnobfuscatableName(accessorName) : enclosingScope.declareObfuscatableName(accessorName);
                }
            };
            Rule<JsName> predefinedObjectsHasUnobfuscatableNames = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    for (PredefinedAnnotation annotation : PredefinedAnnotation.values()) {
                        if (!AnnotationsUtils.hasAnnotationOrInsideAnnotatedClass(descriptor, annotation)) continue;
                        String name = AnnotationsUtils.getNameForAnnotatedObject(descriptor, annotation);
                        name = name != null ? name : descriptor.getName().getName();
                        return StaticContext.this.getEnclosingScope(descriptor).declareUnobfuscatableName(name);
                    }
                    return null;
                }
            };
            Rule<JsName> propertiesCorrespondToSpeciallyTreatedBackingFieldNames = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof PropertyDescriptor)) {
                        return null;
                    }
                    NamingScope enclosingScope = StaticContext.this.getEnclosingScope(descriptor);
                    if (StaticContext.this.isEcma5()) {
                        String name = descriptor.getName().getName();
                        if (JsDescriptorUtils.isAsPrivate((PropertyDescriptor)descriptor)) {
                            name = '_' + name;
                        }
                        return enclosingScope.declareUnobfuscatableName(name);
                    }
                    return enclosingScope.declareObfuscatableName(Namer.getKotlinBackingFieldName(descriptor.getName().getName()));
                }
            };
            Rule<JsName> toStringHack = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof FunctionDescriptor)) {
                        return null;
                    }
                    if (!descriptor.getName().getName().equals("toString")) {
                        return null;
                    }
                    if (((FunctionDescriptor)descriptor).getValueParameters().isEmpty()) {
                        return StaticContext.this.getEnclosingScope(descriptor).declareUnobfuscatableName("toString");
                    }
                    return null;
                }
            };
            Rule<JsName> overridingDescriptorsReferToOriginalName = new Rule<JsName>(){

                @Override
                public JsName apply(@NotNull DeclarationDescriptor descriptor) {
                    if (!(descriptor instanceof FunctionDescriptor)) {
                        return null;
                    }
                    FunctionDescriptor overriddenDescriptor = JsDescriptorUtils.getOverriddenDescriptor((FunctionDescriptor)descriptor);
                    if (overriddenDescriptor == null) {
                        return null;
                    }
                    return StaticContext.this.getNameForDescriptor(overriddenDescriptor);
                }
            };
            this.addRule(namesForStandardClasses);
            this.addRule(constructorHasTheSameNameAsTheClass);
            this.addRule(predefinedObjectsHasUnobfuscatableNames);
            this.addRule(toStringHack);
            this.addRule(propertiesCorrespondToSpeciallyTreatedBackingFieldNames);
            this.addRule(namespacesShouldBeDefinedInRootScope);
            this.addRule(overridingDescriptorsReferToOriginalName);
            this.addRule(accessorsHasNamesWithSpecialPrefixes);
            this.addRule(memberDeclarationsInsideParentsScope);
        }
    }
}

