/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.lang.resolve.name.NameUtils;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class NamingScope {
    @NotNull
    private final JsScope scope;

    @NotNull
    public static NamingScope rootScope(@NotNull JsScope rootScope) {
        return new NamingScope(rootScope);
    }

    private NamingScope(@NotNull JsScope correspondingScope) {
        this.scope = correspondingScope;
    }

    @NotNull
    public NamingScope innerScope(@NotNull String scopeName) {
        JsScope innerJsScope = new JsScope(this.jsScope(), scopeName);
        return this.innerScope(innerJsScope);
    }

    @NotNull
    public NamingScope innerScope(@NotNull JsScope correspondingScope) {
        return new NamingScope(correspondingScope);
    }

    @NotNull
    JsName declareUnobfuscatableName(@NotNull String name) {
        NameUtils.requireIdentifier(name);
        JsName declaredName = this.scope.declareName(name);
        declaredName.setObfuscatable(false);
        return declaredName;
    }

    @NotNull
    JsName declareObfuscatableName(@NotNull String name) {
        return this.scope.declareName(this.obfuscateName(name));
    }

    @NotNull
    private String obfuscateName(@NotNull String name) {
        int obfuscate = 0;
        String result = name;
        while (true) {
            JsName existingNameWithSameIdent;
            boolean isDuplicate;
            boolean bl = isDuplicate = (existingNameWithSameIdent = this.scope.findExistingName(result)) != null && JsAstUtils.ownsName(this.scope, existingNameWithSameIdent);
            if (!isDuplicate) break;
            result = name + "$" + obfuscate;
            ++obfuscate;
        }
        return result;
    }

    @NotNull
    public JsName declareTemporary() {
        return this.scope.declareTemporary();
    }

    @NotNull
    public JsScope jsScope() {
        return this.scope;
    }
}

