/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsInvocation;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsNameRef;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsPropertyInitializer;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.AstUtil;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class Namer {
    @NotNull
    private final JsName kotlinName;
    @NotNull
    private final JsScope kotlinScope;
    @NotNull
    private final JsName className;
    @NotNull
    private final JsName traitName;
    @NotNull
    private final JsName namespaceName;
    @NotNull
    private final JsName objectName;
    @NotNull
    private final JsName isTypeName;
    @NotNull
    private final JsPropertyInitializer writablePropertyDescriptorField;

    @NotNull
    public static String getReceiverParameterName() {
        return "receiver";
    }

    @NotNull
    public static String getRootNamespaceName() {
        return "Root";
    }

    @NotNull
    public static JsNameRef initializeMethodReference() {
        return AstUtil.newQualifiedNameRef("initialize");
    }

    @NotNull
    public static String superMethodName() {
        return "super_init";
    }

    @NotNull
    public static String nameForClassesVariable() {
        return "classes";
    }

    @NotNull
    public static String getNameForAccessor(@NotNull String propertyName, boolean isGetter, boolean useNativeAccessor) {
        if (useNativeAccessor) {
            return propertyName;
        }
        if (isGetter) {
            return Namer.getNameForGetter(propertyName);
        }
        return Namer.getNameForSetter(propertyName);
    }

    public static String getKotlinBackingFieldName(String propertyName) {
        return Namer.getNameWithPrefix(propertyName, "$");
    }

    public static String getNameForGetter(String propertyName) {
        return Namer.getNameWithPrefix(propertyName, "get_");
    }

    public static String getNameForSetter(String propertyName) {
        return Namer.getNameWithPrefix(propertyName, "set_");
    }

    private static String getNameWithPrefix(String name, String prefix) {
        return prefix + name;
    }

    public static Namer newInstance(@NotNull JsScope rootScope) {
        return new Namer(rootScope);
    }

    private Namer(@NotNull JsScope rootScope) {
        this.kotlinName = rootScope.declareName("Kotlin");
        this.kotlinScope = new JsScope(rootScope, "Kotlin standard object");
        this.traitName = this.kotlinScope.declareName("createTrait");
        this.namespaceName = this.kotlinScope.declareName("createNamespace");
        this.className = this.kotlinScope.declareName("createClass");
        this.objectName = this.kotlinScope.declareName("createObject");
        this.isTypeName = this.kotlinScope.declareName("isType");
        this.writablePropertyDescriptorField = new JsPropertyInitializer(new JsNameRef("writable"), rootScope.getProgram().getTrueLiteral());
    }

    @NotNull
    public JsExpression classCreationMethodReference() {
        return this.kotlin(this.className);
    }

    @NotNull
    public JsExpression traitCreationMethodReference() {
        return this.kotlin(this.traitName);
    }

    @NotNull
    public JsExpression namespaceCreationMethodReference() {
        return this.kotlin(this.namespaceName);
    }

    @NotNull
    public JsExpression objectCreationMethodReference() {
        return this.kotlin(this.objectName);
    }

    @NotNull
    public JsExpression throwNPEFunctionCall() {
        JsNameRef reference = AstUtil.newQualifiedNameRef("throwNPE");
        JsInvocation invocation = AstUtil.newInvocation(reference, new JsExpression[0]);
        return this.kotlin(invocation);
    }

    @NotNull
    private JsExpression kotlin(@NotNull JsName name) {
        JsNameRef reference = name.makeRef();
        reference.setQualifier(this.kotlinName.makeRef());
        return reference;
    }

    @NotNull
    private JsExpression kotlin(@NotNull JsExpression reference) {
        JsAstUtils.setQualifier(reference, this.kotlinName.makeRef());
        return reference;
    }

    @NotNull
    public JsNameRef kotlinObject() {
        return this.kotlinName.makeRef();
    }

    @NotNull
    public JsExpression isOperationReference() {
        return this.kotlin(this.isTypeName);
    }

    @NotNull
    public JsPropertyInitializer writablePropertyDescriptorField() {
        return this.writablePropertyDescriptorField;
    }

    @NotNull
    JsScope getKotlinScope() {
        return this.kotlinScope;
    }
}

