/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsBlock;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsExpression;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsScope;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsVars;
import org.jetbrains.k2js.translate.context.NamingScope;
import org.jetbrains.k2js.translate.context.TemporaryVariable;
import org.jetbrains.k2js.translate.utils.JsAstUtils;

public final class DynamicContext {
    @NotNull
    private final NamingScope currentScope;
    @NotNull
    private final JsBlock currentBlock;

    @NotNull
    public static DynamicContext rootContext(@NotNull NamingScope rootScope, @NotNull JsBlock globalBlock) {
        return new DynamicContext(rootScope, globalBlock);
    }

    @NotNull
    public static DynamicContext newContext(@NotNull NamingScope scope, @NotNull JsBlock block) {
        return new DynamicContext(scope, block);
    }

    private DynamicContext(@NotNull NamingScope scope, @NotNull JsBlock block) {
        this.currentScope = scope;
        this.currentBlock = block;
    }

    @NotNull
    public DynamicContext innerBlock(@NotNull JsBlock block) {
        return new DynamicContext(this.currentScope, block);
    }

    @NotNull
    public TemporaryVariable declareTemporary(@NotNull JsExpression initExpression) {
        JsName temporaryName = this.currentScope.declareTemporary();
        JsVars temporaryDeclaration = JsAstUtils.newVar(temporaryName, null);
        JsAstUtils.addVarDeclaration(this.jsBlock(), temporaryDeclaration);
        return new TemporaryVariable(temporaryName, initExpression);
    }

    @NotNull
    public JsScope jsScope() {
        return this.currentScope.jsScope();
    }

    @NotNull
    public NamingScope getScope() {
        return this.currentScope;
    }

    @NotNull
    public JsBlock jsBlock() {
        return this.currentBlock;
    }
}

