/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.translate.context;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsName;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.JetExpression;

public class AliasingContext {
    private static AliasingContext ROOT = new AliasingContext(null){

        @Override
        public JsName getAliasForThis(@NotNull DeclarationDescriptor descriptor) {
            return null;
        }

        @Override
        public JsName getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
            return null;
        }

        @Override
        public JsName getAliasForExpression(@NotNull JetExpression element) {
            return null;
        }
    };
    @NotNull
    private final Map<DeclarationDescriptor, JsName> aliasesForDescriptors = Maps.newHashMap();
    @NotNull
    private final Map<DeclarationDescriptor, JsName> aliasesForThis = Maps.newHashMap();
    @NotNull
    private final Map<JetExpression, JsName> aliasesForExpressions = Maps.newHashMap();
    @Nullable
    private final AliasingContext parent;

    public static AliasingContext getCleanContext() {
        return new AliasingContext(ROOT);
    }

    private AliasingContext(@Nullable AliasingContext parent) {
        this.parent = parent;
    }

    @NotNull
    public AliasingContext withThisAliased(@NotNull DeclarationDescriptor correspondingDescriptor, @NotNull JsName alias) {
        AliasingContext newContext = new AliasingContext(this);
        newContext.aliasesForThis.put(correspondingDescriptor, alias);
        return newContext;
    }

    @NotNull
    public AliasingContext withAliasesForExpressions(@NotNull Map<JetExpression, JsName> aliasesForExpressions) {
        AliasingContext newContext = new AliasingContext(this);
        newContext.aliasesForExpressions.putAll(aliasesForExpressions);
        return newContext;
    }

    @NotNull
    public AliasingContext withDescriptorsAliased(@NotNull Map<DeclarationDescriptor, JsName> aliases) {
        AliasingContext newContext = new AliasingContext(this);
        newContext.aliasesForDescriptors.putAll(aliases);
        return newContext;
    }

    @NotNull
    private AliasingContext getParent() {
        assert (this.parent != null);
        return this.parent;
    }

    @Nullable
    public JsName getAliasForThis(@NotNull DeclarationDescriptor descriptor) {
        JsName alias = this.aliasesForThis.get(descriptor.getOriginal());
        if (alias != null) {
            return alias;
        }
        return this.getParent().getAliasForThis(descriptor);
    }

    @Nullable
    public JsName getAliasForDescriptor(@NotNull DeclarationDescriptor descriptor) {
        JsName alias = this.aliasesForDescriptors.get(descriptor.getOriginal());
        if (alias != null) {
            return alias;
        }
        return this.getParent().getAliasForDescriptor(descriptor);
    }

    @Nullable
    public JsName getAliasForExpression(@NotNull JetExpression element) {
        JsName alias = this.aliasesForExpressions.get(element);
        if (alias != null) {
            return alias;
        }
        return this.getParent().getAliasForExpression(element);
    }
}

