/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.generate;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.JsSourceGenerationVisitor;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.DefaultTextOutput;
import org.jetbrains.jet.internal.com.google.dart.compiler.util.TextOutput;

public final class CodeGenerator {
    @NotNull
    private final TextOutput output = new DefaultTextOutput(false);

    public static void toFile(@NotNull String outputFile, @NotNull JsProgram program) throws IOException {
        CodeGenerator generator = new CodeGenerator();
        generator.generateToFile(program, new File(outputFile));
    }

    @NotNull
    public static String toString(@NotNull JsProgram program) {
        return new CodeGenerator().generateToString(program);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateToFile(@NotNull JsProgram program, @NotNull File file) throws IOException {
        this.generateCode(program);
        FileWriter writer = new FileWriter(file);
        try {
            writer.write(this.output.toString());
        }
        finally {
            writer.close();
        }
    }

    @NotNull
    public String generateToString(@NotNull JsProgram program) {
        this.generateCode(program);
        return this.output.toString();
    }

    private void generateCode(@NotNull JsProgram program) {
        JsSourceGenerationVisitor sourceGenerator = new JsSourceGenerationVisitor(this.output);
        program.traverse(sourceGenerator, null);
    }
}

