/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.facade;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.dart.compiler.backend.js.ast.JsProgram;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.k2js.analyze.AnalyzerFacadeForJS;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.facade.FacadeUtils;
import org.jetbrains.k2js.facade.MainCallParameters;
import org.jetbrains.k2js.facade.exceptions.TranslationException;
import org.jetbrains.k2js.generate.CodeGenerator;
import org.jetbrains.k2js.translate.general.Translation;
import org.jetbrains.k2js.utils.JetFileUtils;

public final class K2JSTranslator {
    @NotNull
    private final Config config;

    public static void translateWithMainCallParametersAndSaveToFile(@NotNull MainCallParameters mainCall, @NotNull List<JetFile> files, @NotNull String outputPath, @NotNull Config config) throws TranslationException, IOException {
        K2JSTranslator translator = new K2JSTranslator(config);
        String programCode = translator.generateProgramCode(files, mainCall) + "\n";
        FacadeUtils.writeCodeToFile(outputPath, programCode);
    }

    public K2JSTranslator(@NotNull Config config) {
        this.config = config;
    }

    @NotNull
    public String translateStringWithCallToMain(@NotNull String programText, @NotNull String argumentsString) throws TranslationException {
        JetFile file = JetFileUtils.createPsiFile("test", programText, this.getProject());
        String programCode = this.generateProgramCode(file, MainCallParameters.mainWithArguments(FacadeUtils.parseString(argumentsString))) + "\n";
        String flushOutput = "Kotlin.System.flush();\n";
        String programOutput = "Kotlin.System.output();\n";
        return flushOutput + programCode + programOutput;
    }

    @NotNull
    public String generateProgramCode(@NotNull JetFile file, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        JsProgram program = this.generateProgram(Arrays.asList(file), mainCallParameters);
        CodeGenerator generator = new CodeGenerator();
        return generator.generateToString(program);
    }

    @NotNull
    public String generateProgramCode(@NotNull List<JetFile> files, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        JsProgram program = this.generateProgram(files, mainCallParameters);
        CodeGenerator generator = new CodeGenerator();
        return generator.generateToString(program);
    }

    @NotNull
    public JsProgram generateProgram(@NotNull List<JetFile> filesToTranslate, @NotNull MainCallParameters mainCallParameters) throws TranslationException {
        JetStandardLibrary.initialize(this.config.getProject());
        BindingContext bindingContext = AnalyzerFacadeForJS.analyzeFilesAndCheckErrors(filesToTranslate, this.config);
        Collection<JetFile> files = AnalyzerFacadeForJS.withJsLibAdded(filesToTranslate, this.config);
        return Translation.generateAst(bindingContext, Lists.newArrayList(files), mainCallParameters, this.config.getTarget());
    }

    @NotNull
    private Project getProject() {
        return this.config.getProject();
    }
}

