/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.config.Config;
import org.jetbrains.k2js.config.EcmaVersion;
import org.jetbrains.k2js.utils.JetFileUtils;

public class ZippedLibrarySourcesConfig
extends Config {
    @Nullable
    protected final String pathToLibZip;

    public ZippedLibrarySourcesConfig(@NotNull Project project, @Nullable String pathToZip, @NotNull EcmaVersion ecmaVersion) {
        super(project, ecmaVersion);
        this.pathToLibZip = pathToZip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<JetFile> generateLibFiles() {
        List<JetFile> list;
        if (this.pathToLibZip == null) {
            return Collections.emptyList();
        }
        File file = new File(this.pathToLibZip);
        ZipFile zipFile = new ZipFile(file);
        try {
            list = this.traverseArchive(zipFile);
        }
        catch (Throwable throwable) {
            try {
                zipFile.close();
                throw throwable;
            }
            catch (IOException e) {
                return Collections.emptyList();
            }
        }
        zipFile.close();
        return list;
    }

    @NotNull
    private List<JetFile> traverseArchive(@NotNull ZipFile file) throws IOException {
        ArrayList<JetFile> result = Lists.newArrayList();
        Enumeration<? extends ZipEntry> zipEntries = file.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().endsWith(".kt")) continue;
            InputStream stream = file.getInputStream(entry);
            String text = FileUtil.loadTextAndClose(stream);
            JetFile jetFile = JetFileUtils.createPsiFile(entry.getName(), text, this.getProject());
            result.add(jetFile);
        }
        return result;
    }
}

