/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.k2js.config.EcmaVersion;

public abstract class Config {
    @NotNull
    public static final List<String> LIB_FILE_NAMES = Arrays.asList("/core/annotations.kt", "/jquery/common.kt", "/jquery/ui.kt", "/core/javautil.kt", "/core/javalang.kt", "/core/date.kt", "/core/core.kt", "/core/math.kt", "/core/json.kt", "/raphael/raphael.kt", "/stdlib/JUMaps.kt", "/stdlib/browser.kt", "/core/dom.kt", "/dom/domcore.kt", "/dom/html/htmlcore.kt", "/dom/html5/canvas.kt", "/dom/html/window.kt");
    public static final String LIBRARIES_LOCATION = "js/js.libraries/src";
    @NotNull
    private final Project project;
    @Nullable
    private List<JetFile> libFiles = null;
    @NotNull
    private final EcmaVersion target;

    @NotNull
    public static Config getEmptyConfig(@NotNull Project project, @NotNull EcmaVersion ecmaVersion) {
        return new Config(project, ecmaVersion){

            @Override
            @NotNull
            protected List<JetFile> generateLibFiles() {
                return Collections.emptyList();
            }
        };
    }

    @NotNull
    public static Config getEmptyConfig(@NotNull Project project) {
        return Config.getEmptyConfig(project, EcmaVersion.defaultVersion());
    }

    public Config(@NotNull Project project, @NotNull EcmaVersion ecmaVersion) {
        this.project = project;
        this.target = ecmaVersion;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @NotNull
    public EcmaVersion getTarget() {
        return this.target;
    }

    @NotNull
    protected abstract List<JetFile> generateLibFiles();

    @NotNull
    public final List<JetFile> getLibFiles() {
        if (this.libFiles == null) {
            this.libFiles = this.generateLibFiles();
        }
        return this.libFiles;
    }
}

