/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.k2js.analyze;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.analyzer.AnalyzeExhaust;
import org.jetbrains.jet.di.InjectorForTopDownAnalyzerForJs;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.base.Predicates;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFile;
import org.jetbrains.jet.lang.DefaultModuleConfiguration;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.resolve.AnalyzerScriptParameter;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.BodiesResolveContext;
import org.jetbrains.jet.lang.resolve.CachedBodiesResolveContext;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisParameters;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.k2js.config.Config;

public final class AnalyzerFacadeForJS {
    private AnalyzerFacadeForJS() {
    }

    @NotNull
    public static BindingContext analyzeFilesAndCheckErrors(@NotNull List<JetFile> files, @NotNull Config config) {
        BindingContext bindingContext = AnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
        AnalyzerFacadeForJS.checkForErrors(AnalyzerFacadeForJS.withJsLibAdded(files, config), bindingContext);
        return bindingContext;
    }

    @NotNull
    public static BindingContext analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Config config) {
        return AnalyzerFacadeForJS.analyzeFiles(files, Predicates.<PsiFile>alwaysTrue(), config).getBindingContext();
    }

    @NotNull
    public static AnalyzeExhaust analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config) {
        return AnalyzerFacadeForJS.analyzeFiles(files, filesToAnalyzeCompletely, config, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static AnalyzeExhaust analyzeFiles(@NotNull Collection<JetFile> files, @NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config, boolean storeContextForBodiesResolve) {
        Project project = config.getProject();
        BindingTraceContext bindingTraceContext = new BindingTraceContext();
        ModuleDescriptor owner = new ModuleDescriptor(Name.special("<module>"));
        Predicate<PsiFile> completely = Predicates.and(AnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(completely, false, false, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, new ObservableBindingTrace(bindingTraceContext), owner, JsConfiguration.jsLibConfiguration(project));
        try {
            injector.getTopDownAnalyzer().analyzeFiles(AnalyzerFacadeForJS.withJsLibAdded(files, config), Collections.<AnalyzerScriptParameter>emptyList());
            CachedBodiesResolveContext bodiesResolveContext = storeContextForBodiesResolve ? new CachedBodiesResolveContext(injector.getTopDownAnalysisContext()) : null;
            AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(bindingTraceContext.getBindingContext(), JetStandardLibrary.getInstance(), bodiesResolveContext);
            return analyzeExhaust;
        }
        finally {
            injector.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AnalyzeExhaust analyzeBodiesInFiles(@NotNull Predicate<PsiFile> filesToAnalyzeCompletely, @NotNull Config config, @NotNull BindingTrace traceContext, @NotNull BodiesResolveContext bodiesResolveContext) {
        Project project = config.getProject();
        ModuleDescriptor owner = new ModuleDescriptor(Name.special("<module>"));
        Predicate<PsiFile> completely = Predicates.and(AnalyzerFacadeForJS.notLibFiles(config.getLibFiles()), filesToAnalyzeCompletely);
        TopDownAnalysisParameters topDownAnalysisParameters = new TopDownAnalysisParameters(completely, false, false, Collections.<AnalyzerScriptParameter>emptyList());
        InjectorForTopDownAnalyzerForJs injector = new InjectorForTopDownAnalyzerForJs(project, topDownAnalysisParameters, new ObservableBindingTrace(traceContext), owner, JsConfiguration.jsLibConfiguration(project));
        try {
            bodiesResolveContext.setTopDownAnalysisParameters(topDownAnalysisParameters);
            injector.getTopDownAnalyzer().doProcessForBodies(bodiesResolveContext);
            AnalyzeExhaust analyzeExhaust = AnalyzeExhaust.success(traceContext.getBindingContext(), JetStandardLibrary.getInstance());
            return analyzeExhaust;
        }
        finally {
            injector.destroy();
        }
    }

    private static void checkForErrors(@NotNull Collection<JetFile> allFiles, @NotNull BindingContext bindingContext) {
        AnalyzingUtils.throwExceptionOnErrors(bindingContext);
        for (JetFile file : allFiles) {
            AnalyzingUtils.checkForSyntacticErrors(file);
        }
    }

    @NotNull
    public static Collection<JetFile> withJsLibAdded(@NotNull Collection<JetFile> files, @NotNull Config config) {
        HashSet<JetFile> allFiles = Sets.newHashSet();
        allFiles.addAll(files);
        allFiles.addAll(config.getLibFiles());
        return allFiles;
    }

    @NotNull
    private static Predicate<PsiFile> notLibFiles(final @NotNull List<JetFile> jsLibFiles) {
        return new Predicate<PsiFile>(){

            @Override
            public boolean apply(@Nullable PsiFile file) {
                assert (file instanceof JetFile);
                boolean notLibFile = !jsLibFiles.contains(file);
                return notLibFile;
            }
        };
    }

    private static final class JsConfiguration
    implements ModuleConfiguration {
        @NotNull
        private final Project project;

        public static JsConfiguration jsLibConfiguration(@NotNull Project project) {
            return new JsConfiguration(project);
        }

        private JsConfiguration(@NotNull Project project) {
            this.project = project;
        }

        @Override
        public void addDefaultImports(@NotNull Collection<JetImportDirective> directives) {
            directives.add(JetPsiFactory.createImportDirective(this.project, new ImportPath("js.*")));
            directives.add(JetPsiFactory.createImportDirective(this.project, new ImportPath(JetStandardClasses.STANDARD_CLASSES_FQNAME, true)));
            directives.add(JetPsiFactory.createImportDirective(this.project, new ImportPath("kotlin.*")));
        }

        @Override
        public void extendNamespaceScope(@NotNull BindingTrace trace, @NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
            DefaultModuleConfiguration.createStandardConfiguration(this.project, true).extendNamespaceScope(trace, namespaceDescriptor, namespaceMemberScope);
        }
    }
}

