/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.utils;

import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.application.PathManager;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFileManager;

public class PathUtil {
    public static String JS_LIB_JAR_NAME = "kotlin-jslib.jar";
    public static String JS_LIB_JS_NAME = "kotlinLib.js";

    private PathUtil() {
    }

    public static File getDefaultCompilerPath() {
        File plugin_jar_path = new File(PathUtil.getJarPathForClass(PathUtil.class));
        if (!plugin_jar_path.exists()) {
            return null;
        }
        if (plugin_jar_path.getName().equals("kotlin-plugin.jar")) {
            File lib = plugin_jar_path.getParentFile();
            File pluginHome = lib.getParentFile();
            File answer = new File(pluginHome, "kotlinc");
            return answer.exists() ? answer : null;
        }
        if (plugin_jar_path.getName().equals("kotlin-compiler.jar")) {
            File lib = plugin_jar_path.getParentFile();
            File answer = lib.getParentFile();
            return answer.exists() ? answer : null;
        }
        File current = new File("").getAbsoluteFile();
        do {
            File atDevHome;
            if (!(atDevHome = new File(current, "dist/kotlinc")).exists()) continue;
            return atDevHome;
        } while ((current = current.getParentFile()) != null);
        return null;
    }

    @Nullable
    public static File getDefaultRuntimePath() {
        return PathUtil.getFilePackedIntoLib("kotlin-runtime.jar");
    }

    @Nullable
    public static File getDefaultJsLibJsPath() {
        return PathUtil.getFilePackedIntoLib(JS_LIB_JS_NAME);
    }

    @Nullable
    public static File getDefaultJsLibJarPath() {
        return PathUtil.getFilePackedIntoLib(JS_LIB_JAR_NAME);
    }

    @Nullable
    private static File getFilePackedIntoLib(@NotNull String filePathFromLib) {
        File compilerPath = PathUtil.getDefaultCompilerPath();
        if (compilerPath == null) {
            return null;
        }
        File answer = new File(compilerPath, "lib/" + filePathFromLib);
        return answer.exists() ? answer : null;
    }

    @Nullable
    public static File getAltHeadersPath() {
        return PathUtil.getFilePackedIntoLib("alt/kotlin-jdk-headers.jar");
    }

    @NotNull
    public static String getJarPathForClass(@NotNull Class aClass) {
        String resourceRoot = PathManager.getResourceRoot(aClass, "/" + aClass.getName().replace('.', '/') + ".class");
        return new File(resourceRoot).getAbsoluteFile().getAbsolutePath();
    }

    @NotNull
    public static VirtualFile jarFileOrDirectoryToVirtualFile(@NotNull File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                return VirtualFileManager.getInstance().findFileByUrl("file://" + FileUtil.toSystemIndependentName(file.getAbsolutePath()));
            }
            return VirtualFileManager.getInstance().findFileByUrl("jar://" + FileUtil.toSystemIndependentName(file.getAbsolutePath()) + "!/");
        }
        throw new IllegalStateException("Path " + file + " does not exist.");
    }
}

