/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.util;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.ImportPath;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public final class QualifiedNamesUtil {
    private QualifiedNamesUtil() {
    }

    public static boolean isSubpackageOf(@NotNull FqName subpackageName, @NotNull FqName packageName) {
        return subpackageName.equals(packageName) || subpackageName.getFqName().startsWith(packageName.getFqName()) && subpackageName.getFqName().charAt(packageName.getFqName().length()) == '.';
    }

    public static boolean isShortNameForFQN(@NotNull String name, @NotNull FqName fqn) {
        return fqn.getFqName().equals(name) || fqn.getFqName().endsWith(name) && fqn.getFqName().charAt(fqn.getFqName().length() - name.length() - 1) == '.';
    }

    public static boolean isOneSegmentFQN(@NotNull String fqn) {
        if (fqn.isEmpty()) {
            return false;
        }
        return fqn.indexOf(46) < 0;
    }

    public static boolean isOneSegmentFQN(@NotNull FqName fqn) {
        return QualifiedNamesUtil.isOneSegmentFQN(fqn.getFqName());
    }

    @NotNull
    public static Name fqnToShortName(@NotNull FqName fqn) {
        return QualifiedNamesUtil.getLastSegment(fqn);
    }

    @NotNull
    public static Name getLastSegment(@NotNull FqName fqn) {
        return fqn.shortName();
    }

    @NotNull
    public static String getFirstSegment(@NotNull String fqn) {
        int dotIndex = fqn.indexOf(46);
        return dotIndex != -1 ? fqn.substring(0, dotIndex) : fqn;
    }

    @NotNull
    public static FqName withoutLastSegment(@NotNull FqName fqName) {
        return fqName.parent();
    }

    @NotNull
    public static FqName withoutFirstSegment(@NotNull FqName fqName) {
        if (fqName.isRoot() || fqName.parent().isRoot()) {
            return FqName.ROOT;
        }
        String fqNameStr = fqName.getFqName();
        return new FqName(fqNameStr.substring(fqNameStr.indexOf(46), fqNameStr.length()));
    }

    @NotNull
    public static FqName combine(@NotNull FqName first, @NotNull Name second) {
        return first.child(second);
    }

    @NotNull
    public static String tail(@NotNull FqName headFQN, @NotNull FqName fullFQN) {
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, headFQN)) {
            return fullFQN.getFqName();
        }
        return fullFQN.equals(headFQN) ? "" : fullFQN.getFqName().substring(headFQN.getFqName().length() + 1);
    }

    @Nullable
    public static FqName plusOneSegment(@NotNull FqName fqn, @NotNull FqName fullFQN) {
        if (!QualifiedNamesUtil.isSubpackageOf(fullFQN, fqn)) {
            return null;
        }
        String nextSegment = QualifiedNamesUtil.getFirstSegment(QualifiedNamesUtil.tail(fqn, fullFQN));
        if (QualifiedNamesUtil.isOneSegmentFQN(nextSegment)) {
            return QualifiedNamesUtil.combine(fqn, Name.guess(nextSegment));
        }
        return null;
    }

    public static boolean isImported(@NotNull ImportPath alreadyImported, @NotNull FqName fqName) {
        if (alreadyImported.isAllUnder() && !fqName.isRoot()) {
            return alreadyImported.fqnPart().equals(fqName.parent());
        }
        return alreadyImported.fqnPart().equals(fqName);
    }

    public static boolean isImported(@NotNull ImportPath alreadyImported, @NotNull ImportPath newImport) {
        if (newImport.isAllUnder()) {
            return alreadyImported.equals(newImport);
        }
        return QualifiedNamesUtil.isImported(alreadyImported, newImport.fqnPart());
    }
}

