/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.rt.signature;

import jet.typeinfo.TypeInfoVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public class JetSignatureWriter
implements JetSignatureVisitor {
    private final StringBuffer buf = new StringBuffer();
    private boolean hasFormals;
    private boolean hasParameters;
    private int argumentStack;

    @Override
    public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
        if (!this.hasFormals) {
            this.hasFormals = true;
            this.buf.append('<');
        }
        if (!reified) {
            this.buf.append("erased ");
        }
        switch (variance) {
            case OUT: {
                this.buf.append("out ");
                break;
            }
            case IN: {
                this.buf.append("in ");
                break;
            }
            case INVARIANT: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.buf.append(name);
        this.buf.append(':');
        return this;
    }

    @Override
    public void visitFormalTypeParameterEnd() {
    }

    @Override
    public JetSignatureWriter visitClassBound() {
        return this;
    }

    @Override
    public JetSignatureWriter visitInterfaceBound() {
        this.buf.append(':');
        return this;
    }

    @Override
    public JetSignatureWriter visitSuperclass() {
        this.endFormals();
        return this;
    }

    @Override
    public JetSignatureWriter visitInterface() {
        return this;
    }

    @Override
    public JetSignatureWriter visitParameterType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.hasParameters = true;
            this.buf.append('(');
        }
        return this;
    }

    @Override
    public JetSignatureWriter visitReturnType() {
        this.endFormals();
        if (!this.hasParameters) {
            this.buf.append('(');
        }
        this.buf.append(')');
        return this;
    }

    @Override
    public JetSignatureWriter visitExceptionType() {
        this.buf.append('^');
        return this;
    }

    private void visitNullabe(boolean nullable) {
        if (nullable) {
            this.buf.append('?');
        }
    }

    @Override
    public void visitBaseType(char descriptor, boolean nullable) {
        this.visitNullabe(nullable);
        this.buf.append(descriptor);
    }

    @Override
    public void visitTypeVariable(String name, boolean nullable) {
        this.visitNullabe(nullable);
        this.buf.append('T');
        this.buf.append(name);
        this.buf.append(';');
    }

    @Override
    public JetSignatureWriter visitArrayType(boolean nullable) {
        this.visitNullabe(nullable);
        this.buf.append('[');
        return this;
    }

    @Override
    public void visitClassType(String name, boolean nullable, boolean forceReal) {
        this.visitNullabe(nullable);
        this.buf.append(forceReal ? (char)'M' : 'L');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    @Override
    public void visitInnerClassType(String name, boolean nullable) {
        this.endArguments();
        this.visitNullabe(nullable);
        this.buf.append('.');
        this.buf.append(name);
        this.argumentStack *= 2;
    }

    @Override
    public void visitTypeArgument() {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        this.buf.append('*');
    }

    @Override
    public JetSignatureWriter visitTypeArgument(JetSignatureVariance variance) {
        if (this.argumentStack % 2 == 0) {
            ++this.argumentStack;
            this.buf.append('<');
        }
        if (variance.getC() != '=') {
            this.buf.append(variance.getC());
        }
        return this;
    }

    @Override
    public void visitEnd() {
        this.endArguments();
        this.buf.append(';');
    }

    public String toString() {
        return this.buf.toString();
    }

    private void endFormals() {
        if (this.hasFormals) {
            this.hasFormals = false;
            this.buf.append('>');
        }
    }

    private void endArguments() {
        if (this.argumentStack % 2 != 0) {
            this.buf.append('>');
        }
        this.argumentStack /= 2;
    }
}

