/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.resolve;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.diagnostics.rendering.Renderer;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lexer.JetTokens;

public class DescriptorRenderer
implements Renderer<DeclarationDescriptor> {
    public static final DescriptorRenderer COMPACT = new DescriptorRenderer(){

        @Override
        protected boolean shouldRenderDefinedIn() {
            return false;
        }
    };
    public static final DescriptorRenderer TEXT = new DescriptorRenderer();
    public static final DescriptorRenderer DEBUG_TEXT = new DescriptorRenderer(){

        @Override
        protected boolean hasDefaultValue(ValueParameterDescriptor descriptor) {
            return descriptor.declaresDefaultValue();
        }
    };
    public static final DescriptorRenderer HTML = new DescriptorRenderer(){

        @Override
        protected String escape(String s) {
            return s.replaceAll("<", "&lt;");
        }

        @Override
        public String renderKeyword(String keyword) {
            return "<b>" + keyword + "</b>";
        }

        @Override
        public String renderMessage(String s) {
            return "<i>" + s + "</i>";
        }
    };
    private final RenderDeclarationDescriptorVisitor rootVisitor = new RenderDeclarationDescriptorVisitor();
    private final DeclarationDescriptorVisitor<Void, StringBuilder> subVisitor = new RenderDeclarationDescriptorVisitor(){

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            this.renderTypeParameter(descriptor, builder, false);
            return null;
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            super.visitVariableDescriptor(descriptor, builder, true);
            if (DescriptorRenderer.this.hasDefaultValue(descriptor)) {
                builder.append(" = ...");
            }
            return null;
        }
    };

    private DescriptorRenderer() {
    }

    protected boolean hasDefaultValue(ValueParameterDescriptor descriptor) {
        return descriptor.hasDefaultValue();
    }

    protected String renderKeyword(String keyword) {
        return keyword;
    }

    public String renderType(JetType type) {
        return this.renderType(type, false);
    }

    public String renderTypeWithShortNames(JetType type) {
        return this.renderType(type, true);
    }

    private String renderType(JetType type, boolean shortNamesOnly) {
        if (type == null) {
            return this.escape("[NULL]");
        }
        if (ErrorUtils.isErrorType(type)) {
            return this.escape(type.toString());
        }
        if (JetStandardClasses.isUnit(type)) {
            return this.escape(JetStandardClasses.UNIT_ALIAS + (type.isNullable() ? "?" : ""));
        }
        if (JetStandardClasses.isTupleType(type)) {
            return this.escape(this.renderTupleType(type, shortNamesOnly));
        }
        if (JetStandardClasses.isFunctionType(type)) {
            return this.escape(this.renderFunctionType(type, shortNamesOnly));
        }
        return this.escape(this.renderDefaultType(type, shortNamesOnly));
    }

    private String renderDefaultType(JetType type, boolean shortNamesOnly) {
        Object typeNameObject;
        StringBuilder sb = new StringBuilder();
        ClassifierDescriptor cd = type.getConstructor().getDeclarationDescriptor();
        if (cd == null || cd instanceof TypeParameterDescriptor) {
            typeNameObject = type.getConstructor();
        } else if (shortNamesOnly) {
            typeNameObject = cd.getName();
            DeclarationDescriptor parent = cd.getContainingDeclaration();
            while (parent instanceof ClassDescriptor) {
                typeNameObject = parent.getName() + "." + typeNameObject;
                parent = parent.getContainingDeclaration();
            }
        } else {
            typeNameObject = DescriptorUtils.getFQName(cd);
        }
        sb.append(typeNameObject);
        if (!type.getArguments().isEmpty()) {
            sb.append("<");
            this.appendTypeProjections(sb, type.getArguments(), shortNamesOnly);
            sb.append(">");
        }
        if (type.isNullable()) {
            sb.append("?");
        }
        return sb.toString();
    }

    private void appendTypes(StringBuilder result, List<JetType> types, boolean shortNamesOnly) {
        Iterator<JetType> iterator = types.iterator();
        while (iterator.hasNext()) {
            result.append(this.renderType(iterator.next(), shortNamesOnly));
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
    }

    private void appendTypeProjections(StringBuilder result, List<TypeProjection> typeProjections, boolean shortNamesOnly) {
        Iterator<TypeProjection> iterator = typeProjections.iterator();
        while (iterator.hasNext()) {
            TypeProjection typeProjection = iterator.next();
            if (typeProjection.getProjectionKind() != Variance.INVARIANT) {
                result.append((Object)typeProjection.getProjectionKind()).append(" ");
            }
            result.append(this.renderType(typeProjection.getType(), shortNamesOnly));
            if (!iterator.hasNext()) continue;
            result.append(", ");
        }
    }

    protected String renderTupleType(JetType type, boolean shortNamesOnly) {
        StringBuilder sb = new StringBuilder("#(");
        this.appendTypes(sb, JetStandardClasses.getTupleElementTypes(type), shortNamesOnly);
        sb.append(")");
        if (type.isNullable()) {
            sb.append("?");
        }
        return sb.toString();
    }

    private String renderFunctionType(JetType type, boolean shortNamesOnly) {
        StringBuilder sb = new StringBuilder();
        JetType receiverType = JetStandardClasses.getReceiverType(type);
        if (receiverType != null) {
            sb.append(this.renderType(receiverType, shortNamesOnly));
            sb.append(".");
        }
        sb.append("(");
        this.appendTypeProjections(sb, JetStandardClasses.getParameterTypeProjectionsFromFunctionType(type), shortNamesOnly);
        sb.append(") -> ");
        sb.append(this.renderType(JetStandardClasses.getReturnTypeFromFunctionType(type), shortNamesOnly));
        if (type.isNullable()) {
            return "(" + sb + ")?";
        }
        return sb.toString();
    }

    protected String escape(String s) {
        return s;
    }

    private String lt() {
        return this.escape("<");
    }

    @Override
    @NotNull
    public String render(@NotNull DeclarationDescriptor declarationDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        declarationDescriptor.accept(this.rootVisitor, stringBuilder);
        if (this.shouldRenderDefinedIn()) {
            this.appendDefinedIn(declarationDescriptor, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String renderFunctionParameters(@NotNull FunctionDescriptor functionDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        this.rootVisitor.renderValueParameters(functionDescriptor, stringBuilder);
        return stringBuilder.toString();
    }

    protected boolean shouldRenderDefinedIn() {
        return true;
    }

    private void appendDefinedIn(DeclarationDescriptor declarationDescriptor, StringBuilder stringBuilder) {
        if (declarationDescriptor instanceof ModuleDescriptor) {
            stringBuilder.append(" is a module");
            return;
        }
        stringBuilder.append(" ").append(this.renderMessage("defined in")).append(" ");
        DeclarationDescriptor containingDeclaration = declarationDescriptor.getContainingDeclaration();
        if (containingDeclaration != null) {
            FqNameUnsafe fqName = DescriptorUtils.getFQName(containingDeclaration);
            stringBuilder.append(FqName.ROOT.toUnsafe().equals(fqName) ? "root package" : this.escape(fqName.getFqName()));
        }
    }

    public String renderAsObject(@NotNull ClassDescriptor classDescriptor) {
        StringBuilder stringBuilder = new StringBuilder();
        this.rootVisitor.renderClassDescriptor(classDescriptor, stringBuilder, "object");
        if (this.shouldRenderDefinedIn()) {
            this.appendDefinedIn(classDescriptor, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String renderMessage(String s) {
        return s;
    }

    private class RenderDeclarationDescriptorVisitor
    extends DeclarationDescriptorVisitor<Void, StringBuilder> {
        private RenderDeclarationDescriptorVisitor() {
        }

        @Override
        public Void visitValueParameterDescriptor(ValueParameterDescriptor descriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.renderKeyword("value-parameter")).append(" ");
            return (Void)super.visitValueParameterDescriptor(descriptor, builder);
        }

        @Override
        public Void visitVariableDescriptor(VariableDescriptor descriptor, StringBuilder builder) {
            return this.visitVariableDescriptor(descriptor, builder, false);
        }

        protected Void visitVariableDescriptor(VariableDescriptor descriptor, StringBuilder builder, boolean skipValVar) {
            JetType varargElementType;
            JetType type = descriptor.getType();
            if (descriptor instanceof ValueParameterDescriptor && (varargElementType = ((ValueParameterDescriptor)descriptor).getVarargElementType()) != null) {
                builder.append(DescriptorRenderer.this.renderKeyword("vararg")).append(" ");
                type = varargElementType;
            }
            String typeString = this.renderPropertyPrefixAndComputeTypeString(builder, skipValVar ? null : Boolean.valueOf(descriptor.isVar()), Collections.<TypeParameterDescriptor>emptyList(), ReceiverDescriptor.NO_RECEIVER, type);
            this.renderName(descriptor, builder);
            builder.append(" : ").append(DescriptorRenderer.this.escape(typeString));
            return null;
        }

        private String renderPropertyPrefixAndComputeTypeString(@NotNull StringBuilder builder, @Nullable Boolean isVar, @NotNull List<TypeParameterDescriptor> typeParameters, @NotNull ReceiverDescriptor receiver, @Nullable JetType outType) {
            String typeString = DescriptorRenderer.this.lt() + "no type>";
            if (outType != null) {
                if (isVar != null) {
                    builder.append(DescriptorRenderer.this.renderKeyword(isVar != false ? "var" : "val")).append(" ");
                }
                typeString = DescriptorRenderer.this.renderType(outType);
            }
            this.renderTypeParameters(typeParameters, builder);
            if (receiver.exists()) {
                builder.append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(receiver.getType()))).append(".");
            }
            return typeString;
        }

        @Override
        public Void visitPropertyDescriptor(PropertyDescriptor descriptor, StringBuilder builder) {
            this.renderVisibility(descriptor.getVisibility(), builder);
            this.renderModality(descriptor.getModality(), builder);
            String typeString = this.renderPropertyPrefixAndComputeTypeString(builder, descriptor.isVar(), descriptor.getTypeParameters(), descriptor.getReceiverParameter(), descriptor.getType());
            this.renderName(descriptor, builder);
            builder.append(" : ").append(DescriptorRenderer.this.escape(typeString));
            return null;
        }

        private void renderVisibility(Visibility visibility, StringBuilder builder) {
            if ("package".equals(visibility.toString())) {
                builder.append("public/*package*/ ");
            } else {
                builder.append(DescriptorRenderer.this.renderKeyword(visibility.toString())).append(" ");
            }
        }

        private void renderModality(Modality modality, StringBuilder builder) {
            String keyword = "";
            switch (modality) {
                case FINAL: {
                    keyword = "final";
                    break;
                }
                case OPEN: {
                    keyword = "open";
                    break;
                }
                case ABSTRACT: {
                    keyword = "abstract";
                }
            }
            builder.append(DescriptorRenderer.this.renderKeyword(keyword)).append(" ");
        }

        @Override
        public Void visitFunctionDescriptor(FunctionDescriptor descriptor, StringBuilder builder) {
            ReceiverDescriptor receiver;
            this.renderVisibility(descriptor.getVisibility(), builder);
            this.renderModality(descriptor.getModality(), builder);
            builder.append(DescriptorRenderer.this.renderKeyword("fun")).append(" ");
            if (this.renderTypeParameters(descriptor.getTypeParameters(), builder)) {
                builder.append(" ");
            }
            if ((receiver = descriptor.getReceiverParameter()).exists()) {
                builder.append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(receiver.getType()))).append(".");
            }
            this.renderName(descriptor, builder);
            this.renderValueParameters(descriptor, builder);
            builder.append(" : ").append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(descriptor.getReturnType())));
            this.renderWhereSuffix(descriptor, builder);
            return null;
        }

        private void renderValueParameters(FunctionDescriptor descriptor, StringBuilder builder) {
            builder.append("(");
            Iterator<ValueParameterDescriptor> iterator = descriptor.getValueParameters().iterator();
            while (iterator.hasNext()) {
                ValueParameterDescriptor parameterDescriptor = iterator.next();
                parameterDescriptor.accept(DescriptorRenderer.this.subVisitor, builder);
                if (!iterator.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(")");
        }

        private void renderWhereSuffix(@NotNull CallableMemberDescriptor callable, @NotNull StringBuilder builder) {
            boolean first = true;
            for (TypeParameterDescriptor typeParameter : callable.getTypeParameters()) {
                if (typeParameter.getUpperBounds().size() <= 1) continue;
                for (JetType upperBound : typeParameter.getUpperBounds()) {
                    if (first) {
                        builder.append(" ");
                        builder.append(DescriptorRenderer.this.renderKeyword("where"));
                        builder.append(" ");
                    } else {
                        builder.append(", ");
                    }
                    builder.append(typeParameter.getName());
                    builder.append(" : ");
                    builder.append(DescriptorRenderer.this.escape(DescriptorRenderer.this.renderType(upperBound)));
                    first = false;
                }
            }
        }

        @Override
        public Void visitConstructorDescriptor(ConstructorDescriptor constructorDescriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.renderKeyword("ctor")).append(" ");
            ClassDescriptor classDescriptor = constructorDescriptor.getContainingDeclaration();
            builder.append(classDescriptor.getName());
            this.renderTypeParameters(classDescriptor.getTypeConstructor().getParameters(), builder);
            this.renderValueParameters(constructorDescriptor, builder);
            return null;
        }

        private boolean renderTypeParameters(List<TypeParameterDescriptor> typeParameters, StringBuilder builder) {
            if (!typeParameters.isEmpty()) {
                builder.append(DescriptorRenderer.this.lt());
                Iterator<TypeParameterDescriptor> iterator = typeParameters.iterator();
                while (iterator.hasNext()) {
                    TypeParameterDescriptor typeParameterDescriptor = iterator.next();
                    typeParameterDescriptor.accept(DescriptorRenderer.this.subVisitor, builder);
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
                builder.append(">");
                return true;
            }
            return false;
        }

        @Override
        public Void visitTypeParameterDescriptor(TypeParameterDescriptor descriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.lt());
            this.renderTypeParameter(descriptor, builder, true);
            builder.append(">");
            return null;
        }

        @Override
        public Void visitNamespaceDescriptor(NamespaceDescriptor namespaceDescriptor, StringBuilder builder) {
            builder.append(DescriptorRenderer.this.renderKeyword(JetTokens.PACKAGE_KEYWORD.getValue())).append(" ");
            this.renderName(namespaceDescriptor, builder);
            return null;
        }

        @Override
        public Void visitModuleDeclaration(ModuleDescriptor descriptor, StringBuilder builder) {
            this.renderName(descriptor, builder);
            return null;
        }

        @Override
        public Void visitClassDescriptor(ClassDescriptor descriptor, StringBuilder builder) {
            String keyword;
            switch (descriptor.getKind()) {
                case TRAIT: {
                    keyword = "trait";
                    break;
                }
                case ENUM_CLASS: {
                    keyword = "enum class";
                    break;
                }
                case OBJECT: {
                    keyword = "object";
                    break;
                }
                case ANNOTATION_CLASS: {
                    keyword = "annotation class";
                    break;
                }
                default: {
                    keyword = "class";
                }
            }
            this.renderClassDescriptor(descriptor, builder, keyword);
            return null;
        }

        private boolean isClassObjectDescriptor(ClassDescriptor descriptor) {
            DeclarationDescriptor containing;
            if (descriptor.getKind() == ClassKind.OBJECT && (containing = descriptor.getContainingDeclaration()) instanceof ClassDescriptor) {
                return ((ClassDescriptor)containing).getClassObjectDescriptor() == descriptor;
            }
            return false;
        }

        public void renderClassDescriptor(ClassDescriptor descriptor, StringBuilder builder, String keyword) {
            Collection<? extends JetType> supertypes;
            if (!this.isClassObjectDescriptor(descriptor)) {
                this.renderVisibility(descriptor.getVisibility(), builder);
            }
            if (descriptor.getKind() != ClassKind.TRAIT && descriptor.getKind() != ClassKind.OBJECT) {
                this.renderModality(descriptor.getModality(), builder);
            }
            builder.append(DescriptorRenderer.this.renderKeyword(keyword));
            if (descriptor.getKind() != ClassKind.OBJECT) {
                builder.append(" ");
                this.renderName(descriptor, builder);
                this.renderTypeParameters(descriptor.getTypeConstructor().getParameters(), builder);
            }
            if (!(descriptor.equals(JetStandardClasses.getNothing()) || (supertypes = descriptor.getTypeConstructor().getSupertypes()).isEmpty() || supertypes.size() == 1 && JetStandardClasses.isAny(supertypes.iterator().next()))) {
                builder.append(" : ");
                Iterator<? extends JetType> iterator = supertypes.iterator();
                while (iterator.hasNext()) {
                    JetType supertype = iterator.next();
                    builder.append(DescriptorRenderer.this.renderType(supertype));
                    if (!iterator.hasNext()) continue;
                    builder.append(", ");
                }
            }
        }

        protected void renderName(DeclarationDescriptor descriptor, StringBuilder stringBuilder) {
            stringBuilder.append(DescriptorRenderer.this.escape(descriptor.getName().getName()));
        }

        protected void renderTypeParameter(TypeParameterDescriptor descriptor, StringBuilder builder, boolean topLevel) {
            if (!descriptor.isReified()) {
                String variance = descriptor.getVariance().toString();
                if (!variance.isEmpty()) {
                    builder.append(DescriptorRenderer.this.renderKeyword(variance)).append(" ");
                }
            } else {
                builder.append(DescriptorRenderer.this.renderKeyword("reified")).append(" ");
            }
            this.renderName(descriptor, builder);
            if (descriptor.getUpperBounds().size() == 1) {
                JetType upperBound = descriptor.getUpperBounds().iterator().next();
                if (upperBound != JetStandardClasses.getDefaultBound()) {
                    builder.append(" : ").append(DescriptorRenderer.this.renderType(upperBound));
                }
            } else if (topLevel) {
                boolean first = true;
                for (JetType upperBound : descriptor.getUpperBounds()) {
                    if (((Object)upperBound).equals(JetStandardClasses.getDefaultBound())) continue;
                    if (first) {
                        builder.append(" : ");
                    } else {
                        builder.append(" & ");
                    }
                    builder.append(DescriptorRenderer.this.renderType(upperBound));
                    first = false;
                }
            }
        }
    }
}

