/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.ref;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.types.ref.JetTypeName;
import org.jetbrains.jet.lang.types.ref.SimpleParser;

class JetTypeNameParser
extends SimpleParser {
    private static final Pattern namePattern = Pattern.compile("(?i)[a-z][a-z0-9]*");

    public JetTypeNameParser(String input) {
        super(input);
    }

    @NotNull
    public Name parseName() {
        return Name.identifier(this.consume(namePattern));
    }

    @NotNull
    public FqName parseFqName() {
        FqName fqName = FqName.topLevel(this.parseName());
        while (this.consumeIfLookingAt('.')) {
            fqName = fqName.child(this.parseName());
        }
        return fqName;
    }

    @NotNull
    public JetTypeName parse() {
        FqName fqName = this.parseFqName();
        ArrayList<JetTypeName> typeArguments = Lists.newArrayList();
        if (this.consumeIfLookingAt('<')) {
            typeArguments.add(this.parse());
            while (this.consumeIfLookingAt(',')) {
                typeArguments.add(this.parse());
            }
            this.consume('>');
        }
        return new JetTypeName(fqName, typeArguments);
    }

    @NotNull
    public static JetTypeName parse(@NotNull String string) {
        JetTypeNameParser parser = new JetTypeNameParser(string);
        JetTypeName typeName = parser.parse();
        parser.checkEof();
        return typeName;
    }
}

