/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProcessCanceledException;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.jet.internal.com.intellij.psi.PsiFileFactory;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.TopDownAnalyzer;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.plugin.JetFileType;

public class JetStandardLibrary {
    private static JetStandardLibrary instance = null;
    private static boolean initializing;
    private static Throwable initializationFailed;
    private JetScope libraryScope;
    private ClassDescriptor numberClass;
    private ClassDescriptor charSequenceClass;
    private ClassDescriptor stringClass;
    private ClassDescriptor arrayClass;
    private ClassDescriptor iterableClass;
    private ClassDescriptor comparableClass;
    private ClassDescriptor volatileClass;
    private ClassDescriptor throwableClass;
    private JetType numberType;
    private JetType stringType;
    private JetType volatileType;
    private JetType nullableStringType;
    private JetType charSequenceType;
    private JetType nullableCharSequenceType;
    private JetType nullableTuple0Type;
    private JetType throwableType;
    private JetType nullableThrowableType;
    private JetType tuple0Type;
    private EnumMap<PrimitiveType, ClassDescriptor> primitiveTypeToClass;
    private EnumMap<PrimitiveType, ClassDescriptor> primitiveTypeToArrayClass;
    private EnumMap<PrimitiveType, JetType> primitiveTypeToJetType;
    private EnumMap<PrimitiveType, JetType> primitiveTypeToNullableJetType;
    private EnumMap<PrimitiveType, JetType> primitiveTypeToArrayJetType;
    private EnumMap<PrimitiveType, JetType> primitiveTypeToNullableArrayJetType;
    private Map<JetType, JetType> primitiveJetTypeToJetArrayType;
    private Map<JetType, JetType> jetArrayTypeToPrimitiveJetType;

    public static synchronized void initialize(@NotNull Project project) {
        if (instance == null) {
            if (initializationFailed != null) {
                throw new RuntimeException("builtin library initialization failed previously: " + initializationFailed, initializationFailed);
            }
            if (initializing) {
                throw new IllegalStateException("builtin library initialization loop");
            }
            initializing = true;
            try {
                instance = new JetStandardLibrary(project);
            }
            catch (Throwable e) {
                initializationFailed = e;
                throw new RuntimeException("builtin library initialization failed: " + e, e);
            }
            initializing = false;
        }
    }

    @NotNull
    public static JetStandardLibrary getInstance() {
        return instance;
    }

    private JetStandardLibrary(@NotNull Project project) {
        List<String> libraryFiles = Arrays.asList("Library.jet", "Numbers.jet", "Ranges.jet", "Iterables.jet", "Iterators.jet", "Arrays.jet");
        try {
            LinkedList<JetFile> files = new LinkedList<JetFile>();
            for (String fileName : libraryFiles) {
                String path = "jet/" + fileName;
                InputStream stream = JetStandardClasses.class.getClassLoader().getResourceAsStream(path);
                if (stream == null) {
                    throw new IllegalStateException("resource not found in classpath: " + path);
                }
                JetFile file = (JetFile)PsiFileFactory.getInstance(project).createFileFromText(fileName, JetFileType.INSTANCE, (CharSequence)FileUtil.loadTextAndClose(new InputStreamReader(stream)));
                files.add(file);
            }
            BindingTraceContext bindingTraceContext = new BindingTraceContext();
            WritableScopeImpl writableScope = new WritableScopeImpl(JetStandardClasses.STANDARD_CLASSES, JetStandardClasses.STANDARD_CLASSES_NAMESPACE, RedeclarationHandler.THROW_EXCEPTION, "Root bootstrap scope");
            writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
            TopDownAnalyzer.processStandardLibraryNamespace(project, bindingTraceContext, writableScope, JetStandardClasses.STANDARD_CLASSES_NAMESPACE, files);
            AnalyzingUtils.throwExceptionOnErrors(bindingTraceContext.getBindingContext());
            this.initStdClasses();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
    }

    public JetScope getLibraryScope() {
        this.initStdClasses();
        return this.libraryScope;
    }

    private void initStdClasses() {
        if (this.libraryScope == null) {
            this.libraryScope = JetStandardClasses.STANDARD_CLASSES_NAMESPACE.getMemberScope();
            this.numberClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("Number"));
            this.stringClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("String"));
            this.charSequenceClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("CharSequence"));
            this.arrayClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("Array"));
            this.volatileClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("volatile"));
            this.throwableClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("Throwable"));
            this.iterableClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("Iterable"));
            this.comparableClass = (ClassDescriptor)this.libraryScope.getClassifier(Name.identifier("Comparable"));
            this.numberType = new JetTypeImpl(this.getNumber());
            this.stringType = new JetTypeImpl(this.getString());
            this.charSequenceType = new JetTypeImpl(this.getCharSequence());
            this.nullableCharSequenceType = TypeUtils.makeNullable(this.charSequenceType);
            this.nullableStringType = TypeUtils.makeNullable(this.stringType);
            this.volatileType = new JetTypeImpl(this.getVolatile());
            this.throwableType = new JetTypeImpl(this.getThrowable());
            this.nullableThrowableType = TypeUtils.makeNullable(this.throwableType);
            this.tuple0Type = new JetTypeImpl(JetStandardClasses.getTuple(0));
            this.nullableTuple0Type = TypeUtils.makeNullable(this.tuple0Type);
            this.primitiveTypeToClass = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToJetType = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToNullableJetType = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToArrayClass = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToArrayJetType = new EnumMap(PrimitiveType.class);
            this.primitiveTypeToNullableArrayJetType = new EnumMap(PrimitiveType.class);
            this.primitiveJetTypeToJetArrayType = new HashMap<JetType, JetType>();
            this.jetArrayTypeToPrimitiveJetType = new HashMap<JetType, JetType>();
            for (PrimitiveType primitive : PrimitiveType.values()) {
                this.makePrimitive(primitive);
            }
        }
    }

    private void makePrimitive(PrimitiveType primitiveType) {
        ClassDescriptor clazz = (ClassDescriptor)this.libraryScope.getClassifier(primitiveType.getTypeName());
        ClassDescriptor arrayClazz = (ClassDescriptor)this.libraryScope.getClassifier(primitiveType.getArrayTypeName());
        JetTypeImpl type = new JetTypeImpl(clazz);
        JetTypeImpl arrayType = new JetTypeImpl(arrayClazz);
        this.primitiveTypeToClass.put(primitiveType, clazz);
        this.primitiveTypeToJetType.put(primitiveType, type);
        this.primitiveTypeToNullableJetType.put(primitiveType, TypeUtils.makeNullable(type));
        this.primitiveTypeToArrayClass.put(primitiveType, arrayClazz);
        this.primitiveTypeToArrayJetType.put(primitiveType, arrayType);
        this.primitiveTypeToNullableArrayJetType.put(primitiveType, TypeUtils.makeNullable(arrayType));
        this.primitiveJetTypeToJetArrayType.put(type, arrayType);
        this.jetArrayTypeToPrimitiveJetType.put(arrayType, type);
    }

    public Collection<ClassDescriptor> getStandardTypes() {
        this.initStdClasses();
        ArrayList<ClassDescriptor> classDescriptors = new ArrayList<ClassDescriptor>(this.primitiveTypeToClass.values());
        classDescriptors.add(this.numberClass);
        classDescriptors.add(this.stringClass);
        classDescriptors.add(this.charSequenceClass);
        classDescriptors.add(this.arrayClass);
        classDescriptors.add(this.volatileClass);
        classDescriptors.add(this.throwableClass);
        classDescriptors.add(this.iterableClass);
        classDescriptors.add(this.comparableClass);
        return classDescriptors;
    }

    @NotNull
    public ClassDescriptor getNumber() {
        this.initStdClasses();
        return this.numberClass;
    }

    @NotNull
    public ClassDescriptor getPrimitiveClassDescriptor(PrimitiveType primitiveType) {
        this.initStdClasses();
        return this.primitiveTypeToClass.get((Object)primitiveType);
    }

    @NotNull
    public ClassDescriptor getByte() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.BYTE);
    }

    @NotNull
    public ClassDescriptor getChar() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.CHAR);
    }

    @NotNull
    public ClassDescriptor getShort() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.SHORT);
    }

    @NotNull
    public ClassDescriptor getInt() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.INT);
    }

    @NotNull
    public ClassDescriptor getLong() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.LONG);
    }

    @NotNull
    public ClassDescriptor getFloat() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.FLOAT);
    }

    @NotNull
    public ClassDescriptor getDouble() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.DOUBLE);
    }

    @NotNull
    public ClassDescriptor getBoolean() {
        return this.getPrimitiveClassDescriptor(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public ClassDescriptor getString() {
        this.initStdClasses();
        return this.stringClass;
    }

    @NotNull
    public ClassDescriptor getCharSequence() {
        this.initStdClasses();
        return this.charSequenceClass;
    }

    @NotNull
    public ClassDescriptor getArray() {
        this.initStdClasses();
        return this.arrayClass;
    }

    @NotNull
    public ClassDescriptor getIterable() {
        this.initStdClasses();
        return this.iterableClass;
    }

    @NotNull
    public ClassDescriptor getComparable() {
        this.initStdClasses();
        return this.comparableClass;
    }

    @NotNull
    public ClassDescriptor getThrowable() {
        this.initStdClasses();
        return this.throwableClass;
    }

    @NotNull
    public JetType getPrimitiveJetType(PrimitiveType primitiveType) {
        return this.primitiveTypeToJetType.get((Object)primitiveType);
    }

    @NotNull
    public JetType getIntType() {
        return this.getPrimitiveJetType(PrimitiveType.INT);
    }

    @NotNull
    public JetType getLongType() {
        return this.getPrimitiveJetType(PrimitiveType.LONG);
    }

    @NotNull
    public JetType getDoubleType() {
        return this.getPrimitiveJetType(PrimitiveType.DOUBLE);
    }

    @NotNull
    public JetType getFloatType() {
        return this.getPrimitiveJetType(PrimitiveType.FLOAT);
    }

    @NotNull
    public JetType getCharType() {
        return this.getPrimitiveJetType(PrimitiveType.CHAR);
    }

    @NotNull
    public JetType getBooleanType() {
        return this.getPrimitiveJetType(PrimitiveType.BOOLEAN);
    }

    @NotNull
    public JetType getStringType() {
        this.initStdClasses();
        return this.stringType;
    }

    @NotNull
    public JetType getCharSequenceType() {
        this.initStdClasses();
        return this.charSequenceType;
    }

    @NotNull
    public JetType getByteType() {
        return this.getPrimitiveJetType(PrimitiveType.BYTE);
    }

    @NotNull
    public JetType getShortType() {
        return this.getPrimitiveJetType(PrimitiveType.SHORT);
    }

    @NotNull
    public JetType getArrayType(@NotNull JetType argument) {
        return this.getArrayType(Variance.INVARIANT, argument);
    }

    @NotNull
    public JetType getArrayType(@NotNull Variance projectionType, @NotNull JetType argument) {
        List<TypeProjection> types = Collections.singletonList(new TypeProjection(projectionType, argument));
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.getArray().getTypeConstructor(), false, types, this.getArray().getMemberScope(types));
    }

    @NotNull
    public JetType getArrayElementType(@NotNull JetType arrayType) {
        if (arrayType.getConstructor().getDeclarationDescriptor() == this.getArray()) {
            if (arrayType.getArguments().size() != 1) {
                throw new IllegalStateException();
            }
            return arrayType.getArguments().get(0).getType();
        }
        JetType primitiveType = this.jetArrayTypeToPrimitiveJetType.get(arrayType);
        if (primitiveType == null) {
            throw new IllegalStateException("not array: " + arrayType);
        }
        return primitiveType;
    }

    @NotNull
    public JetType getIterableType(@NotNull JetType argument) {
        return this.getIterableType(Variance.INVARIANT, argument);
    }

    @NotNull
    public JetType getIterableType(@NotNull Variance projectionType, @NotNull JetType argument) {
        List<TypeProjection> types = Collections.singletonList(new TypeProjection(projectionType, argument));
        return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.getIterable().getTypeConstructor(), false, types, this.getIterable().getMemberScope(types));
    }

    @NotNull
    public JetType getNullableStringType() {
        this.initStdClasses();
        return this.nullableStringType;
    }

    @NotNull
    public JetType getNullableCharSequenceType() {
        this.initStdClasses();
        return this.nullableCharSequenceType;
    }

    @NotNull
    public JetType getThrowableType() {
        this.initStdClasses();
        return this.throwableType;
    }

    public JetType getNullableThrowableType() {
        this.initStdClasses();
        return this.nullableThrowableType;
    }

    @NotNull
    public JetType getNullablePrimitiveJetType(PrimitiveType primitiveType) {
        this.initStdClasses();
        return this.primitiveTypeToNullableJetType.get((Object)primitiveType);
    }

    public JetType getNullableTuple0Type() {
        this.initStdClasses();
        return this.nullableTuple0Type;
    }

    @NotNull
    public JetType getPrimitiveArrayJetType(PrimitiveType primitiveType) {
        this.initStdClasses();
        return this.primitiveTypeToArrayJetType.get((Object)primitiveType);
    }

    @Nullable
    public JetType getPrimitiveArrayJetTypeByPrimitiveJetType(JetType jetType) {
        return this.primitiveJetTypeToJetArrayType.get(jetType);
    }

    @NotNull
    public ClassDescriptor getPrimitiveArrayClassDescriptor(PrimitiveType primitiveType) {
        this.initStdClasses();
        return this.primitiveTypeToArrayClass.get((Object)primitiveType);
    }

    @NotNull
    public JetType getNullablePrimitiveArrayJetType(PrimitiveType primitiveType) {
        this.initStdClasses();
        return this.primitiveTypeToNullableArrayJetType.get((Object)primitiveType);
    }

    public ClassDescriptor getVolatile() {
        return this.volatileClass;
    }

    public JetType getVolatileType() {
        return this.volatileType;
    }

    public final boolean isVolatile(PropertyDescriptor descriptor) {
        List<AnnotationDescriptor> annotations = descriptor.getOriginal().getAnnotations();
        if (annotations != null) {
            for (AnnotationDescriptor d : annotations) {
                if (!((Object)d.getType()).equals(this.getVolatileType())) continue;
                return true;
            }
        }
        return false;
    }

    public JetType getTuple0Type() {
        return this.tuple0Type;
    }

    public JetType getNumberType() {
        return this.numberType;
    }
}

