/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.lang;

import java.lang.reflect.Field;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.Variance;

public class JetStandardClasses {
    public static final ModuleDescriptor FAKE_STANDARD_CLASSES_MODULE;
    private static final NamespaceDescriptorImpl STANDARD_CLASSES_FAKE_ROOT_NS;
    public static NamespaceDescriptorImpl STANDARD_CLASSES_NAMESPACE;
    public static final FqName STANDARD_CLASSES_FQNAME;
    private static final ClassDescriptor NOTHING_CLASS;
    private static final JetType NOTHING_TYPE;
    private static final JetType NULLABLE_NOTHING_TYPE;
    private static final ClassDescriptor ANY;
    private static final JetType ANY_TYPE;
    private static final JetType NULLABLE_ANY_TYPE;
    private static final JetType DEFAULT_BOUND;
    public static final JetScope STUB;
    public static final int MAX_TUPLE_ORDER = 22;
    private static final Set<TypeConstructor> TUPLE_CONSTRUCTORS;
    private static final ClassDescriptor[] TUPLE;
    public static final int MAX_FUNCTION_ORDER = 22;
    private static final ClassDescriptor[] FUNCTION;
    private static final ClassDescriptor[] RECEIVER_FUNCTION;
    private static final Set<TypeConstructor> FUNCTION_TYPE_CONSTRUCTORS;
    private static final Set<TypeConstructor> RECEIVER_FUNCTION_TYPE_CONSTRUCTORS;
    private static final JetType UNIT_TYPE;
    @NotNull
    public static final JetScope STANDARD_CLASSES;
    public static final Name UNIT_ALIAS;

    private JetStandardClasses() {
    }

    private static WritableScope createScopeForInvokeFunction(ClassDescriptorImpl function, SimpleFunctionDescriptorImpl invoke) {
        WritableScopeImpl scopeForInvoke = new WritableScopeImpl(STUB, function, RedeclarationHandler.THROW_EXCEPTION, "Scope for function type");
        scopeForInvoke.addFunctionDescriptor(invoke);
        scopeForInvoke.changeLockLevel(WritableScope.LockLevel.READING);
        return scopeForInvoke;
    }

    private static List<TypeParameterDescriptor> createTypeParameters(int parameterCount, ClassDescriptorImpl function) {
        ArrayList<TypeParameterDescriptor> parameters = new ArrayList<TypeParameterDescriptor>();
        for (int j = 1; j <= parameterCount; ++j) {
            parameters.add(TypeParameterDescriptorImpl.createWithDefaultBound(function, Collections.<AnnotationDescriptor>emptyList(), true, Variance.IN_VARIANCE, Name.identifier("P" + j), j));
        }
        parameters.add(TypeParameterDescriptorImpl.createWithDefaultBound(function, Collections.<AnnotationDescriptor>emptyList(), true, Variance.OUT_VARIANCE, Name.identifier("R"), parameterCount + 1));
        return parameters;
    }

    @NotNull
    public static JetType getDefaultBound() {
        return DEFAULT_BOUND;
    }

    @NotNull
    public static ClassDescriptor getAny() {
        return ANY;
    }

    @NotNull
    public static JetType getAnyType() {
        return ANY_TYPE;
    }

    public static boolean isAny(JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == ANY_TYPE.getConstructor();
    }

    public static JetType getNullableAnyType() {
        return NULLABLE_ANY_TYPE;
    }

    @NotNull
    public static ClassDescriptor getNothing() {
        return NOTHING_CLASS;
    }

    @NotNull
    public static ClassDescriptor getTuple(int size) {
        return TUPLE[size];
    }

    @NotNull
    public static ClassDescriptor getFunction(int parameterCount) {
        return FUNCTION[parameterCount];
    }

    @NotNull
    public static ClassDescriptor getReceiverFunction(int parameterCount) {
        return RECEIVER_FUNCTION[parameterCount];
    }

    public static JetType getUnitType() {
        return UNIT_TYPE;
    }

    public static JetType getNothingType() {
        return NOTHING_TYPE;
    }

    public static JetType getNullableNothingType() {
        return NULLABLE_NOTHING_TYPE;
    }

    public static boolean isNothing(@NotNull JetType type) {
        return JetStandardClasses.isNothingOrNullableNothing(type) && !type.isNullable();
    }

    public static boolean isNothingOrNullableNothing(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == NOTHING_CLASS.getTypeConstructor();
    }

    public static boolean isUnit(@NotNull JetType type) {
        return !(type instanceof NamespaceType) && type.getConstructor() == UNIT_TYPE.getConstructor();
    }

    public static JetType getTupleType(List<AnnotationDescriptor> annotations, List<JetType> arguments) {
        if (annotations.isEmpty() && arguments.isEmpty()) {
            return JetStandardClasses.getUnitType();
        }
        ClassDescriptor tuple = JetStandardClasses.getTuple(arguments.size());
        List<TypeProjection> typeArguments = JetStandardClasses.toProjections(arguments);
        return new JetTypeImpl(annotations, tuple.getTypeConstructor(), false, typeArguments, tuple.getMemberScope(typeArguments));
    }

    public static JetType getTupleType(List<JetType> arguments) {
        return JetStandardClasses.getTupleType(Collections.<AnnotationDescriptor>emptyList(), arguments);
    }

    public static JetType getTupleType(JetType ... arguments) {
        return JetStandardClasses.getTupleType(Collections.<AnnotationDescriptor>emptyList(), Arrays.asList(arguments));
    }

    public static boolean isTupleType(@NotNull JetType type) {
        return TUPLE_CONSTRUCTORS.contains(type.getConstructor());
    }

    public static List<JetType> getTupleElementTypes(@NotNull JetType type) {
        assert (JetStandardClasses.isTupleType(type));
        ArrayList<JetType> result = Lists.newArrayList();
        for (TypeProjection typeProjection : type.getArguments()) {
            result.add(typeProjection.getType());
        }
        return result;
    }

    public static JetType getLabeledTupleType(List<AnnotationDescriptor> annotations, List<ValueParameterDescriptor> arguments) {
        return JetStandardClasses.getTupleType(annotations, JetStandardClasses.toTypes(arguments));
    }

    public static JetType getLabeledTupleType(List<ValueParameterDescriptor> arguments) {
        return JetStandardClasses.getLabeledTupleType(Collections.<AnnotationDescriptor>emptyList(), arguments);
    }

    private static List<TypeProjection> toProjections(List<JetType> arguments) {
        ArrayList<TypeProjection> result = new ArrayList<TypeProjection>();
        for (JetType argument : arguments) {
            result.add(new TypeProjection(Variance.OUT_VARIANCE, argument));
        }
        return result;
    }

    private static List<JetType> toTypes(List<ValueParameterDescriptor> labeledEntries) {
        ArrayList<JetType> result = new ArrayList<JetType>();
        for (ValueParameterDescriptor entry : labeledEntries) {
            result.add(entry.getType());
        }
        return result;
    }

    public static JetType getFunctionType(List<AnnotationDescriptor> annotations, @Nullable JetType receiverType, @NotNull List<JetType> parameterTypes, @NotNull JetType returnType) {
        ArrayList<TypeProjection> arguments = new ArrayList<TypeProjection>();
        if (receiverType != null) {
            arguments.add(JetStandardClasses.defaultProjection(receiverType));
        }
        for (JetType parameterType : parameterTypes) {
            arguments.add(JetStandardClasses.defaultProjection(parameterType));
        }
        arguments.add(JetStandardClasses.defaultProjection(returnType));
        int size = parameterTypes.size();
        ClassDescriptor classDescriptor = receiverType == null ? FUNCTION[size] : RECEIVER_FUNCTION[size];
        TypeConstructor constructor = classDescriptor.getTypeConstructor();
        return new JetTypeImpl(annotations, constructor, false, arguments, classDescriptor.getMemberScope(arguments));
    }

    private static TypeProjection defaultProjection(JetType returnType) {
        return new TypeProjection(Variance.INVARIANT, returnType);
    }

    public static boolean isFunctionType(@NotNull JetType type) {
        return FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor()) || JetStandardClasses.isReceiverFunctionType(type);
    }

    public static boolean isReceiverFunctionType(@NotNull JetType type) {
        return RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor());
    }

    @Nullable
    public static JetType getReceiverType(@NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type)) : type;
        if (RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor())) {
            return type.getArguments().get(0).getType();
        }
        return null;
    }

    @NotNull
    public static List<ValueParameterDescriptor> getValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type));
        ArrayList<ValueParameterDescriptor> valueParameters = Lists.newArrayList();
        List<TypeProjection> parameterTypes = JetStandardClasses.getParameterTypeProjectionsFromFunctionType(type);
        for (int i = 0; i < parameterTypes.size(); ++i) {
            TypeProjection parameterType = parameterTypes.get(i);
            ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(functionDescriptor, i, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("p" + (i + 1)), false, parameterType.getType(), false, null);
            valueParameters.add(valueParameterDescriptor);
        }
        return valueParameters;
    }

    @NotNull
    public static List<TypeProjection> getParameterTypeProjectionsFromFunctionType(@NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        int first = RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.contains(type.getConstructor()) ? 1 : 0;
        int last = arguments.size() - 2;
        ArrayList<TypeProjection> parameterTypes = Lists.newArrayList();
        for (int i = first; i <= last; ++i) {
            parameterTypes.add(arguments.get(i));
        }
        return parameterTypes;
    }

    @NotNull
    public static JetType getReturnTypeFromFunctionType(@NotNull JetType type) {
        assert (JetStandardClasses.isFunctionType(type));
        List<TypeProjection> arguments = type.getArguments();
        return arguments.get(arguments.size() - 1).getType();
    }

    @NotNull
    public static Collection<DeclarationDescriptor> getAllStandardClasses() {
        return STANDARD_CLASSES.getAllDescriptors();
    }

    static {
        Field[] declaredFields;
        int i;
        FAKE_STANDARD_CLASSES_MODULE = new ModuleDescriptor(Name.special("<builtin>"));
        STANDARD_CLASSES_FAKE_ROOT_NS = new NamespaceDescriptorImpl(FAKE_STANDARD_CLASSES_MODULE, Collections.<AnnotationDescriptor>emptyList(), FqNameUnsafe.ROOT_NAME);
        FAKE_STANDARD_CLASSES_MODULE.setRootNamespace(STANDARD_CLASSES_FAKE_ROOT_NS);
        STANDARD_CLASSES_NAMESPACE = new NamespaceDescriptorImpl(STANDARD_CLASSES_FAKE_ROOT_NS, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("jet"));
        STANDARD_CLASSES_FQNAME = DescriptorUtils.getFQName(STANDARD_CLASSES_NAMESPACE).toSafe();
        NOTHING_CLASS = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("Nothing")).initialize(true, Collections.emptyList(), (Collection<JetType>)new AbstractCollection<JetType>(){

            @Override
            public boolean contains(Object o) {
                return o instanceof JetType;
            }

            @Override
            public Iterator<JetType> iterator() {
                throw new UnsupportedOperationException("Don't enumerate supertypes of Nothing");
            }

            @Override
            public int size() {
                throw new UnsupportedOperationException("Supertypes of Nothing do not constitute a valid collection");
            }
        }, JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, null);
        NOTHING_TYPE = new JetTypeImpl(JetStandardClasses.getNothing());
        NULLABLE_NOTHING_TYPE = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), JetStandardClasses.getNothing().getTypeConstructor(), true, Collections.<TypeProjection>emptyList(), JetScope.EMPTY);
        ANY = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("Any")).initialize(false, Collections.emptyList(), Collections.<JetType>emptySet(), JetScope.EMPTY, Collections.<ConstructorDescriptor>emptySet(), null, null);
        ANY_TYPE = new JetTypeImpl(ANY.getTypeConstructor(), new JetScopeImpl(){

            @Override
            @NotNull
            public DeclarationDescriptor getContainingDeclaration() {
                return STANDARD_CLASSES_NAMESPACE;
            }

            public String toString() {
                return "Scope for Any";
            }
        });
        NULLABLE_ANY_TYPE = new JetTypeImpl(ANY_TYPE.getAnnotations(), ANY_TYPE.getConstructor(), true, ANY_TYPE.getArguments(), ANY_TYPE.getMemberScope());
        DEFAULT_BOUND = JetStandardClasses.getNullableAnyType();
        STUB = JetScope.EMPTY;
        TUPLE_CONSTRUCTORS = Sets.newHashSet();
        TUPLE = new ClassDescriptor[23];
        for (i = 0; i <= 22; ++i) {
            ArrayList<TypeParameterDescriptor> parameters = new ArrayList<TypeParameterDescriptor>();
            ClassDescriptorImpl classDescriptor = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("Tuple" + i));
            WritableScopeImpl writableScope = new WritableScopeImpl(JetScope.EMPTY, classDescriptor, RedeclarationHandler.THROW_EXCEPTION, "tuples");
            for (int j = 0; j < i; ++j) {
                TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptorImpl.createWithDefaultBound(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), true, Variance.OUT_VARIANCE, Name.identifier("T" + (j + 1)), j);
                parameters.add(typeParameterDescriptor);
                PropertyDescriptor propertyDescriptor = new PropertyDescriptor(classDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibilities.PUBLIC, false, false, Name.identifier("_" + (j + 1)), CallableMemberDescriptor.Kind.DECLARATION);
                propertyDescriptor.setType(typeParameterDescriptor.getDefaultType(), Collections.emptyList(), classDescriptor.getImplicitReceiver(), ReceiverDescriptor.NO_RECEIVER);
                PropertyGetterDescriptor getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.FINAL, Visibilities.PUBLIC, false, true, CallableMemberDescriptor.Kind.DECLARATION);
                getterDescriptor.initialize(typeParameterDescriptor.getDefaultType());
                propertyDescriptor.initialize(getterDescriptor, null);
                writableScope.addPropertyDescriptor(propertyDescriptor);
            }
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            JetStandardClasses.TUPLE[i] = classDescriptor.initialize(true, parameters, Collections.singleton(JetStandardClasses.getAnyType()), writableScope, Collections.<ConstructorDescriptor>emptySet(), null);
            TUPLE_CONSTRUCTORS.add(TUPLE[i].getTypeConstructor());
        }
        FUNCTION = new ClassDescriptor[23];
        RECEIVER_FUNCTION = new ClassDescriptor[23];
        FUNCTION_TYPE_CONSTRUCTORS = Sets.newHashSet();
        RECEIVER_FUNCTION_TYPE_CONSTRUCTORS = Sets.newHashSet();
        for (i = 0; i <= 22; ++i) {
            ClassDescriptorImpl function = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("Function" + i));
            SimpleFunctionDescriptorImpl invoke = new SimpleFunctionDescriptorImpl(function, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("invoke"), CallableMemberDescriptor.Kind.DECLARATION);
            WritableScope scopeForInvoke = JetStandardClasses.createScopeForInvokeFunction(function, invoke);
            List<TypeParameterDescriptor> typeParameters = JetStandardClasses.createTypeParameters(i, function);
            JetStandardClasses.FUNCTION[i] = function.initialize(false, typeParameters, Collections.singleton(JetStandardClasses.getAnyType()), scopeForInvoke, Collections.<ConstructorDescriptor>emptySet(), null);
            FUNCTION_TYPE_CONSTRUCTORS.add(FUNCTION[i].getTypeConstructor());
            FunctionDescriptorUtil.initializeFromFunctionType(invoke, function.getDefaultType(), new ClassReceiver(FUNCTION[i]), Modality.ABSTRACT, Visibilities.PUBLIC);
            ClassDescriptorImpl receiverFunction = new ClassDescriptorImpl(STANDARD_CLASSES_NAMESPACE, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("ExtensionFunction" + i));
            SimpleFunctionDescriptorImpl invokeWithReceiver = new SimpleFunctionDescriptorImpl(receiverFunction, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("invoke"), CallableMemberDescriptor.Kind.DECLARATION);
            WritableScope scopeForInvokeWithReceiver = JetStandardClasses.createScopeForInvokeFunction(receiverFunction, invokeWithReceiver);
            List<TypeParameterDescriptor> parameters = JetStandardClasses.createTypeParameters(i, receiverFunction);
            parameters.add(0, TypeParameterDescriptorImpl.createWithDefaultBound(receiverFunction, Collections.<AnnotationDescriptor>emptyList(), true, Variance.IN_VARIANCE, Name.identifier("T"), 0));
            JetStandardClasses.RECEIVER_FUNCTION[i] = receiverFunction.initialize(false, parameters, Collections.singleton(JetStandardClasses.getAnyType()), scopeForInvokeWithReceiver, Collections.<ConstructorDescriptor>emptySet(), null);
            RECEIVER_FUNCTION_TYPE_CONSTRUCTORS.add(RECEIVER_FUNCTION[i].getTypeConstructor());
            FunctionDescriptorUtil.initializeFromFunctionType(invokeWithReceiver, receiverFunction.getDefaultType(), new ClassReceiver(RECEIVER_FUNCTION[i]), Modality.ABSTRACT, Visibilities.PUBLIC);
        }
        UNIT_TYPE = new JetTypeImpl(JetStandardClasses.getTuple(0));
        UNIT_ALIAS = Name.identifier("Unit");
        WritableScopeImpl writableScope = new WritableScopeImpl(JetScope.EMPTY, STANDARD_CLASSES_NAMESPACE, RedeclarationHandler.DO_NOTHING, "JetStandardClasses.STANDARD_CLASSES");
        writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        STANDARD_CLASSES = writableScope;
        writableScope.addClassifierAlias(UNIT_ALIAS, JetStandardClasses.getTuple(0));
        for (Field field : declaredFields = JetStandardClasses.class.getDeclaredFields()) {
            if ((field.getModifiers() & 8) == 0) continue;
            Class<?> type = field.getType();
            if (type == ClassDescriptor.class) {
                try {
                    ClassDescriptor descriptor = (ClassDescriptor)field.get(null);
                    writableScope.addClassifierDescriptor(descriptor);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (!type.isArray() || type.getComponentType() != ClassDescriptor.class) continue;
            try {
                ClassDescriptor[] array;
                for (ClassDescriptor descriptor : array = (ClassDescriptor[])field.get(null)) {
                    writableScope.addClassifierDescriptor(descriptor);
                }
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
        STANDARD_CLASSES_NAMESPACE.initialize(writableScope);
    }
}

