/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Stack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;

public class LabelResolver {
    private final Map<LabelName, Stack<JetElement>> labeledElements = new HashMap<LabelName, Stack<JetElement>>();

    public void enterLabeledElement(@NotNull LabelName labelName, @NotNull JetExpression labeledExpression) {
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(labeledExpression);
        if (deparenthesized != null) {
            Stack<JetElement> stack = this.labeledElements.get(labelName);
            if (stack == null) {
                stack = new Stack();
                this.labeledElements.put(labelName, stack);
            }
            stack.push(deparenthesized);
        }
    }

    public void exitLabeledElement(@NotNull JetExpression expression) {
        JetExpression deparenthesized = JetPsiUtil.deparenthesize(expression);
        Iterator<Map.Entry<LabelName, Stack<JetElement>>> mapIter = this.labeledElements.entrySet().iterator();
        while (mapIter.hasNext()) {
            Map.Entry<LabelName, Stack<JetElement>> entry = mapIter.next();
            Stack<JetElement> stack = entry.getValue();
            Iterator stackIter = stack.iterator();
            while (stackIter.hasNext()) {
                JetElement recorded = (JetElement)stackIter.next();
                if (recorded != deparenthesized) continue;
                stackIter.remove();
            }
            if (!stack.isEmpty()) continue;
            mapIter.remove();
        }
    }

    @Nullable
    private JetElement resolveControlLabel(@NotNull LabelName labelName, @NotNull JetSimpleNameExpression labelExpression, boolean reportUnresolved, ExpressionTypingContext context) {
        Collection<DeclarationDescriptor> declarationsByLabel = context.scope.getDeclarationsByLabel(labelName);
        int size = declarationsByLabel.size();
        if (size == 1) {
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (!(declarationDescriptor instanceof FunctionDescriptor) && !(declarationDescriptor instanceof ClassDescriptor)) {
                throw new UnsupportedOperationException();
            }
            JetElement element = (JetElement)BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), declarationDescriptor);
            context.trace.record(BindingContext.LABEL_TARGET, labelExpression, element);
            return element;
        }
        if (size == 0) {
            return this.resolveNamedLabel(labelName, labelExpression, reportUnresolved, context);
        }
        context.trace.report(Errors.AMBIGUOUS_LABEL.on(labelExpression));
        return null;
    }

    @Nullable
    public JetElement resolveLabel(JetLabelQualifiedExpression expression, ExpressionTypingContext context) {
        JetSimpleNameExpression labelElement = expression.getTargetLabel();
        if (labelElement != null) {
            LabelName labelName = new LabelName(expression.getLabelName());
            return this.resolveControlLabel(labelName, labelElement, true, context);
        }
        return null;
    }

    private JetElement resolveNamedLabel(@NotNull LabelName labelName, @NotNull JetSimpleNameExpression labelExpression, boolean reportUnresolved, ExpressionTypingContext context) {
        Stack<JetElement> stack = this.labeledElements.get(labelName);
        if (stack == null || stack.isEmpty()) {
            if (reportUnresolved) {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(labelExpression));
            }
            return null;
        }
        if (stack.size() > 1) {
            context.trace.report(Errors.LABEL_NAME_CLASH.on(labelExpression));
        }
        JetElement result = stack.peek();
        context.trace.record(BindingContext.LABEL_TARGET, labelExpression, result);
        return result;
    }

    public ReceiverDescriptor resolveThisLabel(JetReferenceExpression thisReference, JetSimpleNameExpression targetLabel, ExpressionTypingContext context, ReceiverDescriptor thisReceiver, LabelName labelName) {
        Collection<DeclarationDescriptor> declarationsByLabel = context.scope.getDeclarationsByLabel(labelName);
        int size = declarationsByLabel.size();
        assert (targetLabel != null);
        if (size == 1) {
            DeclarationDescriptor declarationDescriptor = declarationsByLabel.iterator().next();
            if (declarationDescriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
                thisReceiver = classDescriptor.getImplicitReceiver();
            } else if (declarationDescriptor instanceof FunctionDescriptor) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)declarationDescriptor;
                thisReceiver = functionDescriptor.getReceiverParameter();
            } else {
                throw new UnsupportedOperationException();
            }
            PsiElement element = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), declarationDescriptor);
            assert (element != null);
            context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
            context.trace.record(BindingContext.REFERENCE_TARGET, thisReference, declarationDescriptor);
        } else if (size == 0) {
            JetElement element = this.resolveNamedLabel(labelName, targetLabel, false, context);
            if (element instanceof JetFunctionLiteralExpression) {
                DeclarationDescriptor declarationDescriptor = context.trace.getBindingContext().get(BindingContext.DECLARATION_TO_DESCRIPTOR, element);
                if (declarationDescriptor instanceof FunctionDescriptor) {
                    thisReceiver = ((FunctionDescriptor)declarationDescriptor).getReceiverParameter();
                    if (thisReceiver.exists()) {
                        context.trace.record(BindingContext.LABEL_TARGET, targetLabel, element);
                        context.trace.record(BindingContext.REFERENCE_TARGET, thisReference, declarationDescriptor);
                    }
                } else {
                    context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel));
                }
            } else {
                context.trace.report(Errors.UNRESOLVED_REFERENCE.on(targetLabel));
            }
        } else {
            context.trace.report(Errors.AMBIGUOUS_LABEL.on(targetLabel));
        }
        return thisReceiver;
    }
}

