/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.internal.com.intellij.psi.tree.TokenSet;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.QualifiedExpressionResolver;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemWithPriorities;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ControlStructureTypingVisitor;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingFacade;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class ExpressionTypingUtils {
    private ExpressionTypingUtils() {
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull JetExpression expression, @Nullable JetType type) {
        if (type == null) {
            return null;
        }
        return new ExpressionReceiver(expression, type);
    }

    @Nullable
    protected static ExpressionReceiver getExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        return ExpressionTypingUtils.getExpressionReceiver(expression, facade.getType(expression, context));
    }

    @NotNull
    protected static ExpressionReceiver safeGetExpressionReceiver(@NotNull ExpressionTypingFacade facade, @NotNull JetExpression expression, ExpressionTypingContext context) {
        return new ExpressionReceiver(expression, facade.safeGetType(expression, context));
    }

    @NotNull
    public static WritableScopeImpl newWritableScopeImpl(ExpressionTypingContext context, @NotNull String scopeDebugName) {
        WritableScopeImpl scope = new WritableScopeImpl(context.scope, context.scope.getContainingDeclaration(), new TraceBasedRedeclarationHandler(context.trace), scopeDebugName);
        scope.changeLockLevel(WritableScope.LockLevel.BOTH);
        return scope;
    }

    public static boolean isBoolean(@NotNull JetType type) {
        return JetTypeChecker.INSTANCE.isSubtypeOf(type, JetStandardLibrary.getInstance().getBooleanType());
    }

    public static boolean ensureBooleanResult(JetExpression operationSign, Name name, JetType resultType, ExpressionTypingContext context) {
        return ExpressionTypingUtils.ensureBooleanResultWithCustomSubject(operationSign, resultType, "'" + name + "'", context);
    }

    public static boolean ensureBooleanResultWithCustomSubject(JetExpression operationSign, JetType resultType, String subjectName, ExpressionTypingContext context) {
        if (resultType != null && !ExpressionTypingUtils.isBoolean(resultType)) {
            context.trace.report(Errors.RESULT_TYPE_MISMATCH.on(operationSign, subjectName, JetStandardLibrary.getInstance().getBooleanType(), resultType));
            return false;
        }
        return true;
    }

    @NotNull
    public static JetType getDefaultType(IElementType constantType) {
        if (constantType == JetNodeTypes.INTEGER_CONSTANT) {
            return JetStandardLibrary.getInstance().getIntType();
        }
        if (constantType == JetNodeTypes.FLOAT_CONSTANT) {
            return JetStandardLibrary.getInstance().getDoubleType();
        }
        if (constantType == JetNodeTypes.BOOLEAN_CONSTANT) {
            return JetStandardLibrary.getInstance().getBooleanType();
        }
        if (constantType == JetNodeTypes.CHARACTER_CONSTANT) {
            return JetStandardLibrary.getInstance().getCharType();
        }
        if (constantType == JetNodeTypes.NULL) {
            return JetStandardClasses.getNullableNothingType();
        }
        throw new IllegalArgumentException("Unsupported constant type: " + constantType);
    }

    public static boolean isTypeFlexible(@Nullable JetExpression expression) {
        if (expression == null) {
            return false;
        }
        return TokenSet.create(JetNodeTypes.INTEGER_CONSTANT, JetNodeTypes.FLOAT_CONSTANT).contains(expression.getNode().getElementType());
    }

    public static void checkWrappingInRef(JetSimpleNameExpression expression, ExpressionTypingContext context) {
        VariableDescriptor variable = BindingContextUtils.extractVariableDescriptorIfAny(context.trace.getBindingContext(), expression, true);
        if (variable != null) {
            DeclarationDescriptor containingDeclaration = variable.getContainingDeclaration();
            if (context.scope.getContainingDeclaration() != containingDeclaration && containingDeclaration instanceof CallableDescriptor) {
                context.trace.record(BindingContext.CAPTURED_IN_CLOSURE, variable);
            }
        }
    }

    @NotNull
    public static JetExpression createStubExpressionOfNecessaryType(@NotNull Project project, @NotNull JetType type, @NotNull BindingTrace trace) {
        JetExpression expression = JetPsiFactory.createExpression(project, "$e");
        trace.record(BindingContext.PROCESSED, expression);
        trace.record(BindingContext.EXPRESSION_TYPE, expression, type);
        return expression;
    }

    public static boolean isVariableIterable(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull Project project, @NotNull VariableDescriptor variableDescriptor, @NotNull JetScope scope) {
        ExpressionTypingContext context;
        JetExpression expression = JetPsiFactory.createExpression(project, "fake");
        ExpressionReceiver expressionReceiver = new ExpressionReceiver(expression, variableDescriptor.getType());
        return ControlStructureTypingVisitor.checkIterableConvention(expressionReceiver, context = ExpressionTypingContext.newContext(expressionTypingServices, new BindingTraceContext(), scope, DataFlowInfo.EMPTY, TypeUtils.NO_EXPECTED_TYPE, false)) != null;
    }

    public static List<CallableDescriptor> canFindSuitableCall(@NotNull FqName callableFQN, @NotNull Project project, @NotNull JetExpression receiverExpression, @NotNull JetType receiverType, @NotNull JetScope scope) {
        JetImportDirective importDirective = JetPsiFactory.createImportDirective(project, callableFQN.getFqName());
        Collection<? extends DeclarationDescriptor> declarationDescriptors = new QualifiedExpressionResolver().analyseImportReference(importDirective, scope, new BindingTraceContext());
        ArrayList<CallableDescriptor> callableExtensionDescriptors = new ArrayList<CallableDescriptor>();
        ExpressionReceiver receiverDescriptor = new ExpressionReceiver(receiverExpression, receiverType);
        for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
            CallableDescriptor callableDescriptor;
            if (!(declarationDescriptor instanceof CallableDescriptor) || !ExpressionTypingUtils.checkIsExtensionCallable(receiverDescriptor, callableDescriptor = (CallableDescriptor)declarationDescriptor)) continue;
            callableExtensionDescriptors.add(callableDescriptor);
        }
        return callableExtensionDescriptors;
    }

    public static boolean checkIsExtensionCallable(@NotNull ReceiverDescriptor expectedReceiver, @NotNull CallableDescriptor receiverArgument) {
        JetType notNullableType;
        JetType type = expectedReceiver.getType();
        if (type instanceof NamespaceType) {
            return false;
        }
        if (ExpressionTypingUtils.checkReceiverResolution(expectedReceiver, type, receiverArgument)) {
            return true;
        }
        return type.isNullable() && ExpressionTypingUtils.checkReceiverResolution(expectedReceiver, notNullableType = TypeUtils.makeNotNullable(type), receiverArgument);
    }

    private static boolean checkReceiverResolution(@NotNull ReceiverDescriptor expectedReceiver, @NotNull JetType receiverType, @NotNull CallableDescriptor receiverArgument) {
        ConstraintSystemWithPriorities constraintSystem = new ConstraintSystemWithPriorities(ConstraintResolutionListener.DO_NOTHING);
        for (TypeParameterDescriptor typeParameterDescriptor : receiverArgument.getTypeParameters()) {
            constraintSystem.registerTypeVariable(typeParameterDescriptor, Variance.INVARIANT);
        }
        ReceiverDescriptor receiverParameter = receiverArgument.getReceiverParameter();
        if (expectedReceiver.exists() && receiverParameter.exists()) {
            constraintSystem.addSubtypingConstraint(ConstraintType.RECEIVER.assertSubtyping(receiverType, receiverParameter.getType()));
        } else if (expectedReceiver.exists() || receiverParameter.exists()) {
            return false;
        }
        ConstraintSystemSolution solution = constraintSystem.solve();
        return solution.getStatus().isSuccessful();
    }
}

