/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.lang.ASTNode;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.BasicResolutionContext;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstantResolver;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.LabelResolver;

public class ExpressionTypingContext {
    public final ExpressionTypingServices expressionTypingServices;
    public final BindingTrace trace;
    public final JetScope scope;
    public final DataFlowInfo dataFlowInfo;
    public final JetType expectedType;
    public final Map<JetPattern, DataFlowInfo> patternsToDataFlowInfo;
    public final Map<JetPattern, List<VariableDescriptor>> patternsToBoundVariableLists;
    public final LabelResolver labelResolver;
    public final boolean namespacesAllowed;
    private CompileTimeConstantResolver compileTimeConstantResolver;

    @NotNull
    public static ExpressionTypingContext newContext(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, boolean namespacesAllowed) {
        return ExpressionTypingContext.newContext(expressionTypingServices, new HashMap<JetPattern, DataFlowInfo>(), new HashMap<JetPattern, List<VariableDescriptor>>(), new LabelResolver(), trace, scope, dataFlowInfo, expectedType, namespacesAllowed);
    }

    @NotNull
    public static ExpressionTypingContext newContext(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull Map<JetPattern, DataFlowInfo> patternsToDataFlowInfo, @NotNull Map<JetPattern, List<VariableDescriptor>> patternsToBoundVariableLists, @NotNull LabelResolver labelResolver, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, boolean namespacesAllowed) {
        return new ExpressionTypingContext(expressionTypingServices, patternsToDataFlowInfo, patternsToBoundVariableLists, labelResolver, trace, scope, dataFlowInfo, expectedType, namespacesAllowed);
    }

    private ExpressionTypingContext(@NotNull ExpressionTypingServices expressionTypingServices, @NotNull Map<JetPattern, DataFlowInfo> patternsToDataFlowInfo, @NotNull Map<JetPattern, List<VariableDescriptor>> patternsToBoundVariableLists, @NotNull LabelResolver labelResolver, @NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull DataFlowInfo dataFlowInfo, @NotNull JetType expectedType, boolean namespacesAllowed) {
        this.expressionTypingServices = expressionTypingServices;
        this.trace = trace;
        this.patternsToBoundVariableLists = patternsToBoundVariableLists;
        this.patternsToDataFlowInfo = patternsToDataFlowInfo;
        this.labelResolver = labelResolver;
        this.scope = scope;
        this.dataFlowInfo = dataFlowInfo;
        this.expectedType = expectedType;
        this.namespacesAllowed = namespacesAllowed;
    }

    @NotNull
    public ExpressionTypingContext replaceNamespacesAllowed(boolean namespacesAllowed) {
        if (namespacesAllowed == this.namespacesAllowed) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.expressionTypingServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, this.dataFlowInfo, this.expectedType, namespacesAllowed);
    }

    @NotNull
    public ExpressionTypingContext replaceDataFlowInfo(DataFlowInfo newDataFlowInfo) {
        if (newDataFlowInfo == this.dataFlowInfo) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.expressionTypingServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, newDataFlowInfo, this.expectedType, this.namespacesAllowed);
    }

    @NotNull
    public ExpressionTypingContext replaceExpectedType(@Nullable JetType newExpectedType) {
        if (newExpectedType == null) {
            return this.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        }
        if (this.expectedType == newExpectedType) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.expressionTypingServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, this.scope, this.dataFlowInfo, newExpectedType, this.namespacesAllowed);
    }

    @NotNull
    public ExpressionTypingContext replaceBindingTrace(@NotNull BindingTrace newTrace) {
        if (newTrace == this.trace) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.expressionTypingServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, newTrace, this.scope, this.dataFlowInfo, this.expectedType, this.namespacesAllowed);
    }

    @NotNull
    public ExpressionTypingContext replaceScope(@NotNull JetScope newScope) {
        if (newScope == this.scope) {
            return this;
        }
        return ExpressionTypingContext.newContext(this.expressionTypingServices, this.patternsToDataFlowInfo, this.patternsToBoundVariableLists, this.labelResolver, this.trace, newScope, this.dataFlowInfo, this.expectedType, this.namespacesAllowed);
    }

    public CompileTimeConstantResolver getCompileTimeConstantResolver() {
        if (this.compileTimeConstantResolver == null) {
            this.compileTimeConstantResolver = new CompileTimeConstantResolver();
        }
        return this.compileTimeConstantResolver;
    }

    private BasicResolutionContext makeResolutionContext(@NotNull Call call) {
        return BasicResolutionContext.create(this.trace, this.scope, call, this.expectedType, this.dataFlowInfo);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull Name name) {
        return this.expressionTypingServices.getCallResolver().resolveCallWithGivenName(this.makeResolutionContext(call), functionReference, name);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveFunctionCall(@NotNull Call call) {
        return this.expressionTypingServices.getCallResolver().resolveFunctionCall(this.makeResolutionContext(call));
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull ReceiverDescriptor receiver, @Nullable ASTNode callOperationNode, @NotNull JetSimpleNameExpression nameExpression) {
        Call call = CallMaker.makePropertyCall(receiver, callOperationNode, nameExpression);
        return this.expressionTypingServices.getCallResolver().resolveSimpleProperty(this.makeResolutionContext(call));
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveExactSignature(@NotNull ReceiverDescriptor receiver, @NotNull Name name, @NotNull List<JetType> parameterTypes) {
        return this.expressionTypingServices.getCallResolver().resolveExactSignature(this.scope, receiver, name, parameterTypes);
    }
}

