/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.util.Ref;
import org.jetbrains.jet.internal.com.intellij.psi.tree.IElementType;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetIsExpression;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValue;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowValueFactory;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lexer.JetTokens;

public class DataFlowUtils {
    private DataFlowUtils() {
    }

    @NotNull
    public static DataFlowInfo extractDataFlowInfoFromCondition(@Nullable JetExpression condition, final boolean conditionValue, final @Nullable WritableScope scopeToExtend, final ExpressionTypingContext context) {
        if (condition == null) {
            return context.dataFlowInfo;
        }
        final Ref<Object> result = new Ref<Object>(null);
        condition.accept(new JetVisitorVoid(){

            @Override
            public void visitIsExpression(JetIsExpression expression) {
                if (conditionValue && !expression.isNegated() || !conditionValue && expression.isNegated()) {
                    List<VariableDescriptor> descriptors;
                    JetPattern pattern = expression.getPattern();
                    result.set(context.patternsToDataFlowInfo.get(pattern));
                    if (scopeToExtend != null && (descriptors = context.patternsToBoundVariableLists.get(pattern)) != null) {
                        for (VariableDescriptor variableDescriptor : descriptors) {
                            scopeToExtend.addVariableDescriptor(variableDescriptor);
                        }
                    }
                }
            }

            @Override
            public void visitBinaryExpression(JetBinaryExpression expression) {
                IElementType operationToken = expression.getOperationToken();
                if (operationToken == JetTokens.ANDAND || operationToken == JetTokens.OROR) {
                    WritableScope actualScopeToExtend = operationToken == JetTokens.ANDAND ? (conditionValue ? scopeToExtend : null) : (conditionValue ? null : scopeToExtend);
                    DataFlowInfo dataFlowInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expression.getLeft(), conditionValue, actualScopeToExtend, context);
                    JetExpression expressionRight = expression.getRight();
                    if (expressionRight != null) {
                        DataFlowInfo rightInfo = DataFlowUtils.extractDataFlowInfoFromCondition(expressionRight, conditionValue, actualScopeToExtend, context);
                        DataFlowInfo.CompositionOperator operator = operationToken == JetTokens.ANDAND ? (conditionValue ? DataFlowInfo.AND : DataFlowInfo.OR) : (conditionValue ? DataFlowInfo.OR : DataFlowInfo.AND);
                        dataFlowInfo = operator.compose(dataFlowInfo, rightInfo);
                    }
                    result.set(dataFlowInfo);
                } else {
                    JetExpression left = expression.getLeft();
                    JetExpression right = expression.getRight();
                    if (right == null) {
                        return;
                    }
                    JetType lhsType = context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, left);
                    if (lhsType == null) {
                        return;
                    }
                    JetType rhsType = context.trace.getBindingContext().get(BindingContext.EXPRESSION_TYPE, right);
                    if (rhsType == null) {
                        return;
                    }
                    BindingContext bindingContext = context.trace.getBindingContext();
                    DataFlowValue leftValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(left, lhsType, bindingContext);
                    DataFlowValue rightValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(right, rhsType, bindingContext);
                    Boolean equals = null;
                    if (operationToken == JetTokens.EQEQ || operationToken == JetTokens.EQEQEQ) {
                        equals = true;
                    } else if (operationToken == JetTokens.EXCLEQ || operationToken == JetTokens.EXCLEQEQEQ) {
                        equals = false;
                    }
                    if (equals != null) {
                        if (equals == conditionValue) {
                            result.set(context.dataFlowInfo.equate(leftValue, rightValue));
                        } else {
                            result.set(context.dataFlowInfo.disequate(leftValue, rightValue));
                        }
                    }
                }
            }

            @Override
            public void visitUnaryExpression(JetUnaryExpression expression) {
                JetExpression baseExpression;
                IElementType operationTokenType = expression.getOperationReference().getReferencedNameElementType();
                if (operationTokenType == JetTokens.EXCL && (baseExpression = expression.getBaseExpression()) != null) {
                    result.set(DataFlowUtils.extractDataFlowInfoFromCondition(baseExpression, !conditionValue, scopeToExtend, context));
                }
            }

            @Override
            public void visitParenthesizedExpression(JetParenthesizedExpression expression) {
                JetExpression body = expression.getExpression();
                if (body != null) {
                    body.accept(this);
                }
            }
        });
        if (result.get() == null) {
            return context.dataFlowInfo;
        }
        return context.dataFlowInfo.and(result.get());
    }

    @Nullable
    public static JetType checkType(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ExpressionTypingContext context) {
        if (expressionType == null || context.expectedType == null || context.expectedType == TypeUtils.NO_EXPECTED_TYPE || JetTypeChecker.INSTANCE.isSubtypeOf(expressionType, context.expectedType)) {
            return expressionType;
        }
        DataFlowValue dataFlowValue = DataFlowValueFactory.INSTANCE.createDataFlowValue(expression, expressionType, context.trace.getBindingContext());
        for (JetType possibleType : context.dataFlowInfo.getPossibleTypes(dataFlowValue)) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(possibleType, context.expectedType)) continue;
            if (dataFlowValue.isStableIdentifier()) {
                context.trace.record(BindingContext.AUTOCAST, expression, possibleType);
            } else {
                context.trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expression, possibleType, expression.getText()));
            }
            return possibleType;
        }
        context.trace.report(Errors.TYPE_MISMATCH.on(expression, context.expectedType, expressionType));
        return expressionType;
    }

    @Nullable
    public static JetType checkStatementType(@NotNull JetExpression expression, @NotNull ExpressionTypingContext context) {
        if (context.expectedType != TypeUtils.NO_EXPECTED_TYPE && !JetStandardClasses.isUnit(context.expectedType)) {
            context.trace.report(Errors.EXPECTED_TYPE_MISMATCH.on(expression, context.expectedType));
            return null;
        }
        return JetStandardClasses.getUnitType();
    }

    @Nullable
    public static JetType checkImplicitCast(@Nullable JetType expressionType, @NotNull JetExpression expression, @NotNull ExpressionTypingContext context, boolean isStatement) {
        if (expressionType != null && context.expectedType == TypeUtils.NO_EXPECTED_TYPE && !isStatement && (JetStandardClasses.isUnit(expressionType) || JetStandardClasses.isAny(expressionType))) {
            context.trace.report(Errors.IMPLICIT_CAST_TO_UNIT_OR_ANY.on(expression, expressionType));
        }
        return expressionType;
    }

    @Nullable
    public static JetType illegalStatementType(@NotNull JetExpression expression, @NotNull ExpressionTypingContext context, @NotNull ExpressionTypingInternals facade) {
        facade.checkStatementType(expression, context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        context.trace.report(Errors.EXPRESSION_EXPECTED.on(expression, expression));
        return null;
    }
}

