/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetBreakExpression;
import org.jetbrains.jet.lang.psi.JetCatchClause;
import org.jetbrains.jet.lang.psi.JetContinueExpression;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDoWhileExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFinallySection;
import org.jetbrains.jet.lang.psi.JetForExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetLoopExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetReturnExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetThrowExpression;
import org.jetbrains.jet.lang.psi.JetTreeVisitor;
import org.jetbrains.jet.lang.psi.JetTryExpression;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetWhileExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.TransientReceiver;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;

public class ControlStructureTypingVisitor
extends ExpressionTypingVisitor {
    protected ControlStructureTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    private void checkCondition(@NotNull JetScope scope, @Nullable JetExpression condition, ExpressionTypingContext context) {
        JetType conditionType;
        if (condition != null && (conditionType = this.facade.getType(condition, context.replaceScope(scope))) != null && !ExpressionTypingUtils.isBoolean(conditionType)) {
            context.trace.report(Errors.TYPE_MISMATCH_IN_CONDITION.on(condition, conditionType));
        }
    }

    @Override
    public JetType visitIfExpression(JetIfExpression expression, ExpressionTypingContext context) {
        return this.visitIfExpression(expression, context, false);
    }

    public JetType visitIfExpression(JetIfExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        boolean jumpInElse;
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = expression.getCondition();
        this.checkCondition(context.scope, condition, context);
        JetExpression elseBranch = expression.getElse();
        JetExpression thenBranch = expression.getThen();
        WritableScopeImpl thenScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Then scope");
        WritableScopeImpl elseScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Else scope");
        DataFlowInfo thenInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, thenScope, context);
        DataFlowInfo elseInfo = DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, null, context);
        if (elseBranch == null) {
            if (thenBranch != null) {
                JetType type = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(thenScope, Collections.singletonList(thenBranch), CoercionStrategy.NO_COERCION, context.replaceDataFlowInfo(thenInfo), context.trace);
                if (type != null && JetStandardClasses.isNothing(type)) {
                    this.facade.setResultingDataFlowInfo(elseInfo);
                }
                return DataFlowUtils.checkImplicitCast(DataFlowUtils.checkType(JetStandardClasses.getUnitType(), expression, contextWithExpectedType), expression, contextWithExpectedType, isStatement);
            }
            return null;
        }
        if (thenBranch == null) {
            JetType type = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(elseScope, Collections.singletonList(elseBranch), CoercionStrategy.NO_COERCION, context.replaceDataFlowInfo(elseInfo), context.trace);
            if (type != null && JetStandardClasses.isNothing(type)) {
                this.facade.setResultingDataFlowInfo(thenInfo);
            }
            return DataFlowUtils.checkImplicitCast(DataFlowUtils.checkType(JetStandardClasses.getUnitType(), expression, contextWithExpectedType), expression, contextWithExpectedType, isStatement);
        }
        CoercionStrategy coercionStrategy = isStatement ? CoercionStrategy.COERCION_TO_UNIT : CoercionStrategy.NO_COERCION;
        JetType thenType = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(thenScope, Collections.singletonList(thenBranch), coercionStrategy, contextWithExpectedType.replaceDataFlowInfo(thenInfo), context.trace);
        JetType elseType = context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(elseScope, Collections.singletonList(elseBranch), coercionStrategy, contextWithExpectedType.replaceDataFlowInfo(elseInfo), context.trace);
        JetType result = thenType == null ? elseType : (elseType == null ? thenType : CommonSupertypes.commonSupertype(Arrays.asList(thenType, elseType)));
        boolean jumpInThen = thenType != null && JetStandardClasses.isNothing(thenType);
        boolean bl = jumpInElse = elseType != null && JetStandardClasses.isNothing(elseType);
        if (jumpInThen && !jumpInElse) {
            this.facade.setResultingDataFlowInfo(elseInfo);
        } else if (jumpInElse && !jumpInThen) {
            this.facade.setResultingDataFlowInfo(thenInfo);
        }
        if (result == null) {
            return null;
        }
        return DataFlowUtils.checkImplicitCast(result, expression, contextWithExpectedType, isStatement);
    }

    @Override
    public JetType visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext context) {
        return this.visitWhileExpression(expression, context, false);
    }

    public JetType visitWhileExpression(JetWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression condition = expression.getCondition();
        this.checkCondition(context.scope, condition, context);
        JetExpression body = expression.getBody();
        if (body != null) {
            WritableScopeImpl scopeToExtend = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope extended in while's condition");
            DataFlowInfo conditionInfo = condition == null ? context.dataFlowInfo : DataFlowUtils.extractDataFlowInfoFromCondition(condition, true, scopeToExtend, context);
            context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(scopeToExtend, Collections.singletonList(body), CoercionStrategy.NO_COERCION, context.replaceDataFlowInfo(conditionInfo), context.trace);
        }
        if (!this.containsBreak(expression, context)) {
            this.facade.setResultingDataFlowInfo(DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, null, context));
        }
        return DataFlowUtils.checkType(JetStandardClasses.getUnitType(), expression, contextWithExpectedType);
    }

    private boolean containsBreak(final JetLoopExpression loopExpression, final ExpressionTypingContext context) {
        final boolean[] result = new boolean[]{false};
        loopExpression.accept(new JetTreeVisitor<JetLoopExpression>(){

            @Override
            public Void visitBreakExpression(JetBreakExpression breakExpression, JetLoopExpression outerLoop) {
                PsiElement element;
                JetSimpleNameExpression targetLabel = breakExpression.getTargetLabel();
                PsiElement psiElement = element = targetLabel != null ? context.trace.get(BindingContext.LABEL_TARGET, targetLabel) : null;
                if (element == loopExpression || targetLabel == null && outerLoop == loopExpression) {
                    result[0] = true;
                }
                return null;
            }

            @Override
            public Void visitLoopExpression(JetLoopExpression loopExpression2, JetLoopExpression outerLoop) {
                return (Void)super.visitLoopExpression(loopExpression2, loopExpression2);
            }
        }, loopExpression);
        return result[0];
    }

    @Override
    public JetType visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext context) {
        return this.visitDoWhileExpression(expression, context, false);
    }

    public JetType visitDoWhileExpression(JetDoWhileExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetExpression body = expression.getBody();
        JetScope conditionScope = context.scope;
        if (body instanceof JetFunctionLiteralExpression) {
            JetFunctionLiteralExpression function = (JetFunctionLiteralExpression)body;
            if (!function.getFunctionLiteral().hasParameterSpecification()) {
                WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
                conditionScope = writableScope;
                context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, function.getFunctionLiteral().getBodyExpression().getStatements(), CoercionStrategy.NO_COERCION, context, context.trace);
                context.trace.record(BindingContext.BLOCK, function);
            } else {
                this.facade.getType(body, context.replaceScope(context.scope));
            }
        } else if (body != null) {
            WritableScopeImpl writableScope = ExpressionTypingUtils.newWritableScopeImpl(context, "do..while body scope");
            conditionScope = writableScope;
            List<JetElement> block = body instanceof JetBlockExpression ? ((JetBlockExpression)body).getStatements() : Collections.singletonList(body);
            context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(writableScope, block, CoercionStrategy.NO_COERCION, context, context.trace);
        }
        JetExpression condition = expression.getCondition();
        this.checkCondition(conditionScope, condition, context);
        if (!this.containsBreak(expression, context)) {
            this.facade.setResultingDataFlowInfo(DataFlowUtils.extractDataFlowInfoFromCondition(condition, false, null, context));
        }
        return DataFlowUtils.checkType(JetStandardClasses.getUnitType(), expression, contextWithExpectedType);
    }

    @Override
    public JetType visitForExpression(JetForExpression expression, ExpressionTypingContext context) {
        return this.visitForExpression(expression, context, false);
    }

    public JetType visitForExpression(JetForExpression expression, ExpressionTypingContext contextWithExpectedType, boolean isStatement) {
        JetExpression body;
        ExpressionReceiver loopRangeReceiver;
        if (!isStatement) {
            return DataFlowUtils.illegalStatementType(expression, contextWithExpectedType, this.facade);
        }
        ExpressionTypingContext context = contextWithExpectedType.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE);
        JetParameter loopParameter = expression.getLoopParameter();
        JetExpression loopRange = expression.getLoopRange();
        JetType expectedParameterType = null;
        if (loopRange != null && (loopRangeReceiver = ExpressionTypingUtils.getExpressionReceiver(this.facade, loopRange, context.replaceScope(context.scope))) != null) {
            expectedParameterType = ControlStructureTypingVisitor.checkIterableConvention(loopRangeReceiver, context);
        }
        WritableScopeImpl loopScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Scope with for-loop index");
        if (loopParameter != null) {
            VariableDescriptor variableDescriptor;
            JetTypeReference typeReference = loopParameter.getTypeReference();
            if (typeReference != null) {
                variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope.getContainingDeclaration(), context.scope, loopParameter, context.trace);
                JetType actualParameterType = variableDescriptor.getType();
                if (expectedParameterType != null && actualParameterType != null && !JetTypeChecker.INSTANCE.isSubtypeOf(expectedParameterType, actualParameterType)) {
                    context.trace.report(Errors.TYPE_MISMATCH_IN_FOR_LOOP.on(typeReference, expectedParameterType, actualParameterType));
                }
            } else {
                if (expectedParameterType == null) {
                    expectedParameterType = ErrorUtils.createErrorType("Error");
                }
                variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope.getContainingDeclaration(), loopParameter, expectedParameterType, context.trace);
            }
            VariableDescriptor olderVariable = context.scope.getLocalVariable(variableDescriptor.getName());
            if (olderVariable != null && DescriptorUtils.isLocal(context.scope.getContainingDeclaration(), olderVariable)) {
                PsiElement declaration = BindingContextUtils.descriptorToDeclaration(context.trace.getBindingContext(), variableDescriptor);
                context.trace.report(Errors.NAME_SHADOWING.on(declaration, variableDescriptor.getName().getName()));
            }
            loopScope.addVariableDescriptor(variableDescriptor);
        }
        if ((body = expression.getBody()) != null) {
            context.expressionTypingServices.getBlockReturnedTypeWithWritableScope(loopScope, Collections.singletonList(body), CoercionStrategy.NO_COERCION, context, context.trace);
        }
        return DataFlowUtils.checkType(JetStandardClasses.getUnitType(), expression, contextWithExpectedType);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    static JetType checkIterableConvention(@NotNull ExpressionReceiver loopRange, ExpressionTypingContext context) {
        ExpressionReceiver nonNullReceiver;
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResultsWithNonNullReceiver;
        JetExpression loopRangeExpression = loopRange.getExpression();
        Name iterator = Name.identifier("iterator");
        OverloadResolutionResults<FunctionDescriptor> iteratorResolutionResults = ControlStructureTypingVisitor.resolveFakeCall(loopRange, context, iterator);
        if (!iteratorResolutionResults.isSuccess() && (iteratorResolutionResultsWithNonNullReceiver = ControlStructureTypingVisitor.resolveFakeCall(nonNullReceiver = new ExpressionReceiver(loopRange.getExpression(), TypeUtils.makeNotNullable(loopRange.getType())), context, iterator)).isSuccess()) {
            iteratorResolutionResults = iteratorResolutionResultsWithNonNullReceiver;
        }
        if (iteratorResolutionResults.isSuccess()) {
            boolean hasNextPropertySupported;
            FunctionDescriptor iteratorFunction = iteratorResolutionResults.getResultingCall().getResultingDescriptor();
            context.trace.record(BindingContext.LOOP_RANGE_ITERATOR, loopRangeExpression, iteratorFunction);
            JetType iteratorType = iteratorFunction.getReturnType();
            FunctionDescriptor hasNextFunction = ControlStructureTypingVisitor.checkHasNextFunctionSupport(loopRangeExpression, iteratorType, context);
            boolean hasNextFunctionSupported = hasNextFunction != null;
            VariableDescriptor hasNextProperty = ControlStructureTypingVisitor.checkHasNextPropertySupport(loopRangeExpression, iteratorType, context);
            boolean bl = hasNextPropertySupported = hasNextProperty != null;
            if (hasNextFunctionSupported && hasNextPropertySupported && !ErrorUtils.isErrorType(iteratorType)) {
                context.trace.report(Errors.HAS_NEXT_PROPERTY_AND_FUNCTION_AMBIGUITY.on(loopRangeExpression));
            } else if (!hasNextFunctionSupported && !hasNextPropertySupported) {
                context.trace.report(Errors.HAS_NEXT_MISSING.on(loopRangeExpression));
            } else {
                context.trace.record(BindingContext.LOOP_RANGE_HAS_NEXT, loopRange.getExpression(), hasNextFunctionSupported ? hasNextFunction : hasNextProperty);
            }
            OverloadResolutionResults<FunctionDescriptor> nextResolutionResults = context.resolveExactSignature(new TransientReceiver(iteratorType), Name.identifier("next"), Collections.<JetType>emptyList());
            if (nextResolutionResults.isAmbiguity()) {
                context.trace.report(Errors.NEXT_AMBIGUITY.on(loopRangeExpression));
                return null;
            }
            if (nextResolutionResults.isNothing()) {
                context.trace.report(Errors.NEXT_MISSING.on(loopRangeExpression));
                return null;
            }
            FunctionDescriptor nextFunction = nextResolutionResults.getResultingCall().getResultingDescriptor();
            context.trace.record(BindingContext.LOOP_RANGE_NEXT, loopRange.getExpression(), nextFunction);
            return nextFunction.getReturnType();
        }
        if (iteratorResolutionResults.isAmbiguity()) {
            context.trace.report(Errors.ITERATOR_AMBIGUITY.on(loopRangeExpression, iteratorResolutionResults.getResultingCalls()));
            return null;
        }
        context.trace.report(Errors.ITERATOR_MISSING.on(loopRangeExpression));
        return null;
    }

    public static OverloadResolutionResults<FunctionDescriptor> resolveFakeCall(ExpressionReceiver receiver, ExpressionTypingContext context, Name name) {
        JetSimpleNameExpression fake = JetPsiFactory.createSimpleName(context.expressionTypingServices.getProject(), "fake");
        BindingTraceContext fakeTrace = new BindingTraceContext();
        Call call = CallMaker.makeCall(fake, receiver, null, fake, Collections.emptyList());
        return context.replaceBindingTrace(fakeTrace).resolveCallWithGivenName(call, fake, name);
    }

    @Nullable
    private static FunctionDescriptor checkHasNextFunctionSupport(@NotNull JetExpression loopRange, @NotNull JetType iteratorType, ExpressionTypingContext context) {
        OverloadResolutionResults<FunctionDescriptor> hasNextResolutionResults = context.resolveExactSignature(new TransientReceiver(iteratorType), Name.identifier("hasNext"), Collections.<JetType>emptyList());
        if (hasNextResolutionResults.isAmbiguity()) {
            context.trace.report(Errors.HAS_NEXT_FUNCTION_AMBIGUITY.on(loopRange));
        } else {
            if (hasNextResolutionResults.isNothing()) {
                return null;
            }
            assert (hasNextResolutionResults.isSuccess());
            JetType hasNextReturnType = hasNextResolutionResults.getResultingDescriptor().getReturnType();
            if (!ExpressionTypingUtils.isBoolean(hasNextReturnType)) {
                context.trace.report(Errors.HAS_NEXT_FUNCTION_TYPE_MISMATCH.on(loopRange, hasNextReturnType));
            }
        }
        return hasNextResolutionResults.getResultingCall().getResultingDescriptor();
    }

    @Nullable
    private static VariableDescriptor checkHasNextPropertySupport(@NotNull JetExpression loopRange, @NotNull JetType iteratorType, ExpressionTypingContext context) {
        VariableDescriptor hasNextProperty = DescriptorUtils.filterNonExtensionProperty(iteratorType.getMemberScope().getProperties(Name.identifier("hasNext")));
        if (hasNextProperty == null) {
            return null;
        }
        JetType hasNextReturnType = hasNextProperty.getType();
        if (hasNextReturnType == null) {
            context.trace.report(Errors.HAS_NEXT_MUST_BE_READABLE.on(loopRange));
        } else if (!ExpressionTypingUtils.isBoolean(hasNextReturnType)) {
            context.trace.report(Errors.HAS_NEXT_PROPERTY_TYPE_MISMATCH.on(loopRange, hasNextReturnType));
        }
        return hasNextProperty;
    }

    @Override
    public JetType visitTryExpression(JetTryExpression expression, ExpressionTypingContext context) {
        JetType type;
        JetBlockExpression tryBlock = expression.getTryBlock();
        List<JetCatchClause> catchClauses = expression.getCatchClauses();
        JetFinallySection finallyBlock = expression.getFinallyBlock();
        ArrayList<JetType> types = new ArrayList<JetType>();
        for (JetCatchClause catchClause : catchClauses) {
            JetParameter catchParameter = catchClause.getCatchParameter();
            JetExpression catchBody = catchClause.getCatchBody();
            if (catchParameter == null) continue;
            VariableDescriptor variableDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveLocalVariableDescriptor(context.scope.getContainingDeclaration(), context.scope, catchParameter, context.trace);
            JetType throwableType = JetStandardLibrary.getInstance().getThrowable().getDefaultType();
            DataFlowUtils.checkType(variableDescriptor.getType(), catchParameter, context.replaceExpectedType(throwableType));
            if (catchBody == null) continue;
            WritableScopeImpl catchScope = ExpressionTypingUtils.newWritableScopeImpl(context, "Catch scope");
            catchScope.addVariableDescriptor(variableDescriptor);
            JetType type2 = this.facade.getType(catchBody, context.replaceScope(catchScope));
            if (type2 == null) continue;
            types.add(type2);
        }
        if (finallyBlock != null) {
            this.facade.getType(finallyBlock.getFinalExpression(), context.replaceExpectedType(TypeUtils.NO_EXPECTED_TYPE));
        }
        if ((type = this.facade.getType(tryBlock, context)) != null) {
            types.add(type);
        }
        if (types.isEmpty()) {
            return null;
        }
        return CommonSupertypes.commonSupertype(types);
    }

    @Override
    public JetType visitThrowExpression(JetThrowExpression expression, ExpressionTypingContext context) {
        JetExpression thrownExpression = expression.getThrownExpression();
        if (thrownExpression != null) {
            JetType throwableType = JetStandardLibrary.getInstance().getThrowable().getDefaultType();
            this.facade.getType(thrownExpression, context.replaceExpectedType(throwableType).replaceScope(context.scope));
        }
        return DataFlowUtils.checkType(JetStandardClasses.getNothingType(), expression, context);
    }

    @Override
    public JetType visitReturnExpression(JetReturnExpression expression, ExpressionTypingContext context) {
        JetElement element = context.labelResolver.resolveLabel(expression, context);
        JetExpression returnedExpression = expression.getReturnedExpression();
        JetType expectedType = TypeUtils.NO_EXPECTED_TYPE;
        JetExpression parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)expression, JetDeclaration.class);
        if (parentDeclaration instanceof JetFunctionLiteral) {
            parentDeclaration = (JetFunctionLiteralExpression)parentDeclaration.getParent();
        }
        if (parentDeclaration instanceof JetParameter) {
            context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
        }
        assert (parentDeclaration != null);
        DeclarationDescriptor declarationDescriptor = context.trace.get(BindingContext.DECLARATION_TO_DESCRIPTOR, parentDeclaration);
        FunctionDescriptor containingFunctionDescriptor = DescriptorUtils.getParentOfType(declarationDescriptor, FunctionDescriptor.class, false);
        if (expression.getTargetLabel() == null) {
            if (containingFunctionDescriptor != null) {
                PsiElement containingFunction = BindingContextUtils.callableDescriptorToDeclaration(context.trace.getBindingContext(), containingFunctionDescriptor);
                assert (containingFunction != null);
                if (containingFunction instanceof JetFunctionLiteralExpression) {
                    while ((containingFunction = (containingFunctionDescriptor = DescriptorUtils.getParentOfType(containingFunctionDescriptor, FunctionDescriptor.class)) != null ? BindingContextUtils.callableDescriptorToDeclaration(context.trace.getBindingContext(), containingFunctionDescriptor) : null) instanceof JetFunctionLiteralExpression) {
                    }
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                }
                if (containingFunctionDescriptor != null) {
                    expectedType = DescriptorUtils.getFunctionExpectedReturnType(containingFunctionDescriptor, (JetElement)containingFunction);
                }
            } else {
                context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
            }
        } else if (element != null) {
            SimpleFunctionDescriptor functionDescriptor = context.trace.get(BindingContext.FUNCTION, element);
            if (functionDescriptor != null) {
                expectedType = DescriptorUtils.getFunctionExpectedReturnType(functionDescriptor, element);
                if (functionDescriptor != containingFunctionDescriptor) {
                    context.trace.report(Errors.RETURN_NOT_ALLOWED.on(expression));
                }
            } else {
                context.trace.report(Errors.NOT_A_RETURN_LABEL.on(expression, expression.getLabelName()));
            }
        }
        if (returnedExpression != null) {
            this.facade.getType(returnedExpression, context.replaceExpectedType(expectedType).replaceScope(context.scope));
        } else if (expectedType != TypeUtils.NO_EXPECTED_TYPE && expectedType != null && !JetStandardClasses.isUnit(expectedType)) {
            context.trace.report(Errors.RETURN_TYPE_MISMATCH.on(expression, expectedType));
        }
        return DataFlowUtils.checkType(JetStandardClasses.getNothingType(), expression, context);
    }

    @Override
    public JetType visitBreakExpression(JetBreakExpression expression, ExpressionTypingContext context) {
        context.labelResolver.resolveLabel(expression, context);
        return DataFlowUtils.checkType(JetStandardClasses.getNothingType(), expression, context);
    }

    @Override
    public JetType visitContinueExpression(JetContinueExpression expression, ExpressionTypingContext context) {
        context.labelResolver.resolveLabel(expression, context);
        return DataFlowUtils.checkType(JetStandardClasses.getNothingType(), expression, context);
    }
}

