/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.expressions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetObjectLiteralExpression;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.DelegatingBindingTrace;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalyzer;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.CoercionStrategy;
import org.jetbrains.jet.lang.types.expressions.DataFlowUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingContext;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingInternals;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingVisitor;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.util.lazy.LazyValue;
import org.jetbrains.jet.util.lazy.LazyValueWithDefault;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ClosureExpressionsTypingVisitor
extends ExpressionTypingVisitor {
    protected ClosureExpressionsTypingVisitor(@NotNull ExpressionTypingInternals facade) {
        super(facade);
    }

    @Override
    public JetType visitObjectLiteralExpression(final JetObjectLiteralExpression expression, final ExpressionTypingContext context) {
        DelegatingBindingTrace delegatingBindingTrace = context.trace.get(BindingContext.TRACE_DELTAS_CACHE, expression.getObjectDeclaration());
        if (delegatingBindingTrace != null) {
            delegatingBindingTrace.addAllMyDataTo(context.trace);
            JetType type = context.trace.get(BindingContext.EXPRESSION_TYPE, expression);
            return DataFlowUtils.checkType(type, expression, context);
        }
        final JetType[] result = new JetType[1];
        final TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace);
        ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor> handler = new ObservableBindingTrace.RecordHandler<PsiElement, ClassDescriptor>(){

            @Override
            public void handleRecord(WritableSlice<PsiElement, ClassDescriptor> slice, PsiElement declaration, final ClassDescriptor descriptor) {
                if (slice == BindingContext.CLASS && declaration == expression.getObjectDeclaration()) {
                    DeferredType defaultType = DeferredType.create(context.trace, (LazyValue<JetType>)new LazyValueWithDefault<JetType>(ErrorUtils.createErrorType("Recursive dependency")){

                        @Override
                        protected JetType compute() {
                            return descriptor.getDefaultType();
                        }
                    });
                    result[0] = defaultType;
                    if (!context.trace.get(BindingContext.PROCESSED, expression).booleanValue()) {
                        temporaryTrace.record(BindingContext.EXPRESSION_TYPE, expression, defaultType);
                        temporaryTrace.record(BindingContext.PROCESSED, expression);
                    }
                }
            }
        };
        ObservableBindingTrace traceAdapter = new ObservableBindingTrace(temporaryTrace);
        traceAdapter.addHandler(BindingContext.CLASS, handler);
        TopDownAnalyzer.processObject(context.expressionTypingServices.getProject(), traceAdapter, context.scope, context.scope.getContainingDeclaration(), expression.getObjectDeclaration());
        DelegatingBindingTrace cloneDelta = new DelegatingBindingTrace(new BindingTraceContext().getBindingContext());
        temporaryTrace.addAllMyDataTo(cloneDelta);
        context.trace.record(BindingContext.TRACE_DELTAS_CACHE, expression.getObjectDeclaration(), cloneDelta);
        temporaryTrace.commit();
        return DataFlowUtils.checkType(result[0], expression, context);
    }

    @Override
    public JetType visitFunctionLiteralExpression(JetFunctionLiteralExpression expression, ExpressionTypingContext context) {
        JetType expectedReturnType;
        boolean hasDeclaredValueParameters;
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetBlockExpression bodyExpression = functionLiteral.getBodyExpression();
        if (bodyExpression == null) {
            return null;
        }
        JetType expectedType = context.expectedType;
        boolean functionTypeExpected = expectedType != TypeUtils.NO_EXPECTED_TYPE && JetStandardClasses.isFunctionType(expectedType);
        SimpleFunctionDescriptorImpl functionDescriptor = this.createFunctionDescriptor(expression, context, functionTypeExpected);
        ArrayList<JetType> parameterTypes = Lists.newArrayList();
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            parameterTypes.add(valueParameter.getType());
        }
        ReceiverDescriptor receiverParameter = functionDescriptor.getReceiverParameter();
        JetType receiver = receiverParameter != ReceiverDescriptor.NO_RECEIVER ? receiverParameter.getType() : null;
        JetType returnType = TypeUtils.NO_EXPECTED_TYPE;
        JetScope functionInnerScope = FunctionDescriptorUtil.getFunctionInnerScope(context.scope, functionDescriptor, context.trace);
        JetTypeReference returnTypeRef = functionLiteral.getReturnTypeRef();
        TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(context.trace);
        if (returnTypeRef != null) {
            returnType = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, returnTypeRef, context.trace, true);
            context.expressionTypingServices.checkFunctionReturnType(expression, context.replaceScope(functionInnerScope).replaceExpectedType(returnType).replaceBindingTrace(temporaryTrace), temporaryTrace);
        } else {
            if (functionTypeExpected) {
                returnType = JetStandardClasses.getReturnTypeFromFunctionType(expectedType);
            }
            returnType = context.expressionTypingServices.getBlockReturnedType(functionInnerScope, bodyExpression, CoercionStrategy.COERCION_TO_UNIT, context.replaceExpectedType(returnType).replaceBindingTrace(temporaryTrace), temporaryTrace);
        }
        temporaryTrace.commit(new Predicate<WritableSlice>(){

            @Override
            public boolean apply(@Nullable WritableSlice slice) {
                return slice != BindingContext.RESOLUTION_RESULTS_FOR_FUNCTION && slice != BindingContext.RESOLUTION_RESULTS_FOR_PROPERTY && slice != BindingContext.TRACE_DELTAS_CACHE;
            }
        }, true);
        JetType safeReturnType = returnType == null ? ErrorUtils.createErrorType("<return type>") : returnType;
        functionDescriptor.setReturnType(safeReturnType);
        boolean bl = hasDeclaredValueParameters = functionLiteral.getValueParameterList() != null;
        if (!hasDeclaredValueParameters && functionTypeExpected && JetStandardClasses.isUnit(expectedReturnType = JetStandardClasses.getReturnTypeFromFunctionType(expectedType))) {
            functionDescriptor.setReturnType(JetStandardClasses.getUnitType());
            return DataFlowUtils.checkType(JetStandardClasses.getFunctionType(Collections.<AnnotationDescriptor>emptyList(), receiver, parameterTypes, JetStandardClasses.getUnitType()), expression, context);
        }
        return DataFlowUtils.checkType(JetStandardClasses.getFunctionType(Collections.<AnnotationDescriptor>emptyList(), receiver, parameterTypes, safeReturnType), expression, context);
    }

    private SimpleFunctionDescriptorImpl createFunctionDescriptor(JetFunctionLiteralExpression expression, ExpressionTypingContext context, boolean functionTypeExpected) {
        JetFunctionLiteral functionLiteral = expression.getFunctionLiteral();
        JetTypeReference receiverTypeRef = functionLiteral.getReceiverTypeRef();
        SimpleFunctionDescriptorImpl functionDescriptor = new SimpleFunctionDescriptorImpl(context.scope.getContainingDeclaration(), Collections.<AnnotationDescriptor>emptyList(), Name.special("<anonymous>"), CallableMemberDescriptor.Kind.DECLARATION);
        List<ValueParameterDescriptor> valueParameterDescriptors = this.createValueParameterDescriptors(context, functionLiteral, functionDescriptor, functionTypeExpected);
        JetType effectiveReceiverType = receiverTypeRef == null ? (functionTypeExpected ? JetStandardClasses.getReceiverType(context.expectedType) : null) : context.expressionTypingServices.getTypeResolver().resolveType(context.scope, receiverTypeRef, context.trace, true);
        functionDescriptor.initialize(effectiveReceiverType, ReceiverDescriptor.NO_RECEIVER, Collections.emptyList(), valueParameterDescriptors, null, Modality.FINAL, Visibilities.LOCAL, false);
        context.trace.record(BindingContext.FUNCTION, expression, functionDescriptor);
        BindingContextUtils.recordFunctionDeclarationToDescriptor(context.trace, expression, functionDescriptor);
        return functionDescriptor;
    }

    private List<ValueParameterDescriptor> createValueParameterDescriptors(ExpressionTypingContext context, JetFunctionLiteral functionLiteral, FunctionDescriptorImpl functionDescriptor, boolean functionTypeExpected) {
        boolean hasDeclaredValueParameters;
        ArrayList<ValueParameterDescriptor> valueParameterDescriptors = Lists.newArrayList();
        List<JetParameter> declaredValueParameters = functionLiteral.getValueParameters();
        List<ValueParameterDescriptor> expectedValueParameters = functionTypeExpected ? JetStandardClasses.getValueParameters(functionDescriptor, context.expectedType) : null;
        boolean bl = hasDeclaredValueParameters = functionLiteral.getValueParameterList() != null;
        if (functionTypeExpected && !hasDeclaredValueParameters && expectedValueParameters.size() == 1) {
            ValueParameterDescriptor valueParameterDescriptor = expectedValueParameters.get(0);
            ValueParameterDescriptorImpl it = new ValueParameterDescriptorImpl(functionDescriptor, 0, Collections.<AnnotationDescriptor>emptyList(), Name.identifier("it"), false, valueParameterDescriptor.getType(), valueParameterDescriptor.hasDefaultValue(), valueParameterDescriptor.getVarargElementType());
            valueParameterDescriptors.add(it);
            context.trace.record(BindingContext.AUTO_CREATED_IT, it);
        } else {
            for (int i = 0; i < declaredValueParameters.size(); ++i) {
                JetType type;
                JetParameter declaredParameter = declaredValueParameters.get(i);
                JetTypeReference typeReference = declaredParameter.getTypeReference();
                if (typeReference != null) {
                    type = context.expressionTypingServices.getTypeResolver().resolveType(context.scope, typeReference, context.trace, true);
                } else if (expectedValueParameters != null && i < expectedValueParameters.size()) {
                    type = expectedValueParameters.get(i).getType();
                } else {
                    context.trace.report(Errors.CANNOT_INFER_PARAMETER_TYPE.on(declaredParameter));
                    type = ErrorUtils.createErrorType("Cannot be inferred");
                }
                MutableValueParameterDescriptor valueParameterDescriptor = context.expressionTypingServices.getDescriptorResolver().resolveValueParameterDescriptor(context.scope, functionDescriptor, declaredParameter, i, type, context.trace);
                valueParameterDescriptors.add(valueParameterDescriptor);
            }
        }
        return valueParameterDescriptors;
    }
}

