/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types.checker;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.BiMap;
import org.jetbrains.jet.internal.com.google.common.collect.HashBiMap;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;

public class JetTypeChecker {
    public static final JetTypeChecker INSTANCE = new JetTypeChecker();
    public static final HashBiMap<TypeConstructor, TypeConstructor> EMPTY_AXIOMS = HashBiMap.create();
    private static final TypeCheckingProcedure TYPE_CHECKER = new TypeCheckingProcedure(new TypeCheckerTypingConstraints());

    private JetTypeChecker() {
    }

    public boolean isSubtypeOf(@NotNull JetType subtype, @NotNull JetType supertype) {
        return TYPE_CHECKER.isSubtypeOf(subtype, supertype);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b) {
        return TYPE_CHECKER.equalTypes(a, b);
    }

    public boolean equalTypes(@NotNull JetType a, @NotNull JetType b, final @NotNull BiMap<TypeConstructor, TypeConstructor> equalityAxioms) {
        return new TypeCheckingProcedure(new TypeCheckerTypingConstraints(){

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor constructor1, @NotNull TypeConstructor constructor2) {
                if (!constructor1.equals(constructor2)) {
                    TypeConstructor img1 = (TypeConstructor)equalityAxioms.get(constructor1);
                    TypeConstructor img2 = (TypeConstructor)equalityAxioms.get(constructor2);
                    if (!(img1 != null && img1.equals(constructor2) || img2 != null && img2.equals(constructor1))) {
                        return false;
                    }
                }
                return true;
            }
        }).equalTypes(a, b);
    }

    private static class TypeCheckerTypingConstraints
    implements TypingConstraints {
        private TypeCheckerTypingConstraints() {
        }

        @Override
        public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            return typeCheckingProcedure.equalTypes(a, b);
        }

        @Override
        public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
            return a.equals(b);
        }

        @Override
        public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            return typeCheckingProcedure.isSubtypeOf(subtype, supertype);
        }

        @Override
        public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
            return false;
        }
    }
}

