/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.types;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibilities;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeConstructorImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.error.ErrorSimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;

public class ErrorUtils {
    private static final ModuleDescriptor ERROR_MODULE = new ModuleDescriptor(Name.special("<ERROR MODULE>"));
    private static final ClassDescriptorImpl ERROR_CLASS = new ClassDescriptorImpl((DeclarationDescriptor)ERROR_MODULE, Collections.emptyList(), Name.special("<ERROR CLASS>")){

        @Override
        @NotNull
        public Set<ConstructorDescriptor> getConstructors() {
            return ERROR_CONSTRUCTOR_GROUP;
        }

        @Override
        @NotNull
        public Modality getModality() {
            return Modality.OPEN;
        }

        @Override
        @NotNull
        public ClassDescriptor substitute(TypeSubstitutor substitutor) {
            return ERROR_CLASS;
        }
    };
    private static final Set<ConstructorDescriptor> ERROR_CONSTRUCTOR_GROUP = Collections.singleton(ErrorUtils.createErrorConstructor(0, Collections.<JetType>emptyList()));
    private static final ConstructorDescriptor ERROR_CONSTRUCTOR = new ConstructorDescriptorImpl(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), true);
    private static final JetType ERROR_PROPERTY_TYPE;
    private static final VariableDescriptor ERROR_PROPERTY;
    private static final Set<VariableDescriptor> ERROR_PROPERTY_GROUP;
    private static final JetType ERROR_PARAMETER_TYPE;

    public static JetScope createErrorScope(String debugMessage) {
        return new ErrorScope(debugMessage);
    }

    private static SimpleFunctionDescriptor createErrorFunction(ErrorScope ownerScope) {
        ErrorSimpleFunctionDescriptorImpl function = new ErrorSimpleFunctionDescriptorImpl(ownerScope);
        function.initialize(null, ReceiverDescriptor.NO_RECEIVER, Collections.emptyList(), Collections.<ValueParameterDescriptor>emptyList(), ErrorUtils.createErrorType("<ERROR FUNCTION RETURN TYPE>"), Modality.OPEN, Visibilities.INTERNAL, false);
        return function;
    }

    public static ConstructorDescriptor createErrorConstructor(int typeParameterCount, List<JetType> positionedValueParameterTypes) {
        ConstructorDescriptorImpl r = new ConstructorDescriptorImpl(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), false);
        r.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibilities.INTERNAL);
        r.setReturnType(ErrorUtils.createErrorType("<ERROR RETURN TYPE>"));
        return r;
    }

    @NotNull
    public static JetType createErrorType(String debugMessage) {
        return ErrorUtils.createErrorType(debugMessage, ErrorUtils.createErrorScope(debugMessage));
    }

    private static JetType createErrorType(String debugMessage, JetScope memberScope) {
        return ErrorUtils.createErrorTypeWithCustomDebugName(memberScope, "[ERROR : " + debugMessage + "]");
    }

    @NotNull
    public static JetType createErrorTypeWithCustomDebugName(String debugName) {
        return ErrorUtils.createErrorTypeWithCustomDebugName(ErrorUtils.createErrorScope(debugName), debugName);
    }

    private static JetType createErrorTypeWithCustomDebugName(JetScope memberScope, String debugName) {
        return new ErrorTypeImpl(new TypeConstructorImpl(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), false, debugName, Collections.emptyList(), Collections.singleton(JetStandardClasses.getAnyType())), memberScope);
    }

    public static JetType createWrongVarianceErrorType(TypeProjection value) {
        return ErrorUtils.createErrorType(value + " is not allowed here", value.getType().getMemberScope());
    }

    public static ClassifierDescriptor getErrorClass() {
        return ERROR_CLASS;
    }

    public static boolean isError(@NotNull TypeConstructor typeConstructor) {
        return typeConstructor == ERROR_CLASS.getTypeConstructor();
    }

    public static boolean isErrorType(@NotNull JetType type) {
        return type != TypeUtils.NO_EXPECTED_TYPE && !(type instanceof NamespaceType) && (type instanceof DeferredType && (((DeferredType)type).getActualType() == null || ErrorUtils.isErrorType(((DeferredType)type).getActualType())) || type instanceof ErrorTypeImpl || ErrorUtils.isError(type.getConstructor()));
    }

    public static boolean containsErrorType(@Nullable JetType type) {
        if (type == null) {
            return false;
        }
        if (type instanceof NamespaceType) {
            return false;
        }
        if (ErrorUtils.isErrorType(type)) {
            return true;
        }
        for (TypeProjection projection : type.getArguments()) {
            if (!ErrorUtils.containsErrorType(projection.getType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isError(@NotNull DeclarationDescriptor candidate) {
        return candidate == ErrorUtils.getErrorClass() || candidate.getContainingDeclaration() == ErrorUtils.getErrorClass() || candidate == ERROR_MODULE;
    }

    private ErrorUtils() {
    }

    static {
        ERROR_CLASS.initialize(true, Collections.emptyList(), Collections.<JetType>emptyList(), ErrorUtils.createErrorScope("ERROR_CLASS"), ERROR_CONSTRUCTOR_GROUP, ERROR_CONSTRUCTOR);
        ERROR_PROPERTY_TYPE = ErrorUtils.createErrorType("<ERROR PROPERTY TYPE>");
        ERROR_PROPERTY = new PropertyDescriptor(ERROR_CLASS, Collections.<AnnotationDescriptor>emptyList(), Modality.OPEN, Visibilities.INTERNAL, true, false, null, ReceiverDescriptor.NO_RECEIVER, Name.special("<ERROR PROPERTY>"), ERROR_PROPERTY_TYPE, CallableMemberDescriptor.Kind.DECLARATION);
        ERROR_PROPERTY_GROUP = Collections.singleton(ERROR_PROPERTY);
        ERROR_PARAMETER_TYPE = ErrorUtils.createErrorType("<ERROR VALUE_PARAMETER TYPE>");
    }

    private static class ErrorTypeImpl
    implements JetType {
        private final TypeConstructor constructor;
        private final JetScope memberScope;

        private ErrorTypeImpl(TypeConstructor constructor, JetScope memberScope) {
            this.constructor = constructor;
            this.memberScope = memberScope;
        }

        @Override
        @NotNull
        public TypeConstructor getConstructor() {
            return this.constructor;
        }

        @Override
        @NotNull
        public List<TypeProjection> getArguments() {
            return Collections.emptyList();
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        @NotNull
        public JetScope getMemberScope() {
            return this.memberScope;
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return this.constructor.toString();
        }
    }

    public static class ErrorScope
    implements JetScope {
        private final String debugMessage;

        private ErrorScope(String debugMessage) {
            this.debugMessage = debugMessage;
        }

        @Override
        public ClassifierDescriptor getClassifier(@NotNull Name name) {
            return ERROR_CLASS;
        }

        @Override
        public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
            return ERROR_CLASS;
        }

        @Override
        @NotNull
        public Set<ClassDescriptor> getObjectDescriptors() {
            return Collections.emptySet();
        }

        @Override
        @NotNull
        public Set<VariableDescriptor> getProperties(@NotNull Name name) {
            return ERROR_PROPERTY_GROUP;
        }

        @Override
        public VariableDescriptor getLocalVariable(@NotNull Name name) {
            return ERROR_PROPERTY;
        }

        @Override
        public NamespaceDescriptor getNamespace(@NotNull Name name) {
            return null;
        }

        @Override
        @NotNull
        public ReceiverDescriptor getImplicitReceiver() {
            return ReceiverDescriptor.NO_RECEIVER;
        }

        @Override
        public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        }

        @Override
        @NotNull
        public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
            return Collections.singleton(ErrorUtils.createErrorFunction(this));
        }

        @Override
        @NotNull
        public DeclarationDescriptor getContainingDeclaration() {
            return ERROR_MODULE;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
            return Collections.emptyList();
        }

        @Override
        public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
            return null;
        }

        @Override
        @NotNull
        public Collection<DeclarationDescriptor> getAllDescriptors() {
            return Collections.emptyList();
        }
    }
}

