/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeAdapter;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public abstract class WritableScopeWithImports
extends JetScopeAdapter
implements WritableScope {
    @NotNull
    private final String debugName;
    @Nullable
    private List<JetScope> imports;
    private WritableScope currentIndividualImportScope;
    protected final RedeclarationHandler redeclarationHandler;
    private WritableScope.LockLevel lockLevel = WritableScope.LockLevel.WRITING;

    public WritableScopeWithImports(@NotNull JetScope scope, @NotNull RedeclarationHandler redeclarationHandler, @NotNull String debugName) {
        super(scope);
        this.redeclarationHandler = redeclarationHandler;
        this.debugName = debugName;
    }

    @Override
    public WritableScope changeLockLevel(WritableScope.LockLevel lockLevel) {
        if (lockLevel.ordinal() < this.lockLevel.ordinal()) {
            throw new IllegalStateException("cannot lower lock level from " + (Object)((Object)this.lockLevel) + " to " + (Object)((Object)lockLevel) + " at " + this.toString());
        }
        this.lockLevel = lockLevel;
        return this;
    }

    protected void checkMayRead() {
        if (this.lockLevel != WritableScope.LockLevel.READING && this.lockLevel != WritableScope.LockLevel.BOTH) {
            throw new IllegalStateException("cannot read with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    protected void checkMayWrite() {
        if (this.lockLevel != WritableScope.LockLevel.WRITING && this.lockLevel != WritableScope.LockLevel.BOTH) {
            throw new IllegalStateException("cannot write with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    protected void checkMayNotWrite() {
        if (this.lockLevel == WritableScope.LockLevel.WRITING || this.lockLevel == WritableScope.LockLevel.BOTH) {
            throw new IllegalStateException("cannot write with lock level " + (Object)((Object)this.lockLevel) + " at " + this.toString());
        }
    }

    @NotNull
    protected final List<JetScope> getImports() {
        if (this.imports == null) {
            this.imports = new ArrayList<JetScope>();
        }
        return this.imports;
    }

    @Override
    public void importScope(@NotNull JetScope imported) {
        if (imported == this) {
            throw new IllegalStateException("cannot import scope into self");
        }
        this.checkMayWrite();
        this.getImports().add(0, imported);
        this.currentIndividualImportScope = null;
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        this.checkMayRead();
        super.getImplicitReceiversHierarchy(result);
        for (JetScope scope : this.getImports()) {
            ReceiverDescriptor definedReceiver = scope.getImplicitReceiver();
            if (!definedReceiver.exists()) continue;
            result.add(0, definedReceiver);
        }
    }

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        this.checkMayRead();
        LinkedHashSet<VariableDescriptor> properties = Sets.newLinkedHashSet();
        for (JetScope imported : this.getImports()) {
            properties.addAll(imported.getProperties(name));
        }
        return properties;
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            VariableDescriptor importedDescriptor = imported.getLocalVariable(name);
            if (importedDescriptor == null) continue;
            return importedDescriptor;
        }
        return null;
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        this.checkMayRead();
        if (this.getImports().isEmpty()) {
            return Collections.emptySet();
        }
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet();
        for (JetScope imported : this.getImports()) {
            result.addAll(imported.getFunctions(name));
        }
        return result;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            ClassifierDescriptor importedClassifier = imported.getClassifier(name);
            if (importedClassifier == null) continue;
            return importedClassifier;
        }
        return null;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            ClassDescriptor objectDescriptor = imported.getObjectDescriptor(name);
            if (objectDescriptor == null) continue;
            return objectDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        this.checkMayRead();
        for (JetScope imported : this.getImports()) {
            NamespaceDescriptor importedDescriptor = imported.getNamespace(name);
            if (importedDescriptor == null) continue;
            return importedDescriptor;
        }
        return null;
    }

    private WritableScope getCurrentIndividualImportScope() {
        if (this.currentIndividualImportScope == null) {
            WritableScopeImpl writableScope = new WritableScopeImpl(EMPTY, this.getContainingDeclaration(), RedeclarationHandler.DO_NOTHING, "Individual import scope");
            writableScope.changeLockLevel(WritableScope.LockLevel.BOTH);
            this.importScope(writableScope);
            this.currentIndividualImportScope = writableScope;
        }
        return this.currentIndividualImportScope;
    }

    @Override
    public void importClassifierAlias(@NotNull Name importedClassifierName, @NotNull ClassifierDescriptor classifierDescriptor) {
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addClassifierAlias(importedClassifierName, classifierDescriptor);
    }

    @Override
    public void importNamespaceAlias(@NotNull Name aliasName, @NotNull NamespaceDescriptor namespaceDescriptor) {
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addNamespaceAlias(aliasName, namespaceDescriptor);
    }

    @Override
    public void importFunctionAlias(@NotNull Name aliasName, @NotNull FunctionDescriptor functionDescriptor) {
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addFunctionAlias(aliasName, functionDescriptor);
    }

    @Override
    public void importVariableAlias(@NotNull Name aliasName, @NotNull VariableDescriptor variableDescriptor) {
        this.checkMayWrite();
        this.getCurrentIndividualImportScope().addVariableAlias(aliasName, variableDescriptor);
    }

    @Override
    public void clearImports() {
        this.currentIndividualImportScope = null;
        this.getImports().clear();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(System.identityHashCode(this)) + " " + this.debugName + " for " + this.getContainingDeclaration();
    }
}

