/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.scopes;

import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class InnerClassesScopeWrapper
extends JetScopeImpl {
    private final JetScope actualScope;

    public InnerClassesScopeWrapper(JetScope actualScope) {
        this.actualScope = actualScope;
    }

    private boolean isClass(DeclarationDescriptor descriptor) {
        return descriptor instanceof ClassDescriptor && ((ClassDescriptor)descriptor).getKind() != ClassKind.OBJECT;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassifierDescriptor classifier = this.actualScope.getClassifier(name);
        if (this.isClass(classifier)) {
            return classifier;
        }
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.actualScope.getContainingDeclaration();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(LabelName labelName) {
        Collection<DeclarationDescriptor> declarationsByLabel = this.actualScope.getDeclarationsByLabel(labelName);
        return Collections2.filter(declarationsByLabel, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                return InnerClassesScopeWrapper.this.isClass(descriptor);
            }
        });
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        Collection<DeclarationDescriptor> allDescriptors = this.actualScope.getAllDescriptors();
        return Collections2.filter(allDescriptors, new Predicate<DeclarationDescriptor>(){

            @Override
            public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                return InnerClassesScopeWrapper.this.isClass(descriptor);
            }
        });
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        return this.actualScope.getImplicitReceiver();
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        this.actualScope.getImplicitReceiversHierarchy(result);
    }
}

