/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.name.NameUtils;

public class Name
implements Comparable<Name> {
    @NotNull
    private final String name;
    private final boolean special;

    private Name(String name, boolean special) {
        this.name = name;
        this.special = special;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    @NotNull
    public String getIdentifier() {
        if (this.special) {
            throw new IllegalStateException("not identifier: " + this);
        }
        return this.getName();
    }

    public boolean isSpecial() {
        return this.special;
    }

    @Override
    public int compareTo(Name that) {
        return this.name.compareTo(that.name);
    }

    @NotNull
    public static Name identifier(@NotNull String name) {
        NameUtils.requireIdentifier(name);
        return new Name(name, false);
    }

    @NotNull
    public static Name identifierNoValidate(@NotNull String name) {
        return new Name(name, false);
    }

    @NotNull
    public static Name special(@NotNull String name) {
        if (!name.startsWith("<")) {
            throw new IllegalArgumentException("special name must start with '<': " + name);
        }
        return new Name(name, true);
    }

    @NotNull
    public static Name guess(@NotNull String name) {
        if (name.startsWith("<")) {
            return Name.special(name);
        }
        return Name.identifier(name);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Name name1 = (Name)o;
        if (this.special != name1.special) {
            return false;
        }
        return this.name.equals(name1.name);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.special ? 1 : 0);
        return result;
    }
}

