/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.name;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;

public class FqName {
    public static final FqName ROOT = new FqName("");
    @NotNull
    private final FqNameUnsafe fqName;
    private transient FqName parent;

    public FqName(@NotNull String fqName) {
        this.fqName = new FqNameUnsafe(fqName, this);
    }

    public FqName(@NotNull FqNameUnsafe fqName) {
        this.fqName = fqName;
        this.validateFqName();
    }

    private FqName(@NotNull FqNameUnsafe fqName, FqName parent) {
        this.fqName = fqName;
        this.parent = parent;
        this.validateFqName();
    }

    private void validateFqName() {
        if (!FqName.isValidAfterUnsafeCheck(this.fqName.getFqName())) {
            throw new IllegalArgumentException("incorrect fq name: " + this.fqName);
        }
    }

    private static boolean isValidAfterUnsafeCheck(@NotNull String qualifiedName) {
        return qualifiedName.indexOf(60) < 0;
    }

    public static boolean isValid(@Nullable String qualifiedName) {
        return qualifiedName != null && FqNameUnsafe.isValid(qualifiedName) && FqName.isValidAfterUnsafeCheck(qualifiedName);
    }

    @NotNull
    public String getFqName() {
        return this.fqName.getFqName();
    }

    @NotNull
    public FqNameUnsafe toUnsafe() {
        return this.fqName;
    }

    public boolean isRoot() {
        return this.fqName.isRoot();
    }

    @NotNull
    public FqName parent() {
        if (this.parent != null) {
            return this.parent;
        }
        if (this.isRoot()) {
            throw new IllegalStateException("root");
        }
        this.parent = new FqName(this.fqName.parent());
        return this.parent;
    }

    @NotNull
    public FqName child(@NotNull Name name) {
        return new FqName(this.fqName.child(name), this);
    }

    @NotNull
    public Name shortName() {
        return this.fqName.shortName();
    }

    @NotNull
    public List<FqName> path() {
        final ArrayList<FqName> path = Lists.newArrayList();
        path.add(ROOT);
        this.fqName.walk(new FqNameUnsafe.WalkCallback(){

            @Override
            public void segment(@NotNull Name shortName, @NotNull FqNameUnsafe fqName) {
                path.add(new FqName(fqName));
            }
        });
        return path;
    }

    @NotNull
    public List<Name> pathSegments() {
        return this.fqName.pathSegments();
    }

    public boolean firstSegmentIs(@NotNull Name segment) {
        return this.fqName.firstSegmentIs(segment);
    }

    public boolean lastSegmentIs(@NotNull Name segment) {
        return this.fqName.lastSegmentIs(segment);
    }

    @NotNull
    public static FqName topLevel(@NotNull Name shortName) {
        return new FqName(FqNameUnsafe.topLevel(shortName));
    }

    public String toString() {
        return this.fqName.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FqName that = (FqName)o;
        return !(this.fqName != null ? !this.fqName.equals(that.fqName) : that.fqName != null);
    }

    public int hashCode() {
        return this.fqName != null ? this.fqName.hashCode() : 0;
    }
}

