/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.ChainedScope;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;

public class ScopeProvider {
    private final ResolveSession resolveSession;

    public ScopeProvider(@NotNull ResolveSession resolveSession) {
        this.resolveSession = resolveSession;
    }

    @NotNull
    public JetScope getFileScopeForDeclarationResolution(JetFile file) {
        JetNamespaceHeader header = file.getNamespaceHeader();
        if (header == null) {
            throw new IllegalArgumentException("Scripts are not supported: " + file.getName());
        }
        FqName fqName = new FqName(header.getQualifiedName());
        NamespaceDescriptor packageDescriptor = this.resolveSession.getPackageDescriptorByFqName(fqName);
        if (packageDescriptor == null) {
            throw new IllegalStateException("Package not found: " + fqName + " maybe the file is not in scope of this resolve session: " + file.getName());
        }
        WritableScopeImpl writableScope = new WritableScopeImpl(JetScope.EMPTY, packageDescriptor, RedeclarationHandler.DO_NOTHING, "File scope for declaration resolution");
        writableScope.importScope(this.resolveSession.getPackageDescriptorByFqName(FqName.ROOT).getMemberScope());
        ArrayList<JetImportDirective> importDirectives = Lists.newArrayList(file.getImportDirectives());
        this.resolveSession.getModuleConfiguration().addDefaultImports(importDirectives);
        ImportsResolver.processImportsInFile(true, writableScope, importDirectives, this.resolveSession.getPackageDescriptorByFqName(FqName.ROOT).getMemberScope(), this.resolveSession.getModuleConfiguration(), this.resolveSession.getTrace(), this.resolveSession.getInjector().getQualifiedExpressionResolver());
        writableScope.importScope(packageDescriptor.getMemberScope());
        writableScope.changeLockLevel(WritableScope.LockLevel.READING);
        return writableScope;
    }

    @NotNull
    public JetScope getScopeForClassMemberResolution(@NotNull JetClassOrObject classOrObject) {
        ClassDescriptor classDescriptor = this.resolveSession.getClassDescriptor(classOrObject);
        JetScope memberScope = classDescriptor.getDefaultType().getMemberScope();
        JetScope outerScope = this.getResolutionScopeForDeclaration((JetDeclaration)((Object)classOrObject));
        WritableScopeImpl typeParametersScope = new WritableScopeImpl(JetScope.EMPTY, classDescriptor, RedeclarationHandler.DO_NOTHING, "scope for class member resolution");
        for (TypeParameterDescriptor typeParameterDescriptor : classDescriptor.getTypeConstructor().getParameters()) {
            typeParametersScope.addClassifierDescriptor(typeParameterDescriptor);
        }
        return new ChainedScope(classDescriptor, memberScope, typeParametersScope, outerScope);
    }

    public JetScope getScopeForClassSupertypeResolution(JetClassOrObject declaration) {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public JetScope getResolutionScopeForDeclaration(@NotNull JetDeclaration jetDeclaration) {
        PsiElement immediateParent = jetDeclaration.getParent();
        if (immediateParent instanceof JetFile) {
            return this.getFileScopeForDeclarationResolution((JetFile)immediateParent);
        }
        JetDeclaration parentDeclaration = PsiTreeUtil.getParentOfType((PsiElement)jetDeclaration, JetDeclaration.class);
        if (parentDeclaration instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)((Object)parentDeclaration);
            return this.getScopeForClassMemberResolution(classOrObject);
        }
        throw new IllegalStateException("Don't call this method for local declarations: " + jetDeclaration);
    }

    public ClassDescriptor buildLazyClassDescriptor(DeclarationDescriptor declaration, Name name, JetScope outerScope) {
        throw new UnsupportedOperationException();
    }

    public NamespaceDescriptor buildLazyPackageDescriptor(DeclarationDescriptor declaration, Name name) {
        throw new UnsupportedOperationException();
    }
}

