/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.di.InjectorForLazyResolve;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.ModuleConfiguration;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ModuleDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.lazy.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.FqNameUnsafe;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;

public class ResolveSession {
    private final ModuleDescriptor module;
    private final LazyPackageDescriptor rootPackage;
    private final BindingTrace trace = new BindingTraceContext();
    private final DeclarationProviderFactory declarationProviderFactory;
    private final InjectorForLazyResolve injector;
    private final ModuleConfiguration moduleConfiguration;

    public ResolveSession(@NotNull Project project, @NotNull ModuleDescriptor rootDescriptor, @NotNull ModuleConfiguration moduleConfiguration, @NotNull DeclarationProviderFactory declarationProviderFactory) {
        this.injector = new InjectorForLazyResolve(project, this, this.trace);
        this.module = rootDescriptor;
        this.moduleConfiguration = moduleConfiguration;
        PackageMemberDeclarationProvider provider = declarationProviderFactory.getPackageMemberDeclarationProvider(FqName.ROOT);
        assert (provider != null) : "No declaration provider for root package in " + rootDescriptor;
        this.rootPackage = new LazyPackageDescriptor(rootDescriptor, FqNameUnsafe.ROOT_NAME, this, provider);
        rootDescriptor.setRootNamespace(this.rootPackage);
        this.declarationProviderFactory = declarationProviderFactory;
    }

    @NotNull
    public InjectorForLazyResolve getInjector() {
        return this.injector;
    }

    @NotNull
    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    @Nullable
    public NamespaceDescriptor getPackageDescriptor(@NotNull Name shortName) {
        return this.rootPackage.getMemberScope().getNamespace(shortName);
    }

    @Nullable
    public NamespaceDescriptor getPackageDescriptorByFqName(FqName fqName) {
        if (fqName.isRoot()) {
            return this.rootPackage;
        }
        List<Name> names = fqName.pathSegments();
        NamespaceDescriptor current = this.getPackageDescriptor(names.get(0));
        if (current == null) {
            return null;
        }
        for (Name name : names.subList(1, names.size())) {
            if ((current = current.getMemberScope().getNamespace(name)) != null) continue;
            return null;
        }
        return current;
    }

    @NotNull
    public ClassDescriptor getClassDescriptor(@NotNull JetClassOrObject classOrObject) {
        JetScope resolutionScope = this.getInjector().getScopeProvider().getResolutionScopeForDeclaration((JetDeclaration)((Object)classOrObject));
        ClassifierDescriptor classifier = resolutionScope.getClassifier(classOrObject.getNameAsName());
        return (ClassDescriptor)classifier;
    }

    public Collection<DeclarationDescriptor> getDescriptorsForDeclarations(Collection<PsiElement> declarationsOrFiles) {
        final ArrayList<DeclarationDescriptor> descriptors = Lists.newArrayList();
        for (PsiElement declarationOrFile : declarationsOrFiles) {
            declarationOrFile.accept(new JetVisitorVoid(){

                @Override
                public void visitJetFile(JetFile file) {
                    JetNamespaceHeader header = file.getNamespaceHeader();
                    if (header == null) {
                        throw new UnsupportedOperationException("Lazy resolve is not supported for scripts");
                    }
                    NamespaceDescriptor packageDescriptor = ResolveSession.this.getPackageDescriptorByFqName(new FqName(header.getQualifiedName()));
                    if (packageDescriptor == null) {
                        throw new IllegalStateException("Package descriptor not found for: " + header.getQualifiedName());
                    }
                    JetScope packageMemberScope = packageDescriptor.getMemberScope();
                    for (JetDeclaration declaration : file.getDeclarations()) {
                        this.collectDescriptors(packageMemberScope, declaration);
                    }
                }

                @Override
                public void visitDeclaration(JetDeclaration dcl) {
                    JetScope scope = ResolveSession.this.injector.getScopeProvider().getResolutionScopeForDeclaration(dcl);
                    this.collectDescriptors(scope, dcl);
                }

                private void collectDescriptors(JetScope outerScope, JetDeclaration declaration) {
                    if (declaration instanceof JetClass) {
                        JetClass jetClass = (JetClass)declaration;
                        descriptors.add(outerScope.getClassifier(jetClass.getNameAsSafeName()));
                    } else if (declaration instanceof JetFunction) {
                        JetFunction jetFunction = (JetFunction)declaration;
                        Set<FunctionDescriptor> functionDescriptors = outerScope.getFunctions(jetFunction.getNameAsSafeName());
                        descriptors.addAll(functionDescriptors);
                    } else if (declaration instanceof JetProperty) {
                        JetProperty jetProperty = (JetProperty)declaration;
                        Set<VariableDescriptor> functionDescriptors = outerScope.getProperties(jetProperty.getNameAsSafeName());
                        descriptors.addAll(functionDescriptors);
                    } else if (declaration instanceof JetObjectDeclaration) {
                        JetObjectDeclaration jetObjectDeclaration = (JetObjectDeclaration)declaration;
                        descriptors.addAll(outerScope.getProperties(jetObjectDeclaration.getNameAsSafeName()));
                        descriptors.add(outerScope.getObjectDescriptor(jetObjectDeclaration.getNameAsSafeName()));
                    }
                }
            });
        }
        return descriptors;
    }

    @NotNull
    public BindingContext getBindingContext() {
        return this.trace.getBindingContext();
    }

    @NotNull
    BindingTrace getTrace() {
        return this.trace;
    }

    @NotNull
    public DeclarationProviderFactory getDeclarationProviderFactory() {
        return this.declarationProviderFactory;
    }

    @NotNull
    public JetScope getResolutionScope(PsiElement element) {
        PsiElement parent = element.getParent();
        if (parent instanceof JetFile) {
            JetFile file = (JetFile)parent;
            return this.getInjector().getScopeProvider().getFileScopeForDeclarationResolution(file);
        }
        if (parent instanceof JetClassBody) {
            JetClassBody classBody = (JetClassBody)parent;
            JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)classBody, JetClassOrObject.class);
            ClassDescriptor classDescriptor = this.getClassDescriptor(classOrObject);
            assert (classDescriptor instanceof LazyClassDescriptor) : "Trying to resolve a member of a non-lazily loaded class: " + element;
            return ((LazyClassDescriptor)classDescriptor).getScopeForMemberDeclarationResolution();
        }
        throw new IllegalArgumentException("Unsupported PSI element: " + element);
    }
}

