/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElement;
import org.jetbrains.jet.internal.com.intellij.psi.SmartPsiElementPointer;
import org.jetbrains.jet.internal.com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.lazy.IdentitySmartPointer;
import org.jetbrains.jet.lang.resolve.lazy.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.LazyScopeAdapter;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.util.lazy.LazyValue;

public class LazyTypeParameterDescriptor
implements TypeParameterDescriptor {
    private final ResolveSession resolveSession;
    private final SmartPsiElementPointer<JetTypeParameter> jetTypeParameterSmartPsiElementPointer;
    private final Variance variance;
    private final int index;
    private final LazyClassDescriptor containingDeclaration;
    private final Name name;
    private TypeConstructor typeConstructor;
    private JetType defaultType;
    private Set<JetType> upperBounds;
    private JetType upperBoundsAsType;

    public LazyTypeParameterDescriptor(@NotNull ResolveSession resolveSession, @NotNull LazyClassDescriptor containingDeclaration, @NotNull JetTypeParameter jetTypeParameter, int index) {
        this.resolveSession = resolveSession;
        this.jetTypeParameterSmartPsiElementPointer = new IdentitySmartPointer<JetTypeParameter>(jetTypeParameter);
        this.variance = jetTypeParameter.getVariance();
        this.containingDeclaration = containingDeclaration;
        this.index = index;
        this.name = jetTypeParameter.getNameAsName();
    }

    @Override
    public boolean isReified() {
        return false;
    }

    @Override
    public Variance getVariance() {
        return this.variance;
    }

    @Override
    @NotNull
    public Set<JetType> getUpperBounds() {
        if (this.upperBounds == null) {
            this.upperBounds = Sets.newLinkedHashSet();
            JetTypeParameter jetTypeParameter = this.getElement();
            this.resolveUpperBoundsFromWhereClause(this.upperBounds, false);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound != null) {
                this.upperBounds.add(this.resolveBoundType(extendsBound));
            }
            if (this.upperBounds.isEmpty()) {
                this.upperBounds.add(JetStandardClasses.getDefaultBound());
            }
        }
        return this.upperBounds;
    }

    private void resolveUpperBoundsFromWhereClause(Set<JetType> upperBounds, boolean forClassObject) {
        JetTypeParameter jetTypeParameter = this.getElement();
        JetClassOrObject classOrObject = PsiTreeUtil.getParentOfType((PsiElement)jetTypeParameter, JetClassOrObject.class);
        if (classOrObject instanceof JetClass) {
            JetClass jetClass = (JetClass)classOrObject;
            for (JetTypeConstraint jetTypeConstraint : jetClass.getTypeConstraints()) {
                JetTypeReference boundTypeReference;
                JetSimpleNameExpression constrainedParameterName;
                if (jetTypeConstraint.isClassObjectContraint() != forClassObject || (constrainedParameterName = jetTypeConstraint.getSubjectTypeParameterName()) == null || !this.name.equals(constrainedParameterName.getReferencedNameAsName()) || (boundTypeReference = jetTypeConstraint.getBoundTypeReference()) == null) continue;
                upperBounds.add(this.resolveBoundType(boundTypeReference));
            }
        }
    }

    private JetTypeParameter getElement() {
        JetTypeParameter jetTypeParameter = this.jetTypeParameterSmartPsiElementPointer.getElement();
        if (jetTypeParameter == null) {
            throw new IllegalStateException("Psi element not found for type parameter: " + this);
        }
        return jetTypeParameter;
    }

    private JetType resolveBoundType(@NotNull JetTypeReference boundTypeReference) {
        return this.resolveSession.getInjector().getTypeResolver().resolveType(this.containingDeclaration.getScopeForClassHeaderResolution(), boundTypeReference, this.resolveSession.getTrace(), false);
    }

    @Override
    @NotNull
    public JetType getUpperBoundsAsType() {
        if (this.upperBoundsAsType == null) {
            Set<JetType> upperBounds = this.getUpperBounds();
            assert (upperBounds.size() > 0) : "Upper bound list is empty in " + this.getName();
            this.upperBoundsAsType = TypeUtils.intersect(JetTypeChecker.INSTANCE, upperBounds);
            if (this.upperBoundsAsType == null) {
                this.upperBoundsAsType = JetStandardClasses.getNothingType();
            }
        }
        return this.upperBoundsAsType;
    }

    @Override
    @NotNull
    public Set<JetType> getLowerBounds() {
        return Collections.singleton(this.getLowerBoundsAsType());
    }

    @Override
    @NotNull
    public JetType getLowerBoundsAsType() {
        return JetStandardClasses.getNothingType();
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        if (this.typeConstructor == null) {
            this.typeConstructor = new TypeConstructor(){

                @Override
                @NotNull
                public Collection<? extends JetType> getSupertypes() {
                    return LazyTypeParameterDescriptor.this.getUpperBounds();
                }

                @Override
                @NotNull
                public List<TypeParameterDescriptor> getParameters() {
                    return Collections.emptyList();
                }

                @Override
                public boolean isSealed() {
                    return false;
                }

                @Override
                public ClassifierDescriptor getDeclarationDescriptor() {
                    return LazyTypeParameterDescriptor.this;
                }

                @Override
                public List<AnnotationDescriptor> getAnnotations() {
                    return LazyTypeParameterDescriptor.this.getAnnotations();
                }

                public String toString() {
                    return LazyTypeParameterDescriptor.this.getName().toString();
                }
            };
        }
        return this.typeConstructor;
    }

    @Override
    @NotNull
    public JetType getDefaultType() {
        if (this.defaultType == null) {
            this.defaultType = new JetTypeImpl(this.getTypeConstructor(), new LazyScopeAdapter(new LazyValue<JetScope>(){

                @Override
                protected JetScope compute() {
                    return LazyTypeParameterDescriptor.this.getUpperBoundsAsType().getMemberScope();
                }
            }));
        }
        return this.defaultType;
    }

    @Override
    public JetType getClassObjectType() {
        return null;
    }

    @Override
    public boolean isClassObjectAValue() {
        return false;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @Deprecated
    @NotNull
    public TypeParameterDescriptor substitute(TypeSubstitutor substitutor) {
        throw new UnsupportedOperationException("Don't call substitute() on type parameters");
    }

    @Override
    public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
        return visitor.visitTypeParameterDescriptor(this, data);
    }

    @Override
    public void acceptVoid(DeclarationDescriptorVisitor<Void, Void> visitor) {
        visitor.visitTypeParameterDescriptor(this, null);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        return Collections.emptyList();
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    public String toString() {
        return this.getName().toString();
    }
}

