/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorParent;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.lazy.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.LazyPackageDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class LazyPackageMemberScope
extends AbstractLazyMemberScope<NamespaceDescriptor, PackageMemberDeclarationProvider> {
    private final Map<Name, NamespaceDescriptor> packageDescriptors = Maps.newHashMap();

    public LazyPackageMemberScope(@NotNull ResolveSession resolveSession, @NotNull PackageMemberDeclarationProvider declarationProvider, @NotNull NamespaceDescriptor thisPackage) {
        super(resolveSession, declarationProvider, thisPackage);
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        NamespaceDescriptor known = this.packageDescriptors.get(name);
        if (known != null) {
            return known;
        }
        if (this.allDescriptorsComputed) {
            return null;
        }
        if (!((PackageMemberDeclarationProvider)this.declarationProvider).isPackageDeclared(name)) {
            return null;
        }
        PackageMemberDeclarationProvider packageMemberDeclarationProvider = this.resolveSession.getDeclarationProviderFactory().getPackageMemberDeclarationProvider(DescriptorUtils.getFQName(this.thisDescriptor).child(name).toSafe());
        assert (packageMemberDeclarationProvider != null) : "Package is declared, but declaration provider is not found: " + name;
        LazyPackageDescriptor namespaceDescriptor = new LazyPackageDescriptor((NamespaceDescriptorParent)this.thisDescriptor, name, this.resolveSession, packageMemberDeclarationProvider);
        this.packageDescriptors.put(name, namespaceDescriptor);
        this.allDescriptors.add(namespaceDescriptor);
        return namespaceDescriptor;
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        return this.resolveSession.getInjector().getScopeProvider().getFileScopeForDeclarationResolution((JetFile)declaration.getContainingFile());
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        return ReceiverDescriptor.NO_RECEIVER;
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, @NotNull Set<FunctionDescriptor> result) {
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result) {
    }

    @Override
    protected void addExtraDescriptors() {
        for (FqName packageFqName : ((PackageMemberDeclarationProvider)this.declarationProvider).getAllDeclaredPackages()) {
            this.getNamespace(packageFqName.shortName());
        }
    }
}

