/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContextUtils;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.lazy.AbstractLazyMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.util.lazy.LazyValue;

public class LazyClassMemberScope
extends AbstractLazyMemberScope<LazyClassDescriptor, ClassMemberDeclarationProvider> {
    private ConstructorDescriptor primaryConstructor;
    private boolean primaryConstructorResolved = false;

    public LazyClassMemberScope(@NotNull ResolveSession resolveSession, @NotNull ClassMemberDeclarationProvider declarationProvider, @NotNull LazyClassDescriptor thisClass) {
        super(resolveSession, declarationProvider, thisClass);
    }

    @Override
    @NotNull
    protected JetScope getScopeForMemberDeclarationResolution(JetDeclaration declaration) {
        return ((LazyClassDescriptor)this.thisDescriptor).getScopeForMemberDeclarationResolution();
    }

    @Override
    protected void getNonDeclaredFunctions(@NotNull Name name, final @NotNull Set<FunctionDescriptor> result) {
        ArrayList<FunctionDescriptor> fromSupertypes = Lists.newArrayList();
        for (JetType jetType : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            fromSupertypes.addAll(jetType.getMemberScope().getFunctions(name));
        }
        OverrideResolver.generateOverridesInFunctionGroup(name, fromSupertypes, Lists.newArrayList(result), (ClassDescriptor)this.thisDescriptor, new OverrideResolver.DescriptorSink(){

            @Override
            public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                assert (fakeOverride instanceof FunctionDescriptor) : "A non-function overrides a function";
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)fakeOverride;
                result.add(functionDescriptor);
            }

            @Override
            public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                BindingTrace trace = LazyClassMemberScope.this.resolveSession.getTrace();
                JetDeclaration declaration = (JetDeclaration)BindingContextUtils.descriptorToDeclaration(trace.getBindingContext(), fromCurrent);
                assert (declaration != null) : "fromCurrent can not be a fake override";
                trace.report(Errors.CONFLICTING_OVERLOADS.on(declaration, fromCurrent, fromCurrent.getContainingDeclaration().getName().getName()));
            }
        });
    }

    @Override
    protected void getNonDeclaredProperties(@NotNull Name name, @NotNull Set<VariableDescriptor> result) {
        System.err.println("getNonDeclaredProperties() should generate fake overrides for a class");
        throw new UnsupportedOperationException();
    }

    @Override
    protected void addExtraDescriptors() {
        for (JetType jetType : ((LazyClassDescriptor)this.thisDescriptor).getTypeConstructor().getSupertypes()) {
            for (DeclarationDescriptor descriptor : jetType.getMemberScope().getAllDescriptors()) {
                if (descriptor instanceof FunctionDescriptor) {
                    this.getFunctions(descriptor.getName());
                    continue;
                }
                if (!(descriptor instanceof PropertyDescriptor)) continue;
                this.getProperties(descriptor.getName());
            }
        }
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        return ((LazyClassDescriptor)this.thisDescriptor).getImplicitReceiver();
    }

    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        ConstructorDescriptor constructor = this.getPrimaryConstructor();
        return constructor == null ? Collections.emptySet() : Collections.singleton(constructor);
    }

    @Nullable
    public ConstructorDescriptor getPrimaryConstructor() {
        if (!this.primaryConstructorResolved) {
            JetClassOrObject classOrObject;
            if (EnumSet.of(ClassKind.CLASS, ClassKind.ANNOTATION_CLASS).contains((Object)((LazyClassDescriptor)this.thisDescriptor).getKind()) && (classOrObject = ((ClassMemberDeclarationProvider)this.declarationProvider).getOwnerClassOrObject()) instanceof JetClass) {
                JetClass jetClass = (JetClass)classOrObject;
                ConstructorDescriptorImpl descriptor = this.resolveSession.getInjector().getDescriptorResolver().resolvePrimaryConstructorDescriptor(((LazyClassDescriptor)this.thisDescriptor).getScopeForClassHeaderResolution(), (ClassDescriptor)this.thisDescriptor, jetClass, this.resolveSession.getTrace());
                this.primaryConstructor = descriptor;
                descriptor.setReturnType(DeferredType.create(this.resolveSession.getTrace(), new LazyValue<JetType>(){

                    @Override
                    protected JetType compute() {
                        return ((LazyClassDescriptor)LazyClassMemberScope.this.thisDescriptor).getDefaultType();
                    }
                }));
            }
            this.primaryConstructorResolved = true;
        }
        return this.primaryConstructor;
    }
}

