/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptorBase;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.lazy.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.LazyClassMemberScope;
import org.jetbrains.jet.lang.resolve.lazy.LazyTypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.InnerClassesScopeWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.RedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lexer.JetTokens;

public class LazyClassDescriptor
extends ClassDescriptorBase
implements ClassDescriptor {
    private final ResolveSession resolveSession;
    private final ClassMemberDeclarationProvider declarationProvider;
    private final Name name;
    private final DeclarationDescriptor containingDeclaration;
    private final TypeConstructor typeConstructor;
    private final Modality modality;
    private final Visibility visibility;
    private final ClassKind kind;
    private ClassReceiver implicitReceiver;
    private List<AnnotationDescriptor> annotations;
    private ClassDescriptor classObjectDescriptor;
    private boolean classObjectDescriptorResolved = false;
    private final LazyClassMemberScope unsubstitutedMemberScope;
    private final JetScope unsubstitutedInnerClassesScope;
    private JetScope scopeForClassHeaderResolution;
    private JetScope scopeForMemberDeclarationResolution;

    public LazyClassDescriptor(@NotNull ResolveSession resolveSession, @NotNull DeclarationDescriptor containingDeclaration, @NotNull Name name, @NotNull ClassMemberDeclarationProvider memberDeclarationProvider) {
        this.declarationProvider = memberDeclarationProvider;
        this.resolveSession = resolveSession;
        this.name = name;
        this.containingDeclaration = containingDeclaration;
        this.unsubstitutedMemberScope = new LazyClassMemberScope(resolveSession, memberDeclarationProvider, this);
        this.unsubstitutedInnerClassesScope = new InnerClassesScopeWrapper(this.unsubstitutedMemberScope);
        this.typeConstructor = new LazyClassTypeConstructor();
        JetClassOrObject classOrObject = memberDeclarationProvider.getOwnerClassOrObject();
        this.kind = LazyClassDescriptor.getClassKind(classOrObject);
        Modality defaultModality = this.kind == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
        JetModifierList modifierList = classOrObject.getModifierList();
        this.modality = DescriptorResolver.resolveModalityFromModifiers(modifierList, defaultModality);
        this.visibility = DescriptorResolver.resolveVisibilityFromModifiers(modifierList);
    }

    @NotNull
    private static ClassKind getClassKind(@NotNull JetClassOrObject jetClassOrObject) {
        if (jetClassOrObject instanceof JetClass) {
            JetClass jetClass = (JetClass)jetClassOrObject;
            if (jetClass.isTrait()) {
                return ClassKind.TRAIT;
            }
            if (jetClass.hasModifier(JetTokens.ANNOTATION_KEYWORD)) {
                return ClassKind.ANNOTATION_CLASS;
            }
            if (jetClass.hasModifier(JetTokens.ENUM_KEYWORD)) {
                return ClassKind.ENUM_CLASS;
            }
            return ClassKind.CLASS;
        }
        if (jetClassOrObject instanceof JetObjectDeclaration) {
            return ClassKind.OBJECT;
        }
        throw new IllegalArgumentException("Unknown class or object kind: " + jetClassOrObject);
    }

    @Override
    protected JetScope getScopeForMemberLookup() {
        return this.unsubstitutedMemberScope;
    }

    @Override
    @NotNull
    public JetScope getUnsubstitutedInnerClassesScope() {
        return this.unsubstitutedInnerClassesScope;
    }

    @NotNull
    public JetScope getScopeForClassHeaderResolution() {
        if (this.scopeForClassHeaderResolution == null) {
            WritableScopeImpl scope = new WritableScopeImpl(this.resolveSession.getResolutionScope(this.declarationProvider.getOwnerClassOrObject()), this, RedeclarationHandler.DO_NOTHING, "Class Header Resolution");
            for (TypeParameterDescriptor typeParameterDescriptor : this.getTypeConstructor().getParameters()) {
                scope.addClassifierDescriptor(typeParameterDescriptor);
            }
            scope.changeLockLevel(WritableScope.LockLevel.READING);
            this.scopeForClassHeaderResolution = scope;
        }
        return this.scopeForClassHeaderResolution;
    }

    public JetScope getScopeForMemberDeclarationResolution() {
        if (this.scopeForMemberDeclarationResolution == null) {
            WritableScopeImpl scope = new WritableScopeImpl(this.getScopeForClassHeaderResolution(), this, RedeclarationHandler.DO_NOTHING, "Member Declaration Resolution");
            scope.importScope(this.getScopeForMemberLookup());
            scope.changeLockLevel(WritableScope.LockLevel.READING);
            this.scopeForMemberDeclarationResolution = scope;
        }
        return this.scopeForMemberDeclarationResolution;
    }

    @Override
    @NotNull
    public Set<ConstructorDescriptor> getConstructors() {
        return this.unsubstitutedMemberScope.getConstructors();
    }

    @Override
    public ConstructorDescriptor getUnsubstitutedPrimaryConstructor() {
        return this.unsubstitutedMemberScope.getPrimaryConstructor();
    }

    @Override
    @NotNull
    public DeclarationDescriptor getOriginal() {
        return this;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.containingDeclaration;
    }

    @Override
    @NotNull
    public TypeConstructor getTypeConstructor() {
        return this.typeConstructor;
    }

    @Override
    public JetType getClassObjectType() {
        ClassDescriptor classObjectDescriptor = this.getClassObjectDescriptor();
        return classObjectDescriptor == null ? null : classObjectDescriptor.getDefaultType();
    }

    @Override
    public boolean isClassObjectAValue() {
        return true;
    }

    @Override
    public ClassDescriptor getClassObjectDescriptor() {
        if (!this.classObjectDescriptorResolved) {
            JetObjectDeclaration objectDeclaration;
            JetClassObject classObject = this.declarationProvider.getClassObject();
            if (classObject != null && (objectDeclaration = classObject.getObjectDeclaration()) != null) {
                ClassMemberDeclarationProvider classMemberDeclarationProvider = this.resolveSession.getDeclarationProviderFactory().getClassMemberDeclarationProvider(objectDeclaration);
                this.classObjectDescriptor = new LazyClassDescriptor(this.resolveSession, this, Name.special("<class object>"), classMemberDeclarationProvider);
            }
            this.classObjectDescriptorResolved = true;
        }
        return this.classObjectDescriptor;
    }

    @Override
    @NotNull
    public ClassKind getKind() {
        return this.kind;
    }

    @Override
    @NotNull
    public Modality getModality() {
        return this.modality;
    }

    @Override
    @NotNull
    public Visibility getVisibility() {
        return this.visibility;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        if (this.implicitReceiver == null) {
            this.implicitReceiver = new ClassReceiver(this);
        }
        return this.implicitReceiver;
    }

    @Override
    public List<AnnotationDescriptor> getAnnotations() {
        if (this.annotations == null) {
            JetClassOrObject classOrObject = this.declarationProvider.getOwnerClassOrObject();
            JetModifierList modifierList = classOrObject.getModifierList();
            if (modifierList != null) {
                AnnotationResolver annotationResolver = this.resolveSession.getInjector().getAnnotationResolver();
                this.annotations = annotationResolver.resolveAnnotations(this.resolveSession.getResolutionScope(classOrObject), modifierList, this.resolveSession.getTrace());
            } else {
                this.annotations = Collections.emptyList();
            }
        }
        return this.annotations;
    }

    @Override
    @NotNull
    public Name getName() {
        return this.name;
    }

    public String toString() {
        return "lazy class " + this.getName().toString();
    }

    private class LazyClassTypeConstructor
    implements TypeConstructor {
        private Collection<JetType> supertypes = null;
        private List<TypeParameterDescriptor> parameters = null;

        private LazyClassTypeConstructor() {
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getParameters() {
            if (this.parameters == null) {
                JetClassOrObject declaration = LazyClassDescriptor.this.declarationProvider.getOwnerClassOrObject();
                if (declaration instanceof JetClass) {
                    JetClass jetClass = (JetClass)declaration;
                    List<JetTypeParameter> typeParameters = jetClass.getTypeParameters();
                    this.parameters = new ArrayList<TypeParameterDescriptor>(typeParameters.size());
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        this.parameters.add(new LazyTypeParameterDescriptor(LazyClassDescriptor.this.resolveSession, LazyClassDescriptor.this, typeParameters.get(i), i));
                    }
                } else {
                    this.parameters = Collections.emptyList();
                }
            }
            return this.parameters;
        }

        @Override
        @NotNull
        public Collection<? extends JetType> getSupertypes() {
            if (this.supertypes == null) {
                JetClassOrObject declaration = LazyClassDescriptor.this.declarationProvider.getOwnerClassOrObject();
                this.supertypes = LazyClassDescriptor.this.resolveSession.getInjector().getDescriptorResolver().resolveSupertypes(LazyClassDescriptor.this.getScopeForClassHeaderResolution(), declaration, LazyClassDescriptor.this.resolveSession.getTrace());
            }
            return this.supertypes;
        }

        @Override
        public boolean isSealed() {
            return !LazyClassDescriptor.this.getModality().isOverridable();
        }

        @Override
        public ClassifierDescriptor getDeclarationDescriptor() {
            return LazyClassDescriptor.this;
        }

        @Override
        public List<AnnotationDescriptor> getAnnotations() {
            return Collections.emptyList();
        }

        public String toString() {
            return LazyClassDescriptor.this.getName().toString();
        }
    }
}

