/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.lazy.AbstractPsiBasedDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.FileBasedDeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class FileBasedPackageMemberDeclarationProvider
extends AbstractPsiBasedDeclarationProvider
implements PackageMemberDeclarationProvider {
    private final FqName fqName;
    private final FileBasedDeclarationProviderFactory factory;
    private final Collection<JetFile> allFiles;
    private Collection<FqName> allDeclaredPackages;

    FileBasedPackageMemberDeclarationProvider(@NotNull FqName fqName, @NotNull FileBasedDeclarationProviderFactory factory, @NotNull Collection<JetFile> allFiles) {
        this.fqName = fqName;
        this.factory = factory;
        this.allFiles = allFiles;
    }

    @Override
    protected void doCreateIndex() {
        for (JetFile file : this.allFiles) {
            for (JetDeclaration declaration : file.getDeclarations()) {
                this.putToIndex(declaration);
            }
        }
    }

    @Override
    public boolean isPackageDeclared(@NotNull Name name) {
        return this.factory.isPackageDeclared(this.fqName.child(name));
    }

    @Override
    public Collection<FqName> getAllDeclaredPackages() {
        if (this.allDeclaredPackages == null) {
            this.allDeclaredPackages = this.factory.getAllDeclaredSubPackagesOf(this.fqName);
        }
        return this.allDeclaredPackages;
    }
}

