/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.base.Predicate;
import org.jetbrains.jet.internal.com.google.common.collect.Collections2;
import org.jetbrains.jet.internal.com.google.common.collect.HashMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.resolve.lazy.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.DeclarationProviderFactory;
import org.jetbrains.jet.lang.resolve.lazy.FileBasedPackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.PackageMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.PsiBasedClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class FileBasedDeclarationProviderFactory
implements DeclarationProviderFactory {
    private final Collection<JetFile> allFiles;
    private final Multimap<FqName, JetFile> filesByPackage = HashMultimap.create();
    private final Set<FqName> declaredPackages = Sets.newHashSet();
    private final Map<FqName, PackageMemberDeclarationProvider> packageDeclarationProviders = Maps.newHashMap();
    private final Map<JetClassOrObject, ClassMemberDeclarationProvider> classMemberDeclarationProviders = Maps.newHashMap();
    private boolean indexed = false;

    public FileBasedDeclarationProviderFactory(@NotNull Collection<JetFile> files) {
        this.allFiles = files;
    }

    private void createIndex() {
        if (this.indexed) {
            return;
        }
        this.indexed = true;
        for (JetFile file : this.allFiles) {
            JetNamespaceHeader header = file.getNamespaceHeader();
            if (header == null) {
                throw new IllegalArgumentException("Scripts are not supported");
            }
            FqName packageFqName = new FqName(header.getQualifiedName());
            this.addMeAndParentPackages(packageFqName);
            this.filesByPackage.put(packageFqName, file);
        }
    }

    private void addMeAndParentPackages(@NotNull FqName name) {
        this.declaredPackages.add(name);
        if (!name.isRoot()) {
            this.addMeAndParentPackages(name.parent());
        }
    }

    boolean isPackageDeclared(@NotNull FqName packageFqName) {
        this.createIndex();
        return this.declaredPackages.contains(packageFqName);
    }

    Collection<FqName> getAllDeclaredSubPackagesOf(final @NotNull FqName parent) {
        return Collections2.filter(this.declaredPackages, new Predicate<FqName>(){

            @Override
            public boolean apply(FqName fqName) {
                return !fqName.isRoot() && fqName.parent().equals(parent);
            }
        });
    }

    @Override
    public PackageMemberDeclarationProvider getPackageMemberDeclarationProvider(@NotNull FqName packageFqName) {
        this.createIndex();
        PackageMemberDeclarationProvider declarationProvider = this.packageDeclarationProviders.get(packageFqName);
        if (declarationProvider != null) {
            return declarationProvider;
        }
        if (!this.isPackageDeclared(packageFqName)) {
            return null;
        }
        FileBasedPackageMemberDeclarationProvider provider = new FileBasedPackageMemberDeclarationProvider(packageFqName, this, this.filesByPackage.get(packageFqName));
        this.packageDeclarationProviders.put(packageFqName, provider);
        return provider;
    }

    @Override
    @NotNull
    public ClassMemberDeclarationProvider getClassMemberDeclarationProvider(@NotNull JetClassOrObject jetClassOrObject) {
        this.createIndex();
        ClassMemberDeclarationProvider declarationProvider = this.classMemberDeclarationProviders.get(jetClassOrObject);
        if (declarationProvider != null) {
            return declarationProvider;
        }
        JetFile file = (JetFile)jetClassOrObject.getContainingFile();
        if (!this.filesByPackage.containsKey(new FqName(file.getNamespaceHeader().getQualifiedName()))) {
            throw new IllegalStateException("This factory doesn't know about this class: " + jetClassOrObject);
        }
        PsiBasedClassMemberDeclarationProvider provider = new PsiBasedClassMemberDeclarationProvider(jetClassOrObject);
        this.classMemberDeclarationProviders.put(jetClassOrObject, provider);
        return provider;
    }
}

