/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.google.common.collect.HashMultimap;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Multimap;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.lazy.DeclarationProvider;
import org.jetbrains.jet.lang.resolve.name.Name;

public abstract class AbstractPsiBasedDeclarationProvider
implements DeclarationProvider {
    private final List<JetDeclaration> allDeclarations = Lists.newArrayList();
    private final Multimap<Name, JetNamedFunction> functions = HashMultimap.create();
    private final Multimap<Name, JetProperty> properties = HashMultimap.create();
    private final Map<Name, JetClassOrObject> classesAndObjects = Maps.newHashMap();
    private boolean indexCreated = false;

    protected final void createIndex() {
        if (this.indexCreated) {
            return;
        }
        this.indexCreated = true;
        this.doCreateIndex();
    }

    protected abstract void doCreateIndex();

    protected void putToIndex(JetDeclaration declaration) {
        this.allDeclarations.add(declaration);
        if (declaration instanceof JetNamedFunction) {
            JetNamedFunction namedFunction = (JetNamedFunction)declaration;
            this.functions.put(namedFunction.getNameAsName(), namedFunction);
        } else if (declaration instanceof JetProperty) {
            JetProperty property = (JetProperty)declaration;
            this.properties.put(property.getNameAsName(), property);
        } else if (declaration instanceof JetClassOrObject) {
            JetClassOrObject classOrObject = (JetClassOrObject)((Object)declaration);
            this.classesAndObjects.put(classOrObject.getNameAsName(), classOrObject);
        } else {
            throw new IllegalArgumentException("Unknown declaration: " + declaration);
        }
    }

    @Override
    public List<JetDeclaration> getAllDeclarations() {
        this.createIndex();
        return this.allDeclarations;
    }

    @Override
    @NotNull
    public List<JetNamedFunction> getFunctionDeclarations(@NotNull Name name) {
        this.createIndex();
        return Lists.newArrayList(this.functions.get(name));
    }

    @Override
    @NotNull
    public List<JetProperty> getPropertyDeclarations(@NotNull Name name) {
        this.createIndex();
        return Lists.newArrayList(this.properties.get(name));
    }

    @Override
    public JetClassOrObject getClassOrObjectDeclaration(@NotNull Name name) {
        this.createIndex();
        return this.classesAndObjects.get(name);
    }
}

