/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.lazy;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Maps;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.lazy.ClassMemberDeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.DeclarationProvider;
import org.jetbrains.jet.lang.resolve.lazy.LazyClassDescriptor;
import org.jetbrains.jet.lang.resolve.lazy.ResolveSession;
import org.jetbrains.jet.lang.resolve.name.LabelName;
import org.jetbrains.jet.lang.resolve.name.Name;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public abstract class AbstractLazyMemberScope<D extends DeclarationDescriptor, DP extends DeclarationProvider>
implements JetScope {
    protected final ResolveSession resolveSession;
    protected final DP declarationProvider;
    protected final D thisDescriptor;
    protected boolean allDescriptorsComputed = false;
    private final Map<Name, ClassDescriptor> classDescriptors = Maps.newHashMap();
    private final Map<Name, Set<FunctionDescriptor>> functionDescriptors = Maps.newHashMap();
    private final Map<Name, Set<VariableDescriptor>> propertyDescriptors = Maps.newHashMap();
    protected final List<DeclarationDescriptor> allDescriptors = Lists.newArrayList();

    protected AbstractLazyMemberScope(@NotNull ResolveSession resolveSession, @NotNull DP declarationProvider, @NotNull D thisDescriptor) {
        this.resolveSession = resolveSession;
        this.declarationProvider = declarationProvider;
        this.thisDescriptor = thisDescriptor;
    }

    @Nullable
    private ClassDescriptor getClassOrObjectDescriptor(@NotNull Name name, boolean object) {
        ClassDescriptor known = this.classDescriptors.get(name);
        if (known != null) {
            return known;
        }
        if (this.allDescriptorsComputed) {
            return null;
        }
        JetClassOrObject classOrObjectDeclaration = this.declarationProvider.getClassOrObjectDeclaration(name);
        if (classOrObjectDeclaration == null) {
            return null;
        }
        if (object != classOrObjectDeclaration instanceof JetObjectDeclaration) {
            return null;
        }
        ClassMemberDeclarationProvider classMemberDeclarationProvider = this.resolveSession.getDeclarationProviderFactory().getClassMemberDeclarationProvider(classOrObjectDeclaration);
        LazyClassDescriptor classDescriptor = new LazyClassDescriptor(this.resolveSession, (DeclarationDescriptor)this.thisDescriptor, name, classMemberDeclarationProvider);
        this.classDescriptors.put(name, classDescriptor);
        this.allDescriptors.add(classDescriptor);
        return classDescriptor;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        return this.getClassOrObjectDescriptor(name, false);
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return this.getClassOrObjectDescriptor(name, true);
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull Name name) {
        Set<FunctionDescriptor> known = this.functionDescriptors.get(name);
        if (known != null) {
            return known;
        }
        if (this.allDescriptorsComputed) {
            return Collections.emptySet();
        }
        LinkedHashSet<FunctionDescriptor> result = Sets.newLinkedHashSet();
        List<JetNamedFunction> declarations = this.declarationProvider.getFunctionDeclarations(name);
        for (JetNamedFunction functionDeclaration : declarations) {
            JetScope resolutionScope = this.getScopeForMemberDeclarationResolution(functionDeclaration);
            result.add(this.resolveSession.getInjector().getDescriptorResolver().resolveFunctionDescriptor((DeclarationDescriptor)this.thisDescriptor, resolutionScope, functionDeclaration, this.resolveSession.getTrace()));
        }
        this.getNonDeclaredFunctions(name, result);
        if (!result.isEmpty()) {
            this.functionDescriptors.put(name, result);
            this.allDescriptors.addAll(result);
        }
        return result;
    }

    @NotNull
    protected abstract JetScope getScopeForMemberDeclarationResolution(JetDeclaration var1);

    protected abstract void getNonDeclaredFunctions(@NotNull Name var1, @NotNull Set<FunctionDescriptor> var2);

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull Name name) {
        Set<VariableDescriptor> known = this.propertyDescriptors.get(name);
        if (known != null) {
            return known;
        }
        if (this.allDescriptorsComputed) {
            return Collections.emptySet();
        }
        LinkedHashSet<VariableDescriptor> result = Sets.newLinkedHashSet();
        List<JetProperty> declarations = this.declarationProvider.getPropertyDeclarations(name);
        for (JetProperty propertyDeclaration : declarations) {
            JetScope resolutionScope = this.getScopeForMemberDeclarationResolution(propertyDeclaration);
            result.add(this.resolveSession.getInjector().getDescriptorResolver().resolvePropertyDescriptor((DeclarationDescriptor)this.thisDescriptor, resolutionScope, propertyDeclaration, this.resolveSession.getTrace()));
        }
        this.getNonDeclaredProperties(name, result);
        if (!result.isEmpty()) {
            this.propertyDescriptors.put(name, result);
            this.allDescriptors.addAll(result);
        }
        return result;
    }

    protected abstract void getNonDeclaredProperties(@NotNull Name var1, @NotNull Set<VariableDescriptor> var2);

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        throw new UnsupportedOperationException();
    }

    @Override
    public VariableDescriptor getLocalVariable(@NotNull Name name) {
        return null;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.thisDescriptor;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(@NotNull LabelName labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public PropertyDescriptor getPropertyByFieldReference(@NotNull Name fieldName) {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        for (JetDeclaration declaration : this.declarationProvider.getAllDeclarations()) {
            if (declaration instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)((Object)declaration);
                this.getClassifier(classOrObject.getNameAsName());
                continue;
            }
            if (declaration instanceof JetFunction) {
                JetFunction function = (JetFunction)declaration;
                this.getFunctions(function.getNameAsSafeName());
                continue;
            }
            if (declaration instanceof JetProperty) {
                JetProperty property = (JetProperty)declaration;
                this.getProperties(property.getNameAsSafeName());
                continue;
            }
            throw new IllegalArgumentException("Unsupported declaration kind: " + declaration);
        }
        this.addExtraDescriptors();
        this.allDescriptorsComputed = true;
        return this.allDescriptors;
    }

    protected abstract void addExtraDescriptors();

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
        ReceiverDescriptor receiver = this.getImplicitReceiver();
        if (receiver.exists()) {
            result.add(receiver);
        }
    }
}

