/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.lang.resolve.java.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.java.kt.JetConstructorAnnotation;
import org.jetbrains.jet.lang.resolve.java.kt.JetMethodAnnotation;
import org.jetbrains.jet.lang.resolve.java.kt.KotlinSignatureAnnotation;

public class PsiMethodWrapper
extends PsiMemberWrapper {
    private List<PsiParameterWrapper> parameters;
    private JetMethodAnnotation jetMethod;
    private JetConstructorAnnotation jetConstructor;
    private KotlinSignatureAnnotation signatureAnnotation;

    public PsiMethodWrapper(@NotNull PsiMethod psiMethod) {
        super(psiMethod);
    }

    @NotNull
    public List<PsiParameterWrapper> getParameters() {
        if (this.parameters == null) {
            PsiParameter[] psiParameters = this.getPsiMethod().getParameterList().getParameters();
            this.parameters = new ArrayList<PsiParameterWrapper>(psiParameters.length);
            for (int i = 0; i < psiParameters.length; ++i) {
                this.parameters.add(new PsiParameterWrapper(psiParameters[i]));
            }
        }
        return this.parameters;
    }

    @NotNull
    public PsiParameterWrapper getParameter(int i) {
        return this.getParameters().get(i);
    }

    @NotNull
    public JetMethodAnnotation getJetMethod() {
        if (this.jetMethod == null) {
            this.jetMethod = JetMethodAnnotation.get(this.getPsiMethod());
        }
        return this.jetMethod;
    }

    @NotNull
    public JetConstructorAnnotation getJetConstructor() {
        if (this.jetConstructor == null) {
            this.jetConstructor = JetConstructorAnnotation.get(this.getPsiMethod());
        }
        return this.jetConstructor;
    }

    @NotNull
    public KotlinSignatureAnnotation getSignatureAnnotation() {
        if (this.signatureAnnotation == null) {
            this.signatureAnnotation = KotlinSignatureAnnotation.get(this.getPsiMethod());
        }
        return this.signatureAnnotation;
    }

    @Override
    public boolean isAbstract() {
        return this.psiMember.hasModifierProperty("abstract");
    }

    @NotNull
    public PsiMethod getPsiMethod() {
        return (PsiMethod)this.psiMember;
    }

    @Nullable
    public PsiType getReturnType() {
        return this.getPsiMethod().getReturnType();
    }
}

