/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import javax.annotation.PostConstruct;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.jet.internal.com.intellij.psi.PsiAnnotation;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.impl.compiled.ClsClassImpl;
import org.jetbrains.jet.internal.com.intellij.psi.search.DelegatingGlobalSearchScope;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.resolve.java.CompilerDependencies;
import org.jetbrains.jet.lang.resolve.java.JavaPsiFacadeKotlinHacks;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.PsiClassFinder;
import org.jetbrains.jet.lang.resolve.java.alt.AltClassFinder;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.plugin.JetFileType;

public class PsiClassFinderForJvm
implements PsiClassFinder {
    @NotNull
    private Project project;
    @NotNull
    private CompilerDependencies compilerDependencies;
    private AltClassFinder altClassFinder;
    private GlobalSearchScope javaSearchScope;
    private JavaPsiFacadeKotlinHacks javaFacade;

    @Inject
    public void setProject(@NotNull Project project) {
        this.project = project;
    }

    @Inject
    public void setCompilerDependencies(@NotNull CompilerDependencies compilerDependencies) {
        this.compilerDependencies = compilerDependencies;
    }

    @PostConstruct
    public void initialize() {
        this.altClassFinder = new AltClassFinder(this.project, this.compilerDependencies.getJdkHeaderRoots());
        this.javaSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope(this.project)){

            @Override
            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }
        };
        this.javaFacade = new JavaPsiFacadeKotlinHacks(this.project);
    }

    @Override
    @Nullable
    public PsiClass findPsiClass(@NotNull FqName qualifiedName, @NotNull PsiClassFinder.RuntimeClassesHandleMode runtimeClassesHandleMode) {
        FqName actualQualifiedName;
        PsiClass original = this.javaFacade.findClass(qualifiedName.getFqName(), this.javaSearchScope);
        PsiClass altClass = this.altClassFinder.findClass(qualifiedName);
        PsiClass result = original;
        if (altClass != null) {
            if (original == null) {
                return null;
            }
            if (altClass instanceof ClsClassImpl) {
                altClass.putUserData(ClsClassImpl.DELEGATE_KEY, original);
            }
            result = altClass;
        }
        if (result != null && !(actualQualifiedName = new FqName(result.getQualifiedName())).equals(qualifiedName)) {
            throw new IllegalStateException("requested " + qualifiedName + ", got " + actualQualifiedName);
        }
        if (result instanceof JetJavaMirrorMarker) {
            throw new IllegalStateException("JetJavaMirrorMaker is not possible in resolve.java, resolving: " + qualifiedName);
        }
        if (result == null) {
            return null;
        }
        PsiAnnotation assertInvisibleAnnotation = result.getModifierList().findAnnotation(JvmStdlibNames.ASSERT_INVISIBLE_IN_RESOLVER.getFqName().getFqName());
        if (assertInvisibleAnnotation != null) {
            if (runtimeClassesHandleMode == PsiClassFinder.RuntimeClassesHandleMode.IGNORE) {
                return null;
            }
            if (runtimeClassesHandleMode == PsiClassFinder.RuntimeClassesHandleMode.THROW) {
                throw new IllegalStateException("classpath is configured incorrectly: class " + qualifiedName + " from runtime must not be loaded by compiler");
            }
            throw new IllegalStateException("unknown parameter value: " + (Object)((Object)runtimeClassesHandleMode));
        }
        return result;
    }

    @Override
    @Nullable
    public PsiPackage findPsiPackage(@NotNull FqName qualifiedName) {
        return this.javaFacade.findPackage(qualifiedName.getFqName());
    }
}

