/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.lang.resolve.java.JvmClassName;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;

public enum JvmPrimitiveType {
    BOOLEAN(PrimitiveType.BOOLEAN, "boolean", "java.lang.Boolean", Type.BOOLEAN_TYPE),
    CHAR(PrimitiveType.CHAR, "char", "java.lang.Character", Type.CHAR_TYPE),
    BYTE(PrimitiveType.BYTE, "byte", "java.lang.Byte", Type.BYTE_TYPE),
    SHORT(PrimitiveType.SHORT, "short", "java.lang.Short", Type.SHORT_TYPE),
    INT(PrimitiveType.INT, "int", "java.lang.Integer", Type.INT_TYPE),
    FLOAT(PrimitiveType.FLOAT, "float", "java.lang.Float", Type.FLOAT_TYPE),
    LONG(PrimitiveType.LONG, "long", "java.lang.Long", Type.LONG_TYPE),
    DOUBLE(PrimitiveType.DOUBLE, "double", "java.lang.Double", Type.DOUBLE_TYPE);

    private final PrimitiveType primitiveType;
    private final String name;
    private final JvmClassName wrapper;
    private final Type asmType;
    private final char jvmLetter;
    private final Type asmArrayType;
    private final JvmClassName iterator;

    private JvmPrimitiveType(PrimitiveType primitiveType, String name, String wrapperClassName, Type asmType) {
        this.primitiveType = primitiveType;
        this.name = name;
        this.wrapper = JvmClassName.byFqNameWithoutInnerClasses(wrapperClassName);
        this.asmType = asmType;
        this.jvmLetter = asmType.getDescriptor().charAt(0);
        this.asmArrayType = JvmPrimitiveType.makeArrayType(asmType);
        this.iterator = JvmClassName.byFqNameWithoutInnerClasses("jet." + primitiveType.getTypeName() + "Iterator");
    }

    private static Type makeArrayType(Type type) {
        StringBuilder sb = new StringBuilder(2);
        sb.append('[');
        sb.append(type.getDescriptor());
        return Type.getType(sb.toString());
    }

    public PrimitiveType getPrimitiveType() {
        return this.primitiveType;
    }

    public String getName() {
        return this.name;
    }

    public JvmClassName getWrapper() {
        return this.wrapper;
    }

    public Type getAsmType() {
        return this.asmType;
    }

    public Type getAsmArrayType() {
        return this.asmArrayType;
    }

    public JvmClassName getIterator() {
        return this.iterator;
    }

    public char getJvmLetter() {
        return this.jvmLetter;
    }

    @Nullable
    public static JvmPrimitiveType getByAsmType(Type type) {
        return (JvmPrimitiveType)((Object)MapByAsmTypeHolder.map.get(type.getSort()));
    }

    @Nullable
    public static JvmPrimitiveType getByWrapperAsmType(Type type) {
        return (JvmPrimitiveType)((Object)MapByWrapperAsmTypeHolder.map.get(type));
    }

    @Nullable
    public static JvmPrimitiveType getByWrapperClass(JvmClassName className) {
        return JvmPrimitiveType.getByWrapperAsmType(className.getAsmType());
    }

    private static class MapByWrapperAsmTypeHolder {
        private static final Map<Type, JvmPrimitiveType> map = new HashMap<Type, JvmPrimitiveType>();

        private MapByWrapperAsmTypeHolder() {
        }

        static {
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                map.put(jvmPrimitiveType.getWrapper().getAsmType(), jvmPrimitiveType);
            }
        }
    }

    private static class MapByAsmTypeHolder {
        private static final Map<Integer, JvmPrimitiveType> map = new HashMap<Integer, JvmPrimitiveType>();

        private MapByAsmTypeHolder() {
        }

        static {
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                map.put(jvmPrimitiveType.getAsmType().getSort(), jvmPrimitiveType);
            }
        }
    }
}

