/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.org.objectweb.asm.Type;
import org.jetbrains.jet.lang.resolve.name.FqName;

public class JvmClassName {
    @NotNull
    private final String internalName;
    private transient FqName fqName;
    private transient String descriptor;
    private transient Type asmType;

    private JvmClassName(@NotNull String internalName) {
        this.internalName = internalName;
    }

    @NotNull
    public static JvmClassName byInternalName(@NotNull String internalName) {
        return new JvmClassName(internalName);
    }

    @NotNull
    public static JvmClassName byType(@NotNull Type type) {
        if (type.getSort() != 10) {
            throw new IllegalArgumentException("must be an object to be converted to " + JvmClassName.class.getSimpleName());
        }
        return JvmClassName.byInternalName(type.getInternalName());
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull FqName fqName) {
        JvmClassName r = new JvmClassName(fqName.getFqName().replace('.', '/'));
        r.fqName = fqName;
        return r;
    }

    @NotNull
    public static JvmClassName byFqNameWithoutInnerClasses(@NotNull String fqName) {
        return JvmClassName.byFqNameWithoutInnerClasses(new FqName(fqName));
    }

    @NotNull
    public FqName getFqName() {
        if (this.fqName == null) {
            this.fqName = new FqName(this.internalName.replace('$', '.').replace('/', '.'));
        }
        return this.fqName;
    }

    @NotNull
    public String getInternalName() {
        return this.internalName;
    }

    @NotNull
    public String getDescriptor() {
        if (this.descriptor == null) {
            StringBuilder sb = new StringBuilder(this.internalName.length() + 2);
            sb.append('L');
            sb.append(this.internalName);
            sb.append(';');
            this.descriptor = sb.toString();
        }
        return this.descriptor;
    }

    @NotNull
    public Type getAsmType() {
        if (this.asmType == null) {
            this.asmType = Type.getType(this.getDescriptor());
        }
        return this.asmType;
    }

    public String toString() {
        return this.getInternalName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JvmClassName name = (JvmClassName)o;
        return this.internalName.equals(name.internalName);
    }

    public int hashCode() {
        return this.internalName.hashCode();
    }
}

