/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.google.common.collect.Sets;
import org.jetbrains.jet.internal.com.intellij.psi.PsiArrayType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiCapturedWildcardType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClassType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPrimitiveType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiType;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameter;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeParameterListOwner;
import org.jetbrains.jet.internal.com.intellij.psi.PsiTypeVisitor;
import org.jetbrains.jet.internal.com.intellij.psi.PsiWildcardType;
import org.jetbrains.jet.internal.javax.inject.Inject;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JetTypeJetSignatureReader;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.SubstitutionUtils;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.lang.JetStandardClasses;
import org.jetbrains.jet.lang.types.lang.JetStandardLibrary;
import org.jetbrains.jet.lang.types.lang.PrimitiveType;
import org.jetbrains.jet.rt.signature.JetSignatureReader;

public class JavaTypeTransformer {
    private JavaSemanticServices javaSemanticServices;
    private JavaDescriptorResolver resolver;
    private Map<String, JetType> primitiveTypesMap;
    private Map<FqName, JetType> classTypesMap;
    private HashMap<FqName, ClassDescriptor> classDescriptorMap;

    @Inject
    public void setJavaSemanticServices(JavaSemanticServices javaSemanticServices) {
        this.javaSemanticServices = javaSemanticServices;
    }

    @Inject
    public void setResolver(JavaDescriptorResolver resolver) {
        this.resolver = resolver;
    }

    @NotNull
    private TypeProjection transformToTypeProjection(@NotNull PsiType javaType, final @NotNull TypeParameterDescriptor typeParameterDescriptor, final @NotNull TypeVariableResolver typeVariableByPsiResolver, final @NotNull TypeUsage howThisTypeIsUsed) {
        TypeProjection result = javaType.accept(new PsiTypeVisitor<TypeProjection>(){

            @Override
            public TypeProjection visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                throw new UnsupportedOperationException();
            }

            @Override
            public TypeProjection visitWildcardType(PsiWildcardType wildcardType) {
                if (!wildcardType.isBounded()) {
                    return SubstitutionUtils.makeStarProjection(typeParameterDescriptor);
                }
                Variance variance = wildcardType.isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
                PsiType bound = wildcardType.getBound();
                assert (bound != null);
                return new TypeProjection(variance, JavaTypeTransformer.this.transformToType(bound, TypeUsage.UPPER_BOUND, typeVariableByPsiResolver));
            }

            @Override
            public TypeProjection visitType(PsiType type) {
                return new TypeProjection(JavaTypeTransformer.this.transformToType(type, howThisTypeIsUsed, typeVariableByPsiResolver));
            }
        });
        return result;
    }

    @NotNull
    public JetType transformToType(@NotNull String kotlinSignature, TypeVariableResolver typeVariableResolver) {
        final JetType[] r = new JetType[1];
        JetTypeJetSignatureReader reader = new JetTypeJetSignatureReader(this.javaSemanticServices, JetStandardLibrary.getInstance(), typeVariableResolver){

            @Override
            protected void done(@NotNull JetType jetType) {
                r[0] = jetType;
            }
        };
        new JetSignatureReader(kotlinSignature).acceptType(reader);
        return r[0];
    }

    @NotNull
    public JetType transformToType(@NotNull PsiType javaType, @NotNull TypeVariableResolver typeVariableResolver) {
        return this.transformToType(javaType, TypeUsage.MEMBER_SIGNATURE_INVARIANT, typeVariableResolver);
    }

    @NotNull
    public JetType transformToType(@NotNull PsiType javaType, final @NotNull TypeUsage howThisTypeIsUsed, final @NotNull TypeVariableResolver typeVariableResolver) {
        return javaType.accept(new PsiTypeVisitor<JetType>(){

            @Override
            public JetType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                if (psiClass == null) {
                    return ErrorUtils.createErrorType("Unresolved java class: " + classType.getPresentableText());
                }
                if (psiClass instanceof PsiTypeParameter) {
                    boolean nullable;
                    PsiMethod psiMethod;
                    PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                    PsiTypeParameterListOwner typeParameterListOwner = typeParameter.getOwner();
                    if (typeParameterListOwner instanceof PsiMethod && (psiMethod = (PsiMethod)typeParameterListOwner).isConstructor()) {
                        HashSet<JetType> supertypesJet = Sets.newHashSet();
                        for (PsiClassType supertype : typeParameter.getExtendsListTypes()) {
                            supertypesJet.add(JavaTypeTransformer.this.transformToType(supertype, TypeUsage.UPPER_BOUND, typeVariableResolver));
                        }
                        return TypeUtils.intersect(JetTypeChecker.INSTANCE, supertypesJet);
                    }
                    TypeParameterDescriptor typeParameterDescriptor = typeVariableResolver.getTypeVariable(typeParameter.getName());
                    boolean bl = nullable = !EnumSet.of(TypeUsage.TYPE_ARGUMENT, TypeUsage.UPPER_BOUND, TypeUsage.SUPERTYPE_ARGUMENT).contains((Object)howThisTypeIsUsed);
                    if (nullable) {
                        return TypeUtils.makeNullable(typeParameterDescriptor.getDefaultType());
                    }
                    return typeParameterDescriptor.getDefaultType();
                }
                boolean nullable = !EnumSet.of(TypeUsage.SUPERTYPE_ARGUMENT, TypeUsage.SUPERTYPE).contains((Object)howThisTypeIsUsed);
                JetType jetAnalog = JavaTypeTransformer.this.getKotlinAnalog(new FqName(psiClass.getQualifiedName()));
                if (jetAnalog != null) {
                    return TypeUtils.makeNullableAsSpecified(jetAnalog, nullable);
                }
                ClassDescriptor classData = JavaTypeTransformer.this.resolver.resolveClass(new FqName(psiClass.getQualifiedName()), DescriptorSearchRule.INCLUDE_KOTLIN);
                if (classData == null) {
                    return ErrorUtils.createErrorType("Unresolved java class: " + classType.getPresentableText());
                }
                ArrayList<TypeProjection> arguments = Lists.newArrayList();
                if (classType.isRaw()) {
                    List<TypeParameterDescriptor> parameters = classData.getTypeConstructor().getParameters();
                    for (TypeParameterDescriptor parameter : parameters) {
                        arguments.add(SubstitutionUtils.makeStarProjection(parameter));
                    }
                } else {
                    List<TypeParameterDescriptor> parameters = classData.getTypeConstructor().getParameters();
                    PsiType[] psiArguments = classType.getParameters();
                    if (parameters.size() != psiArguments.length) {
                        throw new IllegalStateException("parameters = " + parameters.size() + ", actual arguments = " + psiArguments.length + " in " + classType.getPresentableText());
                    }
                    for (int i = 0; i < parameters.size(); ++i) {
                        PsiType psiArgument = psiArguments[i];
                        TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
                        TypeUsage howTheProjectionIsUsed = howThisTypeIsUsed == TypeUsage.SUPERTYPE ? TypeUsage.SUPERTYPE_ARGUMENT : TypeUsage.TYPE_ARGUMENT;
                        arguments.add(JavaTypeTransformer.this.transformToTypeProjection(psiArgument, typeParameterDescriptor, typeVariableResolver, howTheProjectionIsUsed));
                    }
                }
                return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), classData.getTypeConstructor(), nullable, arguments, classData.getMemberScope(arguments));
            }

            @Override
            public JetType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                String canonicalText = primitiveType.getCanonicalText();
                JetType type = JavaTypeTransformer.this.getPrimitiveTypesMap().get(canonicalText);
                assert (type != null) : canonicalText;
                return type;
            }

            @Override
            public JetType visitArrayType(PsiArrayType arrayType) {
                JetType jetType;
                PsiType componentType = arrayType.getComponentType();
                if (componentType instanceof PsiPrimitiveType && (jetType = JavaTypeTransformer.this.getPrimitiveTypesMap().get("[" + componentType.getCanonicalText())) != null) {
                    return TypeUtils.makeNullable(jetType);
                }
                JetType type = JavaTypeTransformer.this.transformToType(componentType, typeVariableResolver);
                return TypeUtils.makeNullable(JetStandardLibrary.getInstance().getArrayType(type));
            }

            @Override
            public JetType visitType(PsiType type) {
                throw new UnsupportedOperationException("Unsupported type: " + type.getPresentableText());
            }
        });
    }

    public Map<String, JetType> getPrimitiveTypesMap() {
        if (this.primitiveTypesMap == null) {
            this.primitiveTypesMap = new HashMap<String, JetType>();
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
                this.primitiveTypesMap.put(jvmPrimitiveType.getName(), JetStandardLibrary.getInstance().getPrimitiveJetType(primitiveType));
                this.primitiveTypesMap.put("[" + jvmPrimitiveType.getName(), JetStandardLibrary.getInstance().getPrimitiveArrayJetType(primitiveType));
                this.primitiveTypesMap.put(jvmPrimitiveType.getWrapper().getFqName().getFqName(), JetStandardLibrary.getInstance().getNullablePrimitiveJetType(primitiveType));
            }
            this.primitiveTypesMap.put("void", JetStandardClasses.getUnitType());
        }
        return this.primitiveTypesMap;
    }

    public Map<FqName, JetType> getClassTypesMap() {
        if (this.classTypesMap == null) {
            this.classTypesMap = new HashMap<FqName, JetType>();
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
                this.classTypesMap.put(jvmPrimitiveType.getWrapper().getFqName(), JetStandardLibrary.getInstance().getNullablePrimitiveJetType(primitiveType));
            }
            this.classTypesMap.put(new FqName("java.lang.Object"), JetStandardClasses.getNullableAnyType());
            this.classTypesMap.put(new FqName("java.lang.String"), JetStandardLibrary.getInstance().getNullableStringType());
            this.classTypesMap.put(new FqName("java.lang.CharSequence"), JetStandardLibrary.getInstance().getNullableCharSequenceType());
            this.classTypesMap.put(new FqName("java.lang.Throwable"), JetStandardLibrary.getInstance().getNullableThrowableType());
        }
        return this.classTypesMap;
    }

    @Nullable
    public JetType getKotlinAnalog(@NotNull FqName fqName) {
        return this.getClassTypesMap().get(fqName);
    }

    private Map<FqName, ClassDescriptor> getPrimitiveWrappersClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            this.classDescriptorMap = new HashMap();
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
                this.classDescriptorMap.put(jvmPrimitiveType.getWrapper().getFqName(), JetStandardLibrary.getInstance().getPrimitiveClassDescriptor(primitiveType));
            }
            this.classDescriptorMap.put(new FqName("java.lang.String"), JetStandardLibrary.getInstance().getString());
            this.classDescriptorMap.put(new FqName("java.lang.CharSequence"), JetStandardLibrary.getInstance().getCharSequence());
            this.classDescriptorMap.put(new FqName("java.lang.Throwable"), JetStandardLibrary.getInstance().getThrowable());
        }
        return this.classDescriptorMap;
    }

    @Nullable
    public ClassDescriptor unwrapPrimitive(@NotNull FqName fqName) {
        return this.getPrimitiveWrappersClassDescriptorMap().get(fqName);
    }

    public static enum TypeUsage {
        TYPE_ARGUMENT,
        UPPER_BOUND,
        MEMBER_SIGNATURE_COVARIANT,
        MEMBER_SIGNATURE_CONTRAVARIANT,
        MEMBER_SIGNATURE_INVARIANT,
        SUPERTYPE,
        SUPERTYPE_ARGUMENT;

    }
}

