/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.internal.com.google.common.collect.Lists;
import org.jetbrains.jet.internal.com.intellij.core.CoreJavaFileManager;
import org.jetbrains.jet.internal.com.intellij.openapi.progress.ProgressIndicatorProvider;
import org.jetbrains.jet.internal.com.intellij.openapi.project.Project;
import org.jetbrains.jet.internal.com.intellij.psi.PsiClass;
import org.jetbrains.jet.internal.com.intellij.psi.PsiElementFinder;
import org.jetbrains.jet.internal.com.intellij.psi.PsiPackage;
import org.jetbrains.jet.internal.com.intellij.psi.impl.file.impl.JavaFileManager;
import org.jetbrains.jet.internal.com.intellij.psi.search.GlobalSearchScope;

public class JavaPsiFacadeKotlinHacks {
    private final JavaFileManager javaFileManager;
    private final List<PsiElementFinder> extensionPsiElementFinders;

    public JavaPsiFacadeKotlinHacks(@NotNull Project project) {
        this.javaFileManager = this.findJavaFileManager(project);
        this.extensionPsiElementFinders = Lists.newArrayList();
        for (PsiElementFinder finder : project.getExtensions(PsiElementFinder.EP_NAME)) {
            if (finder instanceof KotlinFinderMarker) continue;
            this.extensionPsiElementFinders.add(finder);
        }
    }

    @NotNull
    private JavaFileManager findJavaFileManager(@NotNull Project project) {
        JavaFileManager javaFileManager = project.getComponent(JavaFileManager.class);
        if (javaFileManager != null) {
            return javaFileManager;
        }
        javaFileManager = project.getComponent(CoreJavaFileManager.class);
        if (javaFileManager != null) {
            return javaFileManager;
        }
        throw new IllegalStateException("JavaFileManager component is not found in project");
    }

    @Nullable
    public PsiPackage findPackage(@NotNull String qualifiedName) {
        PsiPackage psiPackage = this.javaFileManager.findPackage(qualifiedName);
        if (psiPackage != null) {
            return psiPackage;
        }
        for (PsiElementFinder finder : this.extensionPsiElementFinders) {
            psiPackage = finder.findPackage(qualifiedName);
            if (psiPackage == null) continue;
            return psiPackage;
        }
        return psiPackage;
    }

    public PsiClass findClass(@NotNull String qualifiedName, @NotNull GlobalSearchScope scope) {
        ProgressIndicatorProvider.checkCanceled();
        PsiClass aClass = this.javaFileManager.findClass(qualifiedName, scope);
        if (aClass != null) {
            return aClass;
        }
        for (PsiElementFinder finder : this.extensionPsiElementFinders) {
            aClass = finder.findClass(qualifiedName, scope);
            if (aClass == null) continue;
            return aClass;
        }
        return null;
    }

    public static interface KotlinFinderMarker {
    }
}

