/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.java.DescriptorSearchRule;
import org.jetbrains.jet.lang.resolve.java.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.JavaClassOrPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.name.FqName;
import org.jetbrains.jet.lang.resolve.name.Name;

public class JavaPackageScope
extends JavaClassOrPackageScope {
    @NotNull
    private final FqName packageFQN;

    public JavaPackageScope(@NotNull FqName packageFQN, @NotNull JavaSemanticServices semanticServices, @NotNull JavaDescriptorResolver.ResolverScopeData resolverNamespaceData) {
        super(semanticServices, resolverNamespaceData);
        this.packageFQN = packageFQN;
        if (!resolverNamespaceData.staticMembers) {
            throw new IllegalArgumentException("instance members should be resolved using " + JavaClassMembersScope.class);
        }
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull Name name) {
        ClassDescriptor classDescriptor = this.semanticServices.getDescriptorResolver().resolveClass(this.packageFQN.child(name), DescriptorSearchRule.IGNORE_IF_FOUND_IN_KOTLIN);
        if (classDescriptor == null || DescriptorUtils.isObject(classDescriptor)) {
            return null;
        }
        return classDescriptor;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull Name name) {
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull Name name) {
        return this.semanticServices.getDescriptorResolver().resolveNamespace(this.packageFQN.child(name), DescriptorSearchRule.INCLUDE_KOTLIN);
    }
}

