/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.internal.com.intellij.psi.PsiField;
import org.jetbrains.jet.internal.com.intellij.psi.PsiMethod;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.PropertyAccessorData;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.java.TypeSource;
import org.jetbrains.jet.lang.resolve.java.prop.PropertyNameUtils;
import org.jetbrains.jet.lang.resolve.java.prop.PropertyParseResult;
import org.jetbrains.jet.lang.resolve.name.Name;

class JavaDescriptorResolverHelper {
    private JavaDescriptorResolverHelper() {
    }

    @NotNull
    static Map<Name, NamedMembers> getNamedMembers(@NotNull JavaDescriptorResolver.ResolverScopeData resolverScopeData) {
        if (resolverScopeData.psiClass != null) {
            Builder builder = new Builder(new PsiClassWrapper(resolverScopeData.psiClass), resolverScopeData.staticMembers, resolverScopeData.kotlin);
            builder.run();
            return builder.namedMembersMap;
        }
        return Collections.emptyMap();
    }

    private static class Builder {
        private final PsiClassWrapper psiClass;
        private final boolean staticMembers;
        private final boolean kotlin;
        private Map<Name, NamedMembers> namedMembersMap = new HashMap<Name, NamedMembers>();

        private Builder(PsiClassWrapper psiClass, boolean staticMembers, boolean kotlin) {
            this.psiClass = psiClass;
            this.staticMembers = staticMembers;
            this.kotlin = kotlin;
        }

        public void run() {
            this.processFields();
            this.processMethods();
        }

        private NamedMembers getNamedMembers(Name name) {
            NamedMembers r = this.namedMembersMap.get(name);
            if (r == null) {
                r = new NamedMembers();
                r.name = name;
                this.namedMembersMap.put(name, r);
            }
            return r;
        }

        private boolean includeMember(PsiMemberWrapper member) {
            if (member.isStatic() != this.staticMembers) {
                return false;
            }
            if (member.getPsiMember().getContainingClass() != this.psiClass.getPsiClass()) {
                return false;
            }
            return !member.isPrivate();
        }

        private void processFields() {
            if (!this.kotlin) {
                for (PsiField field0 : this.psiClass.getPsiClass().getAllFields()) {
                    PsiFieldWrapper field = new PsiFieldWrapper(field0);
                    NamedMembers namedMembers = this.getNamedMembers(Name.identifier(field.getName()));
                    if (!this.includeMember(field)) continue;
                    TypeSource type = new TypeSource("", field.getType(), field0);
                    namedMembers.addPropertyAccessor(new PropertyAccessorData(field, type, null));
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        private void processMethods() {
            for (PsiMethod method : this.psiClass.getPsiClass().getAllMethods()) {
                this.getNamedMembers(Name.identifier(method.getName()));
                PropertyParseResult propertyParseResult = PropertyNameUtils.parseMethodToProperty(method.getName());
                if (propertyParseResult == null) continue;
                this.getNamedMembers(Name.identifier(propertyParseResult.getPropertyName()));
            }
            PsiMethod[] arr$ = this.psiClass.getPsiClass().getMethods();
            int len$ = arr$.length;
            int i$ = 0;
            while (i$ < len$) {
                PsiMethod method0 = arr$[i$];
                PsiMethodWrapper method = new PsiMethodWrapper(method0);
                if (this.includeMember(method)) {
                    TypeSource receiverType;
                    int i;
                    NamedMembers members;
                    String propertyName;
                    PropertyParseResult propertyParseResult = PropertyNameUtils.parseMethodToProperty(method.getName());
                    if (propertyParseResult != null && propertyParseResult.isGetter()) {
                        propertyName = propertyParseResult.getPropertyName();
                        members = this.getNamedMembers(Name.identifier(propertyName));
                        if (method.getJetMethod().flags().get(0)) {
                            i = 0;
                            if (i < method.getParameters().size() && method.getParameter(i).getJetValueParameter().receiver()) {
                                PsiParameterWrapper receiverParameter = method.getParameter(i);
                                receiverType = new TypeSource(receiverParameter.getJetValueParameter().type(), receiverParameter.getPsiParameter().getType(), receiverParameter.getPsiParameter());
                                ++i;
                            } else {
                                receiverType = null;
                            }
                            while (i < method.getParameters().size() && method.getParameter(i).getJetTypeParameter().isDefined()) {
                                ++i;
                            }
                            if (i != method.getParameters().size()) {
                                throw new IllegalStateException("something is wrong with method " + method0);
                            }
                            TypeSource propertyType = new TypeSource(method.getJetMethod().propertyType(), method.getReturnType(), method.getPsiMethod());
                            members.addPropertyAccessor(new PropertyAccessorData(method, true, propertyType, receiverType));
                        } else if (this.kotlin) {
                            // empty if block
                        }
                    } else if (propertyParseResult != null && !propertyParseResult.isGetter()) {
                        propertyName = propertyParseResult.getPropertyName();
                        members = this.getNamedMembers(Name.identifier(propertyName));
                        if (method.getJetMethod().flags().get(0)) {
                            if (method.getParameters().size() == 0) {
                                throw new IllegalStateException();
                            }
                            i = 0;
                            receiverType = null;
                            PsiParameterWrapper p1 = method.getParameter(0);
                            if (p1.getJetValueParameter().receiver()) {
                                receiverType = new TypeSource(p1.getJetValueParameter().type(), p1.getPsiParameter().getType(), p1.getPsiParameter());
                                ++i;
                            }
                            while (i < method.getParameters().size() && method.getParameter(i).getJetTypeParameter().isDefined()) {
                                ++i;
                            }
                            if (i + 1 != method.getParameters().size()) {
                                throw new IllegalStateException();
                            }
                            PsiParameterWrapper propertyTypeParameter = method.getParameter(i);
                            TypeSource propertyType = new TypeSource(method.getJetMethod().propertyType(), propertyTypeParameter.getPsiParameter().getType(), propertyTypeParameter.getPsiParameter());
                            members.addPropertyAccessor(new PropertyAccessorData(method, false, propertyType, receiverType));
                        } else if (!this.kotlin) {
                            // empty if block
                        }
                    }
                    if (!method.getJetMethod().flags().get(0)) {
                        NamedMembers namedMembers = this.getNamedMembers(Name.identifier(method.getName()));
                        namedMembers.addMethod(method);
                    }
                }
                ++i$;
            }
            return;
        }
    }
}

